/*
 * Decompiled with CFR 0.152.
 */
package com.keybindsOverlay;

import com.keybindsOverlay.KeybindsOverlayConfig;
import com.keybindsOverlay.sidePanelTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.client.config.Keybind;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class KeybindsOverlayOverlay
extends Overlay {
    private final KeybindsOverlayConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private KeybindsOverlayOverlay(KeybindsOverlayConfig config) {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setPriority(OverlayPriority.HIGH);
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        this.panelComponent.setOrientation(ComponentOrientation.HORIZONTAL);
        this.panelComponent.setGap(new Point(20, 0));
        for (sidePanelTab tab : this.getOrderOfTabs()) {
            if (!this.isKeybindingDefined(this.getKeybinding(tab))) continue;
            this.addTabToPanel(tab);
        }
        return this.panelComponent.render(graphics);
    }

    private void addLine(String text) {
        this.panelComponent.getChildren().add(LineComponent.builder().right(text.substring(0, Math.min(3, text.length())).toUpperCase()).rightColor(Color.PINK).build());
    }

    private void addIcon(BufferedImage icon) {
        this.panelComponent.getChildren().add(new ImageComponent(icon));
    }

    private void addTabToPanel(sidePanelTab tab) {
        this.addIcon(tab.getIcon());
        this.addKeybinding(this.getKeybinding(tab));
    }

    private Keybind getKeybinding(sidePanelTab tab) {
        Keybind keybind;
        try {
            keybind = (Keybind)tab.getKeybindingMethod().invoke((Object)this.config, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            keybind = new Keybind(0, 0);
        }
        return keybind;
    }

    private int getLocation(sidePanelTab tab) {
        int location;
        try {
            location = (Integer)tab.getLocationMethod().invoke((Object)this.config, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Random random = new Random();
            location = 20 + random.nextInt(14);
        }
        return location;
    }

    private void addKeybinding(Keybind keybind) {
        this.addLine(String.valueOf(keybind));
    }

    private boolean isKeybindingDefined(Keybind keybind) {
        return keybind.getKeyCode() != 0;
    }

    private Set<sidePanelTab> getOrderOfTabs() {
        HashMap<sidePanelTab, Integer> orderOfTabs = new HashMap<sidePanelTab, Integer>();
        for (sidePanelTab tab : sidePanelTab.values()) {
            orderOfTabs.merge(tab, this.getLocation(tab), (oldVale, newValue) -> newValue);
            this.getLocation(tab);
        }
        return orderOfTabs.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)).keySet();
    }
}

