/*
 * Decompiled with CFR 0.152.
 */
package com.thenorsepantheon.profiles.ui;

import com.thenorsepantheon.profiles.ui.Fields;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class TextField
extends JTextField {
    private final TextField self = this;
    private final String placeholder;

    public TextField(String placeholder) {
        super(placeholder);
        this.placeholder = placeholder;
        this.setPreferredSize(Fields.PREFERRED_SIZE);
        this.setMinimumSize(Fields.MINIMUM_SIZE);
        this.setForeground(Fields.FOREGROUND_COLOUR);
        this.setBackground(Fields.BACKGROUND_COLOUR);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (TextField.this.self.getText().equals(TextField.this.self.placeholder)) {
                    TextField.this.self.setText("");
                    TextField.this.self.setForeground(Fields.ACTIVE_COLOUR);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (TextField.this.self.getText().isEmpty()) {
                    TextField.this.self.setText(TextField.this.self.placeholder);
                    TextField.this.self.setForeground(Fields.FOREGROUND_COLOUR);
                }
            }
        });
        this.addMouseListener(Fields.getHoverAdapter(this));
    }

    public void resetState() {
        this.setText(this.placeholder);
        this.setForeground(Fields.FOREGROUND_COLOUR);
    }
}

