/*
 * Decompiled with CFR 0.152.
 */
package com.thenorsepantheon.profiles.ui;

import com.thenorsepantheon.profiles.ui.Fields;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPasswordField;

public class PasswordField
extends JPasswordField {
    private final PasswordField self = this;
    private final String placeholder;
    private boolean obfuscate;

    public PasswordField(String placeholder) {
        this(placeholder, true);
    }

    public PasswordField(String placeholder, boolean obfuscate) {
        super(placeholder);
        this.placeholder = placeholder;
        this.obfuscate = obfuscate;
        this.setEchoChar('\u0000');
        this.setPreferredSize(Fields.PREFERRED_SIZE);
        this.setMinimumSize(Fields.MINIMUM_SIZE);
        this.setForeground(Fields.FOREGROUND_COLOUR);
        this.setBackground(Fields.BACKGROUND_COLOUR);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (PasswordField.this.self.placeholder.equals(String.valueOf(PasswordField.this.self.getPassword()))) {
                    PasswordField.this.self.setText("");
                    PasswordField.this.self.setForeground(Fields.ACTIVE_COLOUR);
                    if (PasswordField.this.self.obfuscate) {
                        PasswordField.this.self.setEchoChar('*');
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (PasswordField.this.self.getPassword().length == 0) {
                    PasswordField.this.self.setText(PasswordField.this.self.placeholder);
                    PasswordField.this.self.setEchoChar('\u0000');
                    PasswordField.this.self.setForeground(Fields.FOREGROUND_COLOUR);
                }
            }
        });
        this.addMouseListener(Fields.getHoverAdapter(this));
    }

    public void resetState() {
        this.setText(this.placeholder);
        this.setEchoChar('\u0000');
        this.setForeground(Fields.FOREGROUND_COLOUR);
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }
}

