/*
 * Decompiled with CFR 0.152.
 */
package com.thenorsepantheon.profiles;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.thenorsepantheon.profiles.Profile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.runelite.client.RuneLite;

public class ProfilesStorage {
    private static final File PROFILES = new File(RuneLite.RUNELITE_DIR, "profiles");

    static void saveProfiles() throws IOException {
        File file = new File(PROFILES, "profiles.json");
        Gson gson = new Gson();
        FileWriter writer = new FileWriter(file);
        gson.toJson(Profile.getProfiles(), (Appendable)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    static void loadProfiles() throws IOException {
        File file = new File(PROFILES, "profiles.json");
        if (!file.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write("[]");
            }
        }
        Gson gson = new Gson();
        List profiles = (List)gson.fromJson((Reader)new FileReader(file), new TypeToken<List<Profile>>(){}.getType());
        profiles.forEach(p -> new Profile(p.getLabel(), p.getLogin()));
    }

    static {
        PROFILES.mkdirs();
    }
}

