/*
 * Decompiled with CFR 0.152.
 */
package com.thenorsepantheon.profiles;

import com.google.inject.Provides;
import com.thenorsepantheon.profiles.ProfilesConfig;
import com.thenorsepantheon.profiles.ProfilesPanel;
import com.thenorsepantheon.profiles.ProfilesStorage;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Profiles")
public class ProfilesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ProfilesPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ProfilesConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    private ProfilesPanel panel;
    private NavigationButton navButton;

    @Provides
    ProfilesConfig provideConfig(ConfigManager configManager) {
        return (ProfilesConfig)configManager.getConfig(ProfilesConfig.class);
    }

    protected void startUp() throws Exception {
        ProfilesStorage.loadProfiles();
        this.panel = new ProfilesPanel(this.client, this.config);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"profiles_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Profiles").priority(8).icon(icon).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("profiles")) {
            this.panel.redrawProfiles();
        }
    }
}

