/*
 * Decompiled with CFR 0.152.
 */
package com.thenorsepantheon.profiles;

import com.thenorsepantheon.profiles.Profile;
import com.thenorsepantheon.profiles.ProfilePanel;
import com.thenorsepantheon.profiles.ProfilesConfig;
import com.thenorsepantheon.profiles.ProfilesStorage;
import com.thenorsepantheon.profiles.ui.Button;
import com.thenorsepantheon.profiles.ui.PasswordField;
import com.thenorsepantheon.profiles.ui.TextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProfilesPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ProfilesPanel.class);
    private static final String ACCOUNT_USERNAME = "Account Username";
    private static final String ACCOUNT_LABEL = "Account Label";
    private final Client client;
    private static ProfilesConfig profilesConfig;
    private final TextField txtAccountLabel = new TextField("Account Label");
    private final PasswordField txtAccountLogin;
    private final JPanel profilesPanel = new JPanel();
    private final GridBagConstraints c;

    @Inject
    public ProfilesPanel(Client client, ProfilesConfig config) {
        this.client = client;
        profilesConfig = config;
        this.setBorder(new EmptyBorder(18, 10, 0, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(0, 0, 3, 0);
        this.add(this.txtAccountLabel, this.c);
        ++this.c.gridy;
        this.txtAccountLogin = new PasswordField(ACCOUNT_USERNAME, profilesConfig.isStreamerMode());
        this.add(this.txtAccountLogin, this.c);
        ++this.c.gridy;
        this.c.insets = new Insets(0, 0, 15, 0);
        final Button btnAddAccount = new Button("Add Account");
        btnAddAccount.addActionListener(e -> {
            String labelText = this.txtAccountLabel.getText();
            String loginText = String.valueOf(this.txtAccountLogin.getPassword());
            if (labelText.equals(ACCOUNT_LABEL) || loginText.equals(ACCOUNT_USERNAME)) {
                return;
            }
            Profile profile = new Profile(labelText, loginText);
            this.addProfile(profile);
            try {
                ProfilesStorage.saveProfiles();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.txtAccountLabel.resetState();
            this.txtAccountLogin.resetState();
        });
        this.txtAccountLogin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    btnAddAccount.doClick();
                    btnAddAccount.requestFocus();
                }
            }
        });
        this.add(btnAddAccount, this.c);
        ++this.c.gridy;
        this.profilesPanel.setLayout(new GridBagLayout());
        this.add(this.profilesPanel, this.c);
        this.c.gridy = 0;
        this.c.insets = new Insets(0, 0, 5, 0);
        Profile.getProfiles().forEach(this::addProfile);
    }

    void redrawProfiles() {
        this.txtAccountLogin.setObfuscate(profilesConfig.isStreamerMode());
        this.profilesPanel.removeAll();
        this.c.gridy = 0;
        Profile.getProfiles().forEach(this::addProfile);
    }

    private void addProfile(Profile profile) {
        ProfilePanel profilePanel = new ProfilePanel(this.client, profile, profilesConfig, this);
        ++this.c.gridy;
        this.profilesPanel.add((Component)profilePanel, this.c);
        this.revalidate();
        this.repaint();
    }
}

