/*
 * Decompiled with CFR 0.152.
 */
package com.maxskilltrim;

import com.google.inject.Provides;
import com.maxskilltrim.MaxSkillTrimConfig;
import com.maxskilltrim.MaxSkillTrimPanel;
import com.maxskilltrim.SkillData;
import com.maxskilltrim.Trim;
import com.maxskilltrim.TrimType;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.JavaScriptCallback;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Max Skill Trim")
public class MaxSkillTrimPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MaxSkillTrimPlugin.class);
    private static final Trim maxLevelTrim = new Trim(-666, TrimType.MAX_LEVEL);
    private static final Trim maxExperienceTrim = new Trim(-667, TrimType.MAX_EXPERIENCE);
    private MaxSkillTrimPanel maxSkillTrimPanel;
    @Inject
    private MaxSkillTrimConfig maxSkillTrimConfig;
    private NavigationButton navButton;
    @Inject
    private ClientToolbar pluginToolbar;
    public static final File MAXSKILLTRIMS_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "max-skill-trims");
    private static final int SCRIPTID_STATS_INIT = 393;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private Widget currentWidget;
    private final Widget[] maxLevelTrimWidgets = new Widget[SkillData.values().length];
    private final Widget[] maxExperienceTrimWidgets = new Widget[SkillData.values().length];

    @Provides
    MaxSkillTrimConfig provideConfig(ConfigManager configManager) {
        return (MaxSkillTrimConfig)configManager.getConfig(MaxSkillTrimConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() throws Exception {
        if (!MAXSKILLTRIMS_DIR.exists()) {
            MAXSKILLTRIMS_DIR.mkdirs();
        }
        this.addDefaultTrims();
        this.maxSkillTrimPanel = (MaxSkillTrimPanel)((Object)this.injector.getInstance(MaxSkillTrimPanel.class));
        Class<ImageIO> clazz = ImageIO.class;
        synchronized (ImageIO.class) {
            BufferedImage icon = ImageIO.read(Objects.requireNonNull(((Object)((Object)this)).getClass().getResourceAsStream("/icon.png")));
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.navButton = NavigationButton.builder().tooltip("Max Skill Trim").priority(5).icon(icon).panel((PluginPanel)this.maxSkillTrimPanel).build();
            if (this.maxSkillTrimConfig.getShowNavButton()) {
                this.pluginToolbar.addNavigation(this.navButton);
            }
            this.overrideSprites(maxLevelTrim, this.maxSkillTrimConfig.getSelectedMaxLevelTrimFilename());
            this.overrideSprites(maxExperienceTrim, this.maxSkillTrimConfig.getSelectedMaxExperienceTrimFilename());
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.clientThread.invoke(this::buildTrimWidgetContainers);
            }
            return;
        }
    }

    protected void shutDown() throws Exception {
        this.pluginToolbar.removeNavigation(this.navButton);
        this.clientThread.invoke(() -> {
            this.removeTrimWidgetContainers(this.maxLevelTrimWidgets);
            this.removeTrimWidgetContainers(this.maxExperienceTrimWidgets);
        });
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (event.getScriptId() != 393) {
            return;
        }
        this.currentWidget = event.getScriptEvent().getSource();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 393 && this.currentWidget != null) {
            this.buildTrim(this.currentWidget);
        }
    }

    private void buildTrimWidgetContainers() {
        Widget skillsContainer = this.client.getWidget(WidgetInfo.SKILLS_CONTAINER);
        if (skillsContainer == null) {
            return;
        }
        for (Widget skillTile : skillsContainer.getStaticChildren()) {
            this.buildTrim(skillTile);
        }
    }

    private void removeTrimWidgetContainers(Widget[] trims) {
        for (Widget trim : trims) {
            if (trim == null) continue;
            Widget[] children = trim.getParent().getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (trim != children[i]) continue;
                children[i] = null;
            }
        }
    }

    private void buildTrim(Widget parent) {
        int idx = WidgetInfo.TO_CHILD((int)parent.getId()) - 1;
        SkillData skill = SkillData.get(idx);
        if (skill == null) {
            return;
        }
        this.maxLevelTrimWidgets[idx] = this.createWidget(parent, skill, maxLevelTrim);
        this.maxExperienceTrimWidgets[idx] = this.createWidget(parent, skill, maxExperienceTrim);
    }

    private Widget createWidget(Widget parent, SkillData skill, Trim trim) {
        Widget t = parent.createChild(-1, 5).setYPositionMode(0).setOriginalHeight(parent.getOriginalHeight()).setOriginalWidth(parent.getOriginalWidth()).setWidthMode(parent.getWidthMode()).setHeightMode(parent.getHeightMode()).setOpacity(255).setSpriteId(trim.spriteID).setHasListener(true);
        JavaScriptCallback cb = ev -> this.updateTrim(skill, t, trim);
        t.setOnVarTransmitListener(new Object[]{cb});
        t.revalidate();
        return t;
    }

    private void updateTrim(SkillData skill, Widget widget, Trim trim) {
        int currentXP = this.client.getSkillExperience(skill.getSkill());
        boolean isMaxExperience = currentXP >= 200000000;
        int currentLevel = Experience.getLevelForXp((int)currentXP);
        switch (trim.trimType) {
            case MAX_LEVEL: {
                if (!this.maxSkillTrimConfig.showMaxLevelTrim() || isMaxExperience && this.maxSkillTrimConfig.getShowMaxExperienceTrim()) {
                    widget.setOpacity(255);
                    break;
                }
                if (currentLevel < 99) break;
                widget.setOpacity(0);
                break;
            }
            case MAX_EXPERIENCE: {
                if (!this.maxSkillTrimConfig.getShowMaxExperienceTrim()) {
                    widget.setOpacity(255);
                    break;
                }
                if (!isMaxExperience) break;
                widget.setOpacity(0);
            }
        }
    }

    void updateTrims() {
        int i;
        for (i = 0; i < this.maxLevelTrimWidgets.length; ++i) {
            this.updateTrim(SkillData.get(i), this.maxLevelTrimWidgets[i], maxLevelTrim);
        }
        for (i = 0; i < this.maxExperienceTrimWidgets.length; ++i) {
            this.updateTrim(SkillData.get(i), this.maxExperienceTrimWidgets[i], maxExperienceTrim);
        }
    }

    private void addDefaultTrims() {
        try {
            Files.copy(Objects.requireNonNull(((Object)((Object)this)).getClass().getResourceAsStream("/full-trim.png")), Paths.get(MAXSKILLTRIMS_DIR.toString(), "/full-trim.png"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            log.warn(null, (Throwable)e);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("maxskilltrim")) {
            switch (event.getKey()) {
                case "selectedMaxLevelTrim": {
                    this.overrideSprites(maxLevelTrim, event.getNewValue());
                    break;
                }
                case "selectedMaxExperienceTrim": {
                    this.overrideSprites(maxExperienceTrim, event.getNewValue());
                    break;
                }
                case "showMaxExperienceTrim": 
                case "showMaxLevelTrim": {
                    this.clientThread.invokeLater(this::updateTrims);
                    break;
                }
                case "showNavButton": {
                    boolean showNavButton = Boolean.TRUE.toString().equals(event.getNewValue());
                    if (showNavButton) {
                        this.pluginToolbar.addNavigation(this.navButton);
                    }
                    if (showNavButton) break;
                    this.pluginToolbar.removeNavigation(this.navButton);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpritePixels getSpritePixels(String filename) {
        File spriteFile = new File(MAXSKILLTRIMS_DIR + File.separator + filename);
        if (!spriteFile.exists()) {
            log.debug("Sprite doesn't exist (" + spriteFile.getPath() + "): ");
            return null;
        }
        try {
            Class<ImageIO> clazz = ImageIO.class;
            synchronized (ImageIO.class) {
                BufferedImage image = ImageIO.read(spriteFile);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ImageUtil.getImageSpritePixels((BufferedImage)image, (Client)this.client);
            }
        }
        catch (IOException | RuntimeException ex) {
            log.debug("Unable to find image (" + spriteFile.getPath() + "): ");
            return null;
        }
    }

    void overrideSprites(Trim trim, String filename) {
        SpritePixels spritePixels = this.getSpritePixels(filename);
        if (spritePixels == null) {
            return;
        }
        this.client.getSpriteOverrides().remove(trim.spriteID);
        this.client.getWidgetSpriteCache().reset();
        this.client.getSpriteOverrides().put(trim.spriteID, spritePixels);
    }
}

