/*
 * Decompiled with CFR 0.152.
 */
package com.maxskilltrim;

import com.maxskilltrim.MaxSkillTrimConfig;
import com.maxskilltrim.MaxSkillTrimPlugin;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MaxSkillTrimPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(MaxSkillTrimPanel.class);
    @Inject
    ConfigManager configManager;

    @Inject
    public MaxSkillTrimPanel(MaxSkillTrimConfig config) {
        JPanel container = new JPanel();
        container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.insets = new Insets(3, 3, 3, 3);
        container.setLayout(layout);
        JComboBox<String> maxLevelComboBox = this.buildComboBoxPanel("selectedMaxLevelTrim", config.getSelectedMaxLevelTrimFilename());
        JComboBox<String> maxExperienceComboBox = this.buildComboBoxPanel("selectedMaxExperienceTrim", config.getSelectedMaxExperienceTrimFilename());
        JButton openFolderButton = new JButton("Open Folder");
        openFolderButton.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(MaxSkillTrimPlugin.MAXSKILLTRIMS_DIR);
            }
            catch (Exception ex) {
                log.warn(null, (Throwable)ex);
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 0;
        container.add((Component)openFolderButton, constraints);
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(ev -> {
            this.refreshComboBoxOptions(maxLevelComboBox);
            this.refreshComboBoxOptions(maxExperienceComboBox);
        });
        constraints.gridx = 1;
        constraints.gridy = 0;
        container.add((Component)refreshButton, constraints);
        JButton getMoreTrimsButton = new JButton("Get more trims!");
        getMoreTrimsButton.addActionListener(e -> LinkBrowser.browse((String)"https://github.com/NathanQuayle/max-skill-trim/tree/custom-trims"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        container.add((Component)getMoreTrimsButton, constraints);
        JLabel maxLevelTrimLabel = new JLabel("Max level trim");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        container.add((Component)maxLevelTrimLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        container.add(maxLevelComboBox, constraints);
        JLabel maxExperienceTrimLabel = new JLabel("Max experience trim");
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        container.add((Component)maxExperienceTrimLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        container.add(maxExperienceComboBox, constraints);
        this.add(container);
    }

    private JComboBox<String> buildComboBoxPanel(String selectedTrimConfigKey, String selectedFilename) {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.setPrototypeDisplayValue("");
        this.refreshComboBoxOptions(comboBox);
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1 && this.configManager != null) {
                this.configManager.setConfiguration("maxskilltrim", selectedTrimConfigKey, e.getItem());
            }
        });
        comboBox.setSelectedItem(selectedFilename);
        return comboBox;
    }

    private void refreshComboBoxOptions(JComboBox<String> comboBox) {
        Object selectedItem = comboBox.getSelectedItem();
        comboBox.removeAllItems();
        for (File f : Objects.requireNonNull(MaxSkillTrimPlugin.MAXSKILLTRIMS_DIR.listFiles())) {
            comboBox.addItem(f.getName());
        }
        comboBox.setSelectedItem(selectedItem);
    }
}

