/*
 * Decompiled with CFR 0.152.
 */
package com.clanchatwebhook;

import com.clanchatwebhook.ClanChatWebhookConfig;
import com.clanchatwebhook.ClanMessageEvent;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanRank;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClanChannelChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan Chat Webhook")
public class ClanChatWebhookPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanChatWebhookPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClanChatWebhookConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    public boolean activeClan = false;

    @Subscribe
    private void onClanChannelChanged(ClanChannelChanged event) {
        if (event.getClanId() == 0) {
            ClanChannel clan = this.client.getClanChannel();
            String clanName = this.client.getClanChannel().getName();
            this.activeClan = clan != null && clanName != null;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (StringUtils.isEmpty((CharSequence)this.config.secretKey()) || StringUtils.isEmpty((CharSequence)this.config.webhookEndpoint())) {
            return;
        }
        if (chatMessage.getType() == ChatMessageType.CLAN_CHAT || chatMessage.getType() == ChatMessageType.CLAN_MESSAGE) {
            String clanName = this.client.getClanChannel().getName();
            clanName = clanName.replace('\u00a0', ' ');
            String configClanName = this.config.clanName();
            if (clanName == null || !StringUtils.isEmpty((CharSequence)configClanName) && !configClanName.equalsIgnoreCase(clanName)) {
                return;
            }
            String content = this.sanitizeMessage(chatMessage.getMessage(), chatMessage.getType());
            if (!content.contains("</col>")) {
                this.sendMessage(chatMessage);
            }
        }
    }

    private SystemMessageType getSystemMessageType(String message, ChatMessageType messageType) {
        if (messageType == ChatMessageType.CLAN_MESSAGE) {
            if (message.contains("received a drop:")) {
                return SystemMessageType.DROP;
            }
            if (message.contains("received special loot from a raid:")) {
                return SystemMessageType.RAID_DROP;
            }
            if (message.contains("has completed a quest:")) {
                return SystemMessageType.QUESTS;
            }
            if (message.contains("received a new collection log item:")) {
                return SystemMessageType.COLLECTION_LOG;
            }
            if (message.contains("personal best:")) {
                return SystemMessageType.PERSONAL_BEST;
            }
            if (message.contains("To talk in your clan's channel, start each line of chat with")) {
                return SystemMessageType.LOGIN;
            }
            if (message.contains("has defeated") || message.contains("has been defeated by")) {
                return SystemMessageType.PVP;
            }
            if (message.contains("has a funny feeling like") || message.contains("backpack:") || message.contains("something special:")) {
                return SystemMessageType.PET_DROP;
            }
            if (message.contains("has reached") && (message.contains("level") || message.contains("XP")) || message.contains("has reached a total level of")) {
                return SystemMessageType.LEVEL_UP;
            }
            if (message.contains("tier of rewards from Combat Achievements!")) {
                return SystemMessageType.COMBAT_ACHIEVEMENTS;
            }
            if (message.contains("received a clue item:")) {
                return SystemMessageType.CLUE_DROP;
            }
            if (message.contains("has left.") || message.contains("has been invited into the clan by") || message.contains("has joined.")) {
                return SystemMessageType.ATTENDANCE;
            }
            if (message.contains("has completed the") && message.contains("diary.")) {
                return SystemMessageType.DIARY;
            }
            return SystemMessageType.UNKNOWN;
        }
        return SystemMessageType.NORMAL;
    }

    public AccountType getAccountType(String message) {
        if (message.contains("<img=0>")) {
            return AccountType.PLAYER_MODERATOR;
        }
        if (message.contains("<img=2>")) {
            return AccountType.IRON;
        }
        if (message.contains("<img=10>")) {
            return AccountType.HARDCORE_IRON;
        }
        if (message.contains("<img=3>")) {
            return AccountType.ULTIMATE_IRON;
        }
        if (message.contains("<img=41>")) {
            return AccountType.GROUP_IRON;
        }
        if (message.contains("<img=43>")) {
            return AccountType.UNRANKED_IRON;
        }
        if (message.contains("<img=42>")) {
            return AccountType.HARDCORE_GROUP_IRON;
        }
        return AccountType.NORMAL;
    }

    private String sanitizeMessage(String message, ChatMessageType messageType) {
        String newMessage = message;
        newMessage = newMessage.replace('\u00a0', ' ');
        newMessage = newMessage.replace("<lt>", "<");
        newMessage = newMessage.replace("<gt>", ">");
        return this.additionalCustomizations(newMessage);
    }

    private String additionalCustomizations(String message) {
        String newMessage = message;
        newMessage = newMessage.replaceAll("\\<img=\\d+\\>", "");
        return newMessage;
    }

    private void sendMessage(ChatMessage chatMessage) {
        String author = chatMessage.getName().replace('\u00a0', ' ').replaceAll("<img=\\d+>", "");
        String content = this.sanitizeMessage(chatMessage.getMessage(), chatMessage.getType());
        AccountType accountType = this.getAccountType(chatMessage.getName());
        SystemMessageType systemMessageType = this.getSystemMessageType(chatMessage.getMessage(), chatMessage.getType());
        String clanTitle = null;
        if (systemMessageType == SystemMessageType.NORMAL) {
            ClanRank clanRank = this.client.getClanChannel().findMember(author).getRank();
            clanTitle = this.client.getClanSettings().titleForRank(clanRank).getName();
        }
        ClanMessageEvent messageEvent = new ClanMessageEvent(author, content, accountType, systemMessageType, clanTitle, chatMessage.getTimestamp());
        this.sendWebhook(messageEvent);
    }

    private void sendWebhook(ClanMessageEvent messageEvent) {
        String configUrl = this.config.webhookEndpoint() + "/webhook/" + this.config.secretKey();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        HttpUrl url = HttpUrl.parse((String)configUrl);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("data", RuneLiteAPI.GSON.toJson((Object)messageEvent));
        this.buildRequestAndSend(url, requestBodyBuilder);
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    @Provides
    ClanChatWebhookConfig provideConfig(ConfigManager configManager) {
        return (ClanChatWebhookConfig)configManager.getConfig(ClanChatWebhookConfig.class);
    }

    public static enum AccountType {
        NORMAL(1),
        IRON(2),
        HARDCORE_IRON(3),
        ULTIMATE_IRON(4),
        UNRANKED_IRON(5),
        GROUP_IRON(6),
        HARDCORE_GROUP_IRON(7),
        PLAYER_MODERATOR(8),
        JAGEX_MODERATOR(9);

        public final int code;

        private AccountType(int code) {
            this.code = code;
        }
    }

    public static enum SystemMessageType {
        NORMAL(1),
        DROP(2),
        RAID_DROP(3),
        PET_DROP(4),
        PERSONAL_BEST(5),
        COLLECTION_LOG(6),
        QUESTS(7),
        PVP(8),
        ATTENDANCE(9),
        LEVEL_UP(10),
        COMBAT_ACHIEVEMENTS(11),
        CLUE_DROP(12),
        DIARY(13),
        UNKNOWN(100),
        LOGIN(-1);

        public final int code;

        private SystemMessageType(int code) {
            this.code = code;
        }
    }
}

