/*
 * Decompiled with CFR 0.152.
 */
package com.biffo89.troublebrewing;

import com.biffo89.troublebrewing.TroubleBrewingPlugin;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.MenuAction;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class TroubleBrewingOverlay
extends OverlayPanel {
    private final Client client;
    private final TroubleBrewingPlugin plugin;
    private static final int CONTRIBUTION_VARBIT_ID = 2290;
    private static final int BLUE_BANDANA_ID = 8949;
    private static final int TROUBLE_BREWING_REGION_ID = 15150;
    private static final int RED_TEAM_RUM_BOTTLES_ID = 27197512;

    @Inject
    private TroubleBrewingOverlay(TroubleBrewingPlugin plugin, Client client) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.setPriority(OverlayPriority.LOW);
        this.client = client;
        this.plugin = plugin;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Trouble Brewing overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.isInTroubleBrewing()) {
            return null;
        }
        this.updatePoints();
        this.panelComponent.getChildren().add(LineComponent.builder().left("      Pieces of eight").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Contribution").right("   " + this.plugin.getResourcePoints()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Rum").right("   " + this.plugin.getBottles() * 2).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Total").right("   " + this.getPoints()).build());
        return super.render(graphics);
    }

    protected boolean isInTroubleBrewing() {
        return this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getWorldLocation().getRegionID() == 15150;
    }

    private int getPoints() {
        return this.plugin.getResourcePoints() + this.plugin.getBottles() * 2;
    }

    private void updatePoints() {
        this.plugin.setResourcePoints(this.client.getVarbitValue(2290));
        boolean isBlueTeam = this.client.getItemContainer(InventoryID.EQUIPMENT).getItem(EquipmentInventorySlot.HEAD.getSlotIdx()).getId() == 8949;
        Widget scoreWidget = this.client.getWidget(27197512 + (isBlueTeam ? 1 : 0));
        if (scoreWidget == null) {
            return;
        }
        this.plugin.setBottles(Integer.parseInt(scoreWidget.getText()));
    }
}

