/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.virtuallevelups;

import at.nightfirec.virtuallevelups.VirtualLevelUpsConfig;
import at.nightfirec.virtuallevelups.VirtualLevelUpsInterfaceInput;
import at.nightfirec.virtuallevelups.VirtualLevelUpsOverlay;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Virtual Level Ups", description="Display level up dialogs upon reaching virtual level up milestones", tags={"skill", "experience"})
public class VirtualLevelUpsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VirtualLevelUpsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private DrawManager drawManager;
    @Inject
    private ClientUI clientUi;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private VirtualLevelUpsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private VirtualLevelUpsOverlay overlay;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private BufferedImage reportButton;
    private final Map<Skill, Integer> previousXpMap = new EnumMap<Skill, Integer>(Skill.class);
    @VisibleForTesting
    private final List<Skill> skillsLeveledUp = new ArrayList<Skill>();
    private VirtualLevelUpsInterfaceInput input;

    @Provides
    VirtualLevelUpsConfig getConfig(ConfigManager configManager) {
        return (VirtualLevelUpsConfig)configManager.getConfig(VirtualLevelUpsConfig.class);
    }

    public void startUp() {
        this.clientThread.invoke(this::initializePreviousXpMap);
        this.overlayManager.add((Overlay)this.overlay);
        this.spriteManager.getSpriteAsync(3057, 0, s -> {
            this.reportButton = s;
        });
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        if (this.input != null && this.chatboxPanelManager.getCurrentInput() == this.input) {
            this.chatboxPanelManager.close();
        }
        this.previousXpMap.clear();
        this.skillsLeveledUp.clear();
        this.input = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: 
            case LOGGING_IN: 
            case LOGIN_SCREEN_AUTHENTICATOR: {
                this.previousXpMap.clear();
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        Skill skill = event.getSkill();
        int xpAfter = this.client.getSkillExperience(skill);
        int levelAfter = Experience.getLevelForXp((int)xpAfter);
        int xpBefore = this.previousXpMap.getOrDefault(skill, -1);
        int levelBefore = xpBefore == -1 ? -1 : Experience.getLevelForXp((int)xpBefore);
        this.previousXpMap.put(skill, xpAfter);
        if (xpBefore == -1 || levelAfter <= 99 || xpAfter <= xpBefore || xpAfter != 200000000 && levelBefore >= levelAfter) {
            return;
        }
        this.skillsLeveledUp.add(skill);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (this.input != null) {
            this.input.triggerClose();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.input != null) {
            this.input.closeIfTriggered();
        }
        if (this.skillsLeveledUp.isEmpty() || !this.chatboxPanelManager.getContainerWidget().isHidden()) {
            return;
        }
        Skill skill = this.skillsLeveledUp.remove(0);
        this.input = new VirtualLevelUpsInterfaceInput(this, skill);
        this.chatboxPanelManager.openInput((ChatboxInput)this.input);
    }

    private void initializePreviousXpMap() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.previousXpMap.clear();
        } else {
            for (Skill skill : Skill.values()) {
                this.previousXpMap.put(skill, this.client.getSkillExperience(skill));
            }
        }
    }

    void takeScreenshot(Skill skill) {
        if (!this.config.takeScreenshots()) {
            return;
        }
        int skillExperience = this.client.getSkillExperience(skill);
        Object skillLevel = skillExperience == 200000000 ? "MAX_EXP" : "" + Experience.getLevelForXp((int)skillExperience);
        String fileName = skill.getName() + "(" + (String)skillLevel + ")";
        String subDir = "Levels";
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.takeScreenshot(fileName, "Levels", (Image)img));
        if (this.configManager.getConfiguration("screenshot", "displayDate").equals("true")) {
            this.overlay.queueForTimestamp(imageCallback);
        } else {
            this.drawManager.requestNextFrameListener(imageCallback);
        }
    }

    void takeScreenshot(String fileName, String subDir, Image image) {
        boolean includeFrame = this.configManager.getConfiguration("screenshot", "includeFrame").equals("true");
        BufferedImage screenshot = includeFrame ? new BufferedImage(this.clientUi.getWidth(), this.clientUi.getHeight(), 2) : new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graphics = screenshot.getGraphics();
        int gameOffsetX = 0;
        int gameOffsetY = 0;
        if (includeFrame) {
            try {
                SwingUtilities.invokeAndWait(() -> this.clientUi.paint(graphics));
            }
            catch (InterruptedException | InvocationTargetException e) {
                log.warn("unable to paint client UI on screenshot", (Throwable)e);
            }
            Point canvasOffset = this.clientUi.getCanvasOffset();
            gameOffsetX = canvasOffset.getX();
            gameOffsetY = canvasOffset.getY();
        }
        graphics.drawImage(image, gameOffsetX, gameOffsetY, null);
        this.imageCapture.takeScreenshot(screenshot, fileName, subDir, this.configManager.getConfiguration("screenshot", "notifyWhenTaken").equals("true"), ImageUploadStyle.valueOf((String)this.configManager.getConfiguration("screenshot", "uploadScreenshot")));
    }

    Client getClient() {
        return this.client;
    }

    ClientThread getClientThread() {
        return this.clientThread;
    }

    ChatboxPanelManager getChatboxPanelManager() {
        return this.chatboxPanelManager;
    }

    VirtualLevelUpsConfig getConfig() {
        return this.config;
    }

    ChatMessageManager getChatMessageManager() {
        return this.chatMessageManager;
    }

    BufferedImage getReportButton() {
        return this.reportButton;
    }

    List<Skill> getSkillsLeveledUp() {
        return this.skillsLeveledUp;
    }
}

