/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.virtuallevelups;

import at.nightfirec.virtuallevelups.SkillModel;
import at.nightfirec.virtuallevelups.VirtualLevelUpsPlugin;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.List;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Experience;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.input.KeyListener;

class VirtualLevelUpsInterfaceInput
extends ChatboxInput
implements KeyListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 16;
    private final VirtualLevelUpsPlugin plugin;
    private final Skill skill;
    private boolean closeMessage;

    VirtualLevelUpsInterfaceInput(VirtualLevelUpsPlugin plugin, Skill skill) {
        this.plugin = plugin;
        this.skill = skill;
    }

    public void open() {
        this.plugin.getClientThread().invoke(this::setFireworksGraphic);
        Widget chatboxContainer = this.plugin.getChatboxPanelManager().getContainerWidget();
        String skillName = this.skill.getName();
        int skillExperience = this.plugin.getClient().getSkillExperience(this.skill);
        int skillLevel = Experience.getLevelForXp((int)skillExperience);
        List<SkillModel> skillModels = SkillModel.getSKILL_MODELS(this.skill);
        String prefix = this.skill == Skill.AGILITY || this.skill == Skill.ATTACK ? "an " : "a ";
        Widget levelUpLevel = chatboxContainer.createChild(-1, 4);
        Widget levelUpText = chatboxContainer.createChild(-1, 4);
        Widget levelUpContinue = chatboxContainer.createChild(-1, 4);
        String levelUpLevelString = skillExperience == 200000000 ? "Congratulations, you just maxed your " + skillName + " skill." : "Congratulations, you just advanced " + prefix + skillName + " level.";
        levelUpLevel.setText(levelUpLevelString);
        levelUpLevel.setTextColor(Color.BLACK.getRGB());
        levelUpLevel.setFontId(497);
        levelUpLevel.setXPositionMode(0);
        levelUpLevel.setOriginalX(86);
        levelUpLevel.setYPositionMode(0);
        levelUpLevel.setOriginalY(31);
        levelUpLevel.setOriginalWidth(390);
        levelUpLevel.setOriginalHeight(30);
        levelUpLevel.setXTextAlignment(1);
        levelUpLevel.setYTextAlignment(0);
        levelUpLevel.setWidthMode(0);
        levelUpLevel.revalidate();
        String levelUpTextString = skillExperience == 200000000 ? "You have reached maximum experience in " + skillName : (this.skill == Skill.HITPOINTS ? "Your Hitpoints are now " + skillLevel : "Your " + skillName + " level is now " + skillLevel) + ".";
        levelUpText.setText(levelUpTextString);
        levelUpText.setFontId(497);
        levelUpText.setXPositionMode(0);
        levelUpText.setOriginalX(86);
        levelUpText.setYPositionMode(0);
        levelUpText.setOriginalY(60);
        levelUpText.setOriginalWidth(390);
        levelUpText.setOriginalHeight(30);
        levelUpText.setXTextAlignment(1);
        levelUpText.setYTextAlignment(0);
        levelUpText.setWidthMode(0);
        levelUpText.revalidate();
        levelUpContinue.setText("Click here to continue");
        levelUpContinue.setTextColor(Color.BLUE.getRGB());
        levelUpContinue.setFontId(497);
        levelUpContinue.setXPositionMode(0);
        levelUpContinue.setOriginalX(86);
        levelUpContinue.setYPositionMode(0);
        levelUpContinue.setOriginalY(90);
        levelUpContinue.setOriginalWidth(390);
        levelUpContinue.setOriginalHeight(17);
        levelUpContinue.setXTextAlignment(1);
        levelUpContinue.setYTextAlignment(0);
        levelUpContinue.setWidthMode(0);
        levelUpContinue.setAction(0, "Continue");
        levelUpContinue.setOnOpListener(new Object[]{ev -> this.triggerCloseViaMessage()});
        levelUpContinue.setOnMouseOverListener(new Object[]{ev -> levelUpContinue.setTextColor(Color.WHITE.getRGB())});
        levelUpContinue.setOnMouseLeaveListener(new Object[]{ev -> levelUpContinue.setTextColor(Color.BLUE.getRGB())});
        levelUpContinue.setHasListener(true);
        levelUpContinue.revalidate();
        for (SkillModel skillModel : skillModels) {
            VirtualLevelUpsInterfaceInput.buildWidgetModel(chatboxContainer, skillModel);
        }
        this.plugin.takeScreenshot(this.skill);
        this.plugin.getChatMessageManager().queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(skillExperience == 200000000 ? "Congratulations, you've just reached max experience in " + skillName + "!" : "Congratulations, you've just advanced your " + skillName + " level. You are now virtual level " + skillLevel + ".").build());
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() != ' ') {
            return;
        }
        this.triggerCloseViaMessage();
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    void closeIfTriggered() {
        if (this.closeMessage && this.plugin.getChatboxPanelManager().getCurrentInput() == this) {
            this.plugin.getChatboxPanelManager().close();
        }
    }

    void triggerClose() {
        this.closeMessage = true;
    }

    private void triggerCloseViaMessage() {
        Widget levelUpContinue = this.plugin.getClient().getWidget(WidgetInfo.CHATBOX_CONTAINER).getChild(2);
        levelUpContinue.setText("Please wait...");
        this.closeMessage = true;
    }

    private static void buildWidgetModel(Widget chatboxContainer, SkillModel model) {
        Widget levelUpModel = chatboxContainer.createChild(-1, 6);
        levelUpModel.setModelId(model.getModelID());
        levelUpModel.setXPositionMode(0);
        levelUpModel.setOriginalX(model.getOriginalX() + 13);
        levelUpModel.setYPositionMode(0);
        levelUpModel.setOriginalY(model.getOriginalY() + 16);
        levelUpModel.setOriginalWidth(model.getIconWidth());
        levelUpModel.setOriginalHeight(model.getIconHeight());
        levelUpModel.setRotationX(model.getRotationX());
        levelUpModel.setRotationY(model.getRotationY());
        levelUpModel.setRotationZ(model.getRotationZ());
        levelUpModel.setModelZoom(model.getModelZoom());
        levelUpModel.revalidate();
    }

    private void setFireworksGraphic() {
        Player localPlayer = this.plugin.getClient().getLocalPlayer();
        if (localPlayer == null) {
            return;
        }
        int fireworksGraphic = this.plugin.getConfig().showFireworks().getGraphicId();
        if (fireworksGraphic == -1) {
            return;
        }
        localPlayer.setGraphic(fireworksGraphic);
        localPlayer.setSpotAnimFrame(0);
    }

    public boolean isCloseMessage() {
        return this.closeMessage;
    }
}

