/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.planksack;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.inject.Provides;
import io.hydrox.planksack.PlankSackConfig;
import io.hydrox.planksack.PlankSackCounter;
import io.hydrox.planksack.PlankSackOverlay;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Plank Sack", description="See the contents of your Plank Sack at a glance", tags={"plank", "construction", "viewer", "mahogany", "teak", "oak", "homes"})
public class PlankSackPlugin
extends Plugin {
    private static final List<Integer> PLANKS = Arrays.asList(960, 8778, 8780, 8782);
    private static final List<String> PLANK_NAMES = Arrays.asList("Plank", "Oak plank", "Teak plank", "Mahogany plank");
    private static final Set<Integer> MAHOGANY_HOMES_REPAIRS = Sets.newHashSet((Object[])new Integer[]{39982, 39995, 40010, 40011, 40089, 40099, 40158, 40159, 40163, 40168, 40170, 40177, 40295, 40298, 40289});
    private static final Set<Integer> HALLOWED_SEPULCHRE_FIXES = Sets.newHashSet((Object[])new Integer[]{39527, 39528});
    private static final int CONSTRUCTION_WIDGET_GROUP = 458;
    private static final int CONSTRUCTION_WIDGET_BUILD_IDX_START = 4;
    private static final int CONSTRUCTION_SUBWIDGET_MATERIALS = 3;
    private static final int CONSTRUCTION_SUBWIDGET_CANT_BUILD = 5;
    private static final int SCRIPT_CONSTRUCTION_OPTION_CLICKED = 1405;
    private static final int SCRIPT_CONSTRUCTION_OPTION_KEYBIND = 1632;
    private static final int SCRIPT_BUILD_CONSTRUCTION_MENU_ENTRY = 1404;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PlankSackConfig config;
    @Inject
    private PlankSackOverlay overlay;
    private int plankCount = -1;
    private PlankSackCounter plankSackCounter;
    private Multiset<Integer> inventorySnapshot;
    private boolean checkForUpdate = false;
    private int menuItemsToCheck = 0;
    private final List<BuildMenuItem> buildMenuItems = new ArrayList<BuildMenuItem>();
    private boolean watchForAnimations = false;
    private int lastAnimation = -1;

    @Provides
    PlankSackConfig getConfig(ConfigManager configManager) {
        return (PlankSackConfig)configManager.getConfig(PlankSackConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.plankSackCounter = new PlankSackCounter((BufferedImage)this.itemManager.getImage(24882), this);
        this.clientThread.invoke(() -> this.updateInfobox(this.client.getItemContainer(InventoryID.INVENTORY)));
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.infoBoxManager.removeInfoBox((InfoBox)this.plankSackCounter);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.plankCount = Optional.ofNullable((Integer)this.configManager.getRSProfileConfiguration("planksack", "plankcount", Integer.class)).orElse(-1);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        if (this.checkForUpdate) {
            this.checkForUpdate = false;
            Multiset<Integer> currentInventory = this.createSnapshot(event.getItemContainer());
            Multiset deltaMinus = Multisets.difference(currentInventory, this.inventorySnapshot);
            Multiset deltaPlus = Multisets.difference(this.inventorySnapshot, currentInventory);
            deltaPlus.forEachEntry((id, c) -> this.plankCount += c);
            deltaMinus.forEachEntry((id, c) -> this.plankCount -= c);
            this.setPlankCount(this.plankCount);
        }
        this.updateInfobox(event.getItemContainer());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("planksack")) {
            this.clientThread.invoke(() -> this.updateInfobox(this.client.getItemContainer(InventoryID.INVENTORY)));
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getWidget() != null) {
            if (event.getWidget().getItemId() == 24882 && (event.getMenuOption().equals("Fill") || event.getMenuOption().equals("Empty") || event.getMenuOption().equals("Use"))) {
                this.inventorySnapshot = this.createSnapshot(this.client.getItemContainer(InventoryID.INVENTORY));
                this.checkForUpdate = true;
            } else if (event.getMenuOption().equals("Use") && event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET && this.client.getSelectedWidget() != null) {
                int firstSelectedItemID = this.client.getSelectedWidget().getItemId();
                int secondSelectedItemID = event.getWidget().getItemId();
                if (firstSelectedItemID == 24882 && PLANKS.contains(secondSelectedItemID) || PLANKS.contains(firstSelectedItemID) && secondSelectedItemID == 24882) {
                    this.inventorySnapshot = this.createSnapshot(this.client.getItemContainer(InventoryID.INVENTORY));
                    this.checkForUpdate = true;
                }
            }
        } else if (event.getMenuOption().equals("Repair") && MAHOGANY_HOMES_REPAIRS.contains(event.getId())) {
            this.watchForAnimations = true;
            this.inventorySnapshot = this.createSnapshot(this.client.getItemContainer(InventoryID.INVENTORY));
        } else if (event.getMenuOption().equals("Fix") && HALLOWED_SEPULCHRE_FIXES.contains(event.getId())) {
            this.inventorySnapshot = this.createSnapshot(this.client.getItemContainer(InventoryID.INVENTORY));
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        Multiset<Integer> snapshot;
        if (event.getScriptId() != 1405 && event.getScriptId() != 1632) {
            return;
        }
        Widget widget = event.getScriptEvent().getSource();
        int idx = WidgetInfo.TO_CHILD((int)widget.getId()) - 4;
        if (idx >= this.buildMenuItems.size()) {
            return;
        }
        BuildMenuItem item = this.buildMenuItems.get(idx);
        if (item != null && item.canBuild && (snapshot = this.createSnapshot(this.client.getItemContainer(InventoryID.INVENTORY))) != null) {
            for (Item i : item.planks) {
                if (!snapshot.contains((Object)i.getId())) {
                    this.plankCount -= i.getQuantity();
                    continue;
                }
                if (snapshot.count((Object)i.getId()) >= i.getQuantity()) continue;
                this.plankCount -= i.getQuantity() - snapshot.count((Object)i.getId());
            }
            this.setPlankCount(this.plankCount);
        }
        this.buildMenuItems.clear();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 1404) {
            return;
        }
        ++this.menuItemsToCheck;
        this.watchForAnimations = false;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.menuItemsToCheck <= 0) {
            return;
        }
        for (int i = 0; i < this.menuItemsToCheck; ++i) {
            int idx = 4 + i;
            Widget widget = this.client.getWidget(458, idx);
            if (widget == null) continue;
            boolean canBuild = widget.getDynamicChildren()[5].isHidden();
            Widget materialWidget = widget.getDynamicChildren()[3];
            if (materialWidget == null) continue;
            String[] materialLines = materialWidget.getText().split("<br>");
            ArrayList<Item> materials = new ArrayList<Item>();
            for (String line : materialLines) {
                String[] data = line.split(": ");
                if (data.length < 2) continue;
                String name = data[0];
                int count = Integer.parseInt(data[1]);
                if (!PLANK_NAMES.contains(name)) continue;
                materials.add(new Item(PLANKS.get(PLANK_NAMES.indexOf(name)).intValue(), count));
            }
            this.buildMenuItems.add(new BuildMenuItem(materials.toArray(new Item[0]), canBuild));
        }
        this.menuItemsToCheck = 0;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (!this.watchForAnimations || event.getActor() != this.client.getLocalPlayer() || this.client.getLocalPlayer() == null) {
            return;
        }
        int anim = this.client.getLocalPlayer().getAnimation();
        if ((this.lastAnimation == 3676 || this.lastAnimation == 8912) && anim != this.lastAnimation) {
            Multiset<Integer> current = this.createSnapshot(this.client.getItemContainer(InventoryID.INVENTORY));
            Multiset delta = Multisets.difference(this.inventorySnapshot, current);
            if (delta.size() == 0) {
                this.setPlankCount(this.plankCount - 1);
            }
            this.watchForAnimations = false;
            this.lastAnimation = -1;
        } else {
            this.lastAnimation = anim;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.SPAM && event.getMessage().equals("You repair the broken bridge.")) {
            this.clientThread.invokeLater(() -> {
                Multiset<Integer> current = this.createSnapshot(this.client.getItemContainer(InventoryID.INVENTORY));
                Multiset delta = Multisets.difference(this.inventorySnapshot, current);
                switch (delta.size()) {
                    case 0: {
                        this.setPlankCount(this.plankCount - 2);
                        break;
                    }
                    case 1: {
                        this.setPlankCount(this.plankCount - 1);
                    }
                }
            });
        }
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = event.getMessage();
        if (message.startsWith("Basic\u00a0planks:")) {
            String stripped = Text.removeTags((String)event.getMessage());
            this.setPlankCount(Arrays.stream(stripped.split(",")).mapToInt(s -> Integer.parseInt(s.split(":\u00a0")[1])).sum());
        } else if (message.equals("You haven't got any planks that can go in the sack.")) {
            this.checkForUpdate = false;
        } else if (message.equals("Your sack is full.")) {
            this.setPlankCount(28);
            this.checkForUpdate = false;
        } else if (message.equals("Your sack is empty.")) {
            this.setPlankCount(0);
            this.checkForUpdate = false;
        }
    }

    private void setPlankCount(int count) {
        this.plankCount = Ints.constrainToRange((int)count, (int)0, (int)28);
        this.configManager.setRSProfileConfiguration("planksack", "plankcount", (Object)this.plankCount);
    }

    private Multiset<Integer> createSnapshot(ItemContainer container) {
        if (container == null) {
            return null;
        }
        HashMultiset snapshot = HashMultiset.create();
        Arrays.stream(container.getItems()).filter(item -> PLANKS.contains(item.getId())).forEach(arg_0 -> PlankSackPlugin.lambda$createSnapshot$7((Multiset)snapshot, arg_0));
        return snapshot;
    }

    private void updateInfobox(ItemContainer container) {
        this.infoBoxManager.removeInfoBox((InfoBox)this.plankSackCounter);
        if (container == null) {
            return;
        }
        boolean val = container.contains(24882);
        if (val && this.config.showInfobox()) {
            this.infoBoxManager.addInfoBox((InfoBox)this.plankSackCounter);
        }
    }

    Color getColour() {
        if (this.plankCount <= 0) {
            return Color.RED;
        }
        if (this.plankCount < 14) {
            return Color.YELLOW;
        }
        return Color.WHITE;
    }

    public int getPlankCount() {
        return this.plankCount;
    }

    private static /* synthetic */ void lambda$createSnapshot$7(Multiset snapshot, Item i) {
        snapshot.add((Object)i.getId(), i.getQuantity());
    }

    private static class BuildMenuItem {
        private final Item[] planks;
        private final boolean canBuild;

        public BuildMenuItem(Item[] planks, boolean canBuild) {
            this.planks = planks;
            this.canBuild = canBuild;
        }

        public Item[] getPlanks() {
            return this.planks;
        }

        public boolean isCanBuild() {
            return this.canBuild;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildMenuItem)) {
                return false;
            }
            BuildMenuItem other = (BuildMenuItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPlanks(), other.getPlanks())) {
                return false;
            }
            return this.isCanBuild() == other.isCanBuild();
        }

        protected boolean canEqual(Object other) {
            return other instanceof BuildMenuItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getPlanks());
            result = result * 59 + (this.isCanBuild() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "PlankSackPlugin.BuildMenuItem(planks=" + Arrays.deepToString(this.getPlanks()) + ", canBuild=" + this.isCanBuild() + ")";
        }
    }
}

