/*
 * Decompiled with CFR 0.152.
 */
package com.ywcode.randomeventhider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.ywcode.randomeventhider.RandomEventHiderConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.callback.Hooks;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Random Event Hider", description="Adds the ability to hide specific random events that interact with you or with other players.", tags={"random event,hider,random event hider,ra hider,messenger,strange plant,poof,smoke,star mining,shooting stars,forestry,count check"})
public class RandomEventHiderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RandomEventHiderPlugin.class);
    private static final Set<Integer> RANDOM_EVENT_NPCS = ImmutableSet.of((Object)6747, (Object)5426, (Object)12551, (Object)12552, (Object)307, (Object)314, (Object[])new Integer[]{322, 6749, 390, 6754, 6744, 6748, 5429, 5430, 5431, 5432, 312, 5434, 5435, 326, 327, 5438, 5441, 6746, 5437, 5440, 6750, 6751, 6752, 6753, 5436, 5439, 380, 6738, 6755, 375, 376, 5510, 6743});
    private static final Set<Integer> MESSENGER_NPCS = ImmutableSet.of((Object)3439, (Object)11287, (Object)11814, (Object)11815, (Object)11816, (Object)11817, (Object[])new Integer[0]);
    private static final Set<Integer> EVENT_NPCS;
    private static final Set<Integer> FROGS_NPCS;
    private static final int POOF_SOUND = 1930;
    private static final int DRUNKEN_DWARF_SOUND = 2297;
    private static final int EVIL_BOB_MEOW = 333;
    private static final int FROG_SPLASH = 838;
    private static final int POOF_GRAPHICSOBJECT_ID = 86;
    private static final int FROG_REALM_REGIONID = 9802;
    private static boolean hideOtherBeekeeper;
    private static boolean hideOtherCaptArnav;
    private static boolean hideOtherNiles;
    private static boolean hideOtherCountCheck;
    private static boolean hideOtherDrillDemon;
    private static boolean hideOtherDrunkenDwarf;
    private static boolean hideOtherEvilBob;
    private static boolean hideOtherEvilTwin;
    private static boolean hideOtherFreakyForester;
    private static boolean hideOtherGenie;
    private static boolean hideOtherGravedigger;
    private static boolean hideOtherJekyllHyde;
    private static boolean hideOtherKissTheFrog;
    private static boolean hideOtherMaze;
    private static boolean hideOtherMime;
    private static boolean hideOtherMysteriousOldMan;
    private static boolean hideOtherPilloryGuard;
    private static boolean hideOtherPinball;
    private static boolean hideOtherPrisonPete;
    private static boolean hideOtherQuizMaster;
    private static boolean hideOtherRickTurpentine;
    private static boolean hideOtherSandwichLady;
    private static boolean hideOtherSurpriseExam;
    private static boolean hideOwnBeekeeper;
    private static boolean hideOwnCaptArnav;
    private static boolean hideOwnCountCheck;
    private static boolean hideOwnNiles;
    private static boolean hideOwnDrillDemon;
    private static boolean hideOwnDrunkenDwarf;
    private static boolean hideOwnEvilBob;
    private static boolean hideOwnEvilTwin;
    private static boolean hideOwnFreakyForester;
    private static boolean hideOwnGenie;
    private static boolean hideOwnGravedigger;
    private static boolean hideOwnJekyllHyde;
    private static boolean hideOwnKissTheFrog;
    private static boolean hideOwnMaze;
    private static boolean hideOwnMime;
    private static boolean hideOwnMysteriousOldMan;
    private static boolean hideOwnPilloryGuard;
    private static boolean hideOwnPinball;
    private static boolean hideOwnPrisonPete;
    private static boolean hideOwnQuizMaster;
    private static boolean hideOwnRickTurpentine;
    private static boolean hideOwnSandwichLady;
    private static boolean hideOwnSurpriseExam;
    private static boolean hideAllStrangePlant;
    private static boolean muteDwarf;
    private static boolean muteBob;
    private static boolean muteFrogs;
    private static boolean mutePoof;
    private static boolean muteOtherRandomSounds;
    private static boolean hidePoof;
    private static boolean hideOtherMessengers;
    private static final LinkedHashMap<Integer, Integer> ownRandomsMap;
    private static final LinkedHashMap<Integer, Integer> otherRandomsMap;
    private static final LinkedHashMap<WorldPoint, Integer> spawnedDespawnedNpcLocations;
    private static final LinkedHashMap<WorldPoint, Integer> spawnedDespawnedNpcLocationsDeletion;
    private static boolean shouldCleanMap;
    private static int currentRegionID;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    @Inject
    private Client client;
    @Inject
    private RandomEventHiderConfig config;
    @Inject
    private Hooks hooks;

    public void startUp() {
        this.hooks.registerRenderableDrawListener(this.drawListener);
        this.updateConfig();
    }

    public void shutDown() {
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        ownRandomsMap.clear();
        otherRandomsMap.clear();
        spawnedDespawnedNpcLocations.clear();
        spawnedDespawnedNpcLocationsDeletion.clear();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("RandomEventHider")) {
            this.updateConfig();
        }
    }

    private void updateConfig() {
        hideOtherBeekeeper = this.config.hideOtherBeekeeper();
        hideOtherCaptArnav = this.config.hideOtherCaptArnav();
        hideOtherNiles = this.config.hideOtherNiles();
        hideOtherCountCheck = this.config.hideOtherCountCheck();
        hideOtherDrillDemon = this.config.hideOtherDrillDemon();
        hideOtherDrunkenDwarf = this.config.hideOtherDrunkenDwarf();
        hideOtherEvilBob = this.config.hideOtherEvilBob();
        hideOtherEvilTwin = this.config.hideOtherEvilTwin();
        hideOtherFreakyForester = this.config.hideOtherFreakyForester();
        hideOtherGenie = this.config.hideOtherGenie();
        hideOtherGravedigger = this.config.hideOtherGravedigger();
        hideOtherJekyllHyde = this.config.hideOtherJekyllHyde();
        hideOtherKissTheFrog = this.config.hideOtherKissTheFrog();
        hideOtherMaze = this.config.hideOtherMaze();
        hideOtherMime = this.config.hideOtherMime();
        hideOtherMysteriousOldMan = this.config.hideOtherMysteriousOldMan();
        hideOtherPilloryGuard = this.config.hideOtherPilloryGuard();
        hideOtherPinball = this.config.hideOtherPinball();
        hideOtherPrisonPete = this.config.hideOtherPrisonPete();
        hideOtherQuizMaster = this.config.hideOtherQuizMaster();
        hideOtherRickTurpentine = this.config.hideOtherRickTurpentine();
        hideOtherSandwichLady = this.config.hideOtherSandwichLady();
        hideOtherSurpriseExam = this.config.hideOtherSurpriseExam();
        hideOwnBeekeeper = this.config.hideOwnBeekeeper();
        hideOwnCaptArnav = this.config.hideOwnCaptArnav();
        hideOwnNiles = this.config.hideOwnNiles();
        hideOwnCountCheck = this.config.hideOwnCountCheck();
        hideOwnDrillDemon = this.config.hideOwnDrillDemon();
        hideOwnDrunkenDwarf = this.config.hideOwnDrunkenDwarf();
        hideOwnEvilBob = this.config.hideOwnEvilBob();
        hideOwnEvilTwin = this.config.hideOwnEvilTwin();
        hideOwnFreakyForester = this.config.hideOwnFreakyForester();
        hideOwnGenie = this.config.hideOwnGenie();
        hideOwnGravedigger = this.config.hideOwnGravedigger();
        hideOwnJekyllHyde = this.config.hideOwnJekyllHyde();
        hideOwnKissTheFrog = this.config.hideOwnKissTheFrog();
        hideOwnMaze = this.config.hideOwnMaze();
        hideOwnMime = this.config.hideOwnMime();
        hideOwnMysteriousOldMan = this.config.hideOwnMysteriousOldMan();
        hideOwnPilloryGuard = this.config.hideOwnPilloryGuard();
        hideOwnPinball = this.config.hideOwnPinball();
        hideOwnPrisonPete = this.config.hideOwnPrisonPete();
        hideOwnQuizMaster = this.config.hideOwnQuizMaster();
        hideOwnRickTurpentine = this.config.hideOwnRickTurpentine();
        hideOwnSandwichLady = this.config.hideOwnSandwichLady();
        hideOwnSurpriseExam = this.config.hideOwnSurpriseExam();
        hideAllStrangePlant = this.config.hideAllStrangePlant();
        muteDwarf = this.config.muteDwarf();
        muteBob = this.config.muteBob();
        muteFrogs = this.config.muteFrogs();
        mutePoof = this.config.mutePoof();
        muteOtherRandomSounds = this.config.muteOtherRandomSounds();
        hidePoof = this.config.hidePoof();
        hideOtherMessengers = this.config.hideOtherMessengers();
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged interactingChanged) {
        Actor source = interactingChanged.getSource();
        Actor target = interactingChanged.getTarget();
        Player player = this.client.getLocalPlayer();
        if (player != null && source instanceof NPC && target instanceof Player && EVENT_NPCS.contains(((NPC)source).getId())) {
            int sourceIndex = ((NPC)source).getIndex();
            int sourceId = ((NPC)source).getId();
            if (target == player && !ownRandomsMap.containsKey(sourceIndex) && !otherRandomsMap.containsKey(sourceIndex)) {
                ownRandomsMap.put(sourceIndex, sourceId);
            }
            if (!(target == player || ownRandomsMap.containsKey(sourceIndex) || otherRandomsMap.containsKey(sourceIndex) || FROGS_NPCS.contains(sourceId) && this.mapContainsFrogId(ownRandomsMap))) {
                otherRandomsMap.put(sourceIndex, sourceId);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) {
            ownRandomsMap.clear();
            otherRandomsMap.clear();
            spawnedDespawnedNpcLocations.clear();
            spawnedDespawnedNpcLocationsDeletion.clear();
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        int npcSpawnedId = npcSpawned.getNpc().getId();
        int npcSpawnedIndex = npcSpawned.getNpc().getIndex();
        Actor npcSpawnedActor = npcSpawned.getActor();
        this.addPoofLocationToList(npcSpawnedId, npcSpawnedIndex, npcSpawnedActor, true);
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        int npcDespawnedId = npcDespawned.getNpc().getId();
        int npcDespawnedIndex = npcDespawned.getNpc().getIndex();
        Actor npcDespawnedActor = npcDespawned.getActor();
        this.addPoofLocationToList(npcDespawnedId, npcDespawnedIndex, npcDespawnedActor, false);
        if (EVENT_NPCS.contains(npcDespawnedId)) {
            if (ownRandomsMap.containsKey(npcDespawnedIndex)) {
                ownRandomsMap.remove(npcDespawnedIndex, npcDespawnedId);
            }
            if (otherRandomsMap.containsKey(npcDespawnedIndex)) {
                otherRandomsMap.remove(npcDespawnedIndex, npcDespawnedId);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        currentRegionID = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        if (!spawnedDespawnedNpcLocations.isEmpty()) {
            int currentGameCycle = this.client.getGameCycle();
            for (Map.Entry<WorldPoint, Integer> entry : spawnedDespawnedNpcLocations.entrySet()) {
                int npcGameCycle = entry.getValue();
                if (currentGameCycle - npcGameCycle <= 150) continue;
                spawnedDespawnedNpcLocationsDeletion.put(entry.getKey(), entry.getValue());
                shouldCleanMap = true;
            }
            this.cleanupMap();
        }
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed soundEffectPlayed) {
        int sourceNpcId;
        int soundId = soundEffectPlayed.getSoundId();
        if (soundEffectPlayed.getSource() != null && soundEffectPlayed.getSource() instanceof NPC && (EVENT_NPCS.contains(sourceNpcId = ((NPC)soundEffectPlayed.getSource()).getId()) || sourceNpcId == 323) && this.shouldMute(soundId)) {
            soundEffectPlayed.consume();
        }
        if ((soundId == 1930 || soundId == 333 || soundId == 2297 || soundId == 838) && this.shouldMute(soundId)) {
            soundEffectPlayed.consume();
        }
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed areaSoundEffectPlayed) {
        int sourceNpcId;
        int soundId = areaSoundEffectPlayed.getSoundId();
        if (areaSoundEffectPlayed.getSource() != null && areaSoundEffectPlayed.getSource() instanceof NPC && (EVENT_NPCS.contains(sourceNpcId = ((NPC)areaSoundEffectPlayed.getSource()).getId()) || sourceNpcId == 323) && this.shouldMute(soundId)) {
            areaSoundEffectPlayed.consume();
        }
        if ((soundId == 1930 || soundId == 333 || soundId == 2297 || soundId == 838) && this.shouldMute(soundId)) {
            areaSoundEffectPlayed.consume();
        }
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        WorldPoint graphicsObjectWorldPoint;
        GraphicsObject graphicsObject;
        NPC npc;
        int npcId;
        if (renderable instanceof NPC && (EVENT_NPCS.contains(npcId = (npc = (NPC)renderable).getId()) || npcId == 323)) {
            int npcIndex = npc.getIndex();
            return !this.shouldHideBasedOnMaps(npcIndex, npcId);
        }
        if (renderable instanceof GraphicsObject && (graphicsObject = (GraphicsObject)renderable).getId() == 86 && spawnedDespawnedNpcLocations.containsKey(graphicsObjectWorldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)graphicsObject.getLocation()))) {
            graphicsObject.setFinished(true);
            return !hidePoof;
        }
        return true;
    }

    private void addPoofLocationToList(int npcId, int npcIndex, Actor npcActor, boolean NpcSpawned2) {
        if (EVENT_NPCS.contains(npcId) || npcId == 323) {
            WorldPoint npcWorldPoint = npcActor.getWorldLocation();
            if (NpcSpawned2 && this.shouldHideBasedOnMaps(npcIndex, npcId)) {
                spawnedDespawnedNpcLocations.put(npcWorldPoint, this.client.getGameCycle());
            }
            if (!NpcSpawned2) {
                spawnedDespawnedNpcLocations.put(npcWorldPoint, this.client.getGameCycle());
            }
        }
    }

    private void cleanupMap() {
        if (shouldCleanMap) {
            for (Map.Entry<WorldPoint, Integer> entry : spawnedDespawnedNpcLocationsDeletion.entrySet()) {
                spawnedDespawnedNpcLocations.remove(entry.getKey(), entry.getValue());
            }
            spawnedDespawnedNpcLocationsDeletion.clear();
            shouldCleanMap = false;
        }
    }

    private boolean mapContainsFrogId(LinkedHashMap Map2) {
        return Map2.containsValue(5429) || Map2.containsValue(5430) || Map2.containsValue(5431) || Map2.containsValue(5432) || Map2.containsValue(312) || Map2.containsValue(5434) || Map2.containsValue(5435);
    }

    private boolean shouldHideBasedOnMaps(int npcIndex, int npcId) {
        if (currentRegionID == 9802) {
            return false;
        }
        if (ownRandomsMap.containsKey(npcIndex)) {
            return this.shouldHide(npcId, true);
        }
        if (otherRandomsMap.containsKey(npcIndex)) {
            return this.shouldHide(npcId, false);
        }
        if (FROGS_NPCS.contains(npcId)) {
            if (this.mapContainsFrogId(ownRandomsMap)) {
                return this.shouldHide(npcId, true);
            }
            if (this.mapContainsFrogId(otherRandomsMap)) {
                return this.shouldHide(npcId, false);
            }
        }
        if (npcId == 323) {
            return hideAllStrangePlant;
        }
        return this.shouldHide(npcId, true) || this.shouldHide(npcId, false);
    }

    private boolean shouldHide(int id, boolean OwnEvent) {
        if (OwnEvent) {
            switch (id) {
                case 6747: {
                    return hideOwnBeekeeper;
                }
                case 5426: {
                    return hideOwnCaptArnav;
                }
                case 5436: 
                case 5437: 
                case 5438: 
                case 5439: 
                case 5440: 
                case 5441: {
                    return hideOwnNiles;
                }
                case 12551: 
                case 12552: {
                    return hideOwnCountCheck;
                }
                case 6743: {
                    return hideOwnDrillDemon;
                }
                case 322: {
                    return hideOwnDrunkenDwarf;
                }
                case 390: {
                    return hideOwnEvilBob;
                }
                case 6738: {
                    return hideOwnEvilTwin;
                }
                case 6748: {
                    return hideOwnFreakyForester;
                }
                case 326: 
                case 327: {
                    return hideOwnGenie;
                }
                case 6746: {
                    return hideOwnGravedigger;
                }
                case 307: 
                case 314: {
                    return hideOwnJekyllHyde;
                }
                case 312: 
                case 5429: 
                case 5430: 
                case 5431: 
                case 5432: 
                case 5434: 
                case 5435: {
                    return hideOwnKissTheFrog;
                }
                case 6752: {
                    return hideOwnMaze;
                }
                case 6753: {
                    return hideOwnMime;
                }
                case 6750: 
                case 6751: {
                    return hideOwnMysteriousOldMan;
                }
                case 380: {
                    return hideOwnPilloryGuard;
                }
                case 6744: {
                    return hideOwnPinball;
                }
                case 6754: {
                    return hideOwnPrisonPete;
                }
                case 6755: {
                    return hideOwnQuizMaster;
                }
                case 375: 
                case 376: {
                    return hideOwnRickTurpentine;
                }
                case 5510: {
                    return hideOwnSandwichLady;
                }
                case 6749: {
                    return hideOwnSurpriseExam;
                }
            }
        } else {
            switch (id) {
                case 6747: {
                    return hideOtherBeekeeper;
                }
                case 5426: {
                    return hideOtherCaptArnav;
                }
                case 5436: 
                case 5437: 
                case 5438: 
                case 5439: 
                case 5440: 
                case 5441: {
                    return hideOtherNiles;
                }
                case 12551: 
                case 12552: {
                    return hideOtherCountCheck;
                }
                case 6743: {
                    return hideOtherDrillDemon;
                }
                case 322: {
                    return hideOtherDrunkenDwarf;
                }
                case 390: {
                    return hideOtherEvilBob;
                }
                case 6738: {
                    return hideOtherEvilTwin;
                }
                case 6748: {
                    return hideOtherFreakyForester;
                }
                case 326: 
                case 327: {
                    return hideOtherGenie;
                }
                case 6746: {
                    return hideOtherGravedigger;
                }
                case 307: 
                case 314: {
                    return hideOtherJekyllHyde;
                }
                case 312: 
                case 5429: 
                case 5430: 
                case 5431: 
                case 5432: 
                case 5434: 
                case 5435: {
                    return hideOtherKissTheFrog;
                }
                case 6752: {
                    return hideOtherMaze;
                }
                case 6753: {
                    return hideOtherMime;
                }
                case 6750: 
                case 6751: {
                    return hideOtherMysteriousOldMan;
                }
                case 380: {
                    return hideOtherPilloryGuard;
                }
                case 6744: {
                    return hideOtherPinball;
                }
                case 6754: {
                    return hideOtherPrisonPete;
                }
                case 6755: {
                    return hideOtherQuizMaster;
                }
                case 375: 
                case 376: {
                    return hideOtherRickTurpentine;
                }
                case 5510: {
                    return hideOtherSandwichLady;
                }
                case 6749: {
                    return hideOtherSurpriseExam;
                }
                case 3439: 
                case 11287: 
                case 11814: 
                case 11815: 
                case 11816: 
                case 11817: {
                    return hideOtherMessengers;
                }
            }
        }
        return false;
    }

    private boolean shouldMute(int soundId) {
        switch (soundId) {
            case 2297: {
                return muteDwarf;
            }
            case 333: {
                return muteBob;
            }
            case 838: {
                return muteFrogs;
            }
            case 1930: {
                return mutePoof;
            }
        }
        return muteOtherRandomSounds;
    }

    @Provides
    RandomEventHiderConfig provideConfig(ConfigManager configManager) {
        return (RandomEventHiderConfig)configManager.getConfig(RandomEventHiderConfig.class);
    }

    static {
        HashSet<Integer> combinedSets = new HashSet<Integer>();
        combinedSets.addAll(RANDOM_EVENT_NPCS);
        combinedSets.addAll(MESSENGER_NPCS);
        EVENT_NPCS = Collections.unmodifiableSet(combinedSets);
        FROGS_NPCS = ImmutableSet.of((Object)5429, (Object)5430, (Object)5431, (Object)5432, (Object)312, (Object)5434, (Object[])new Integer[]{5435});
        ownRandomsMap = new LinkedHashMap();
        otherRandomsMap = new LinkedHashMap();
        spawnedDespawnedNpcLocations = new LinkedHashMap();
        spawnedDespawnedNpcLocationsDeletion = new LinkedHashMap();
    }
}

