/*
 * Decompiled with CFR 0.152.
 */
package com.banktaglayouts.invsetupsstuff;

import com.banktaglayouts.BankTagLayoutsPlugin;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import inventorysetupz.InventorySetup;
import inventorysetupz.InventorySetupsItem;
import inventorysetupz.InventorySetupsVariationMapping;
import inventorysetupz.serialization.InventorySetupItemSerializable;
import inventorysetupz.serialization.InventorySetupItemSerializableTypeAdapter;
import inventorysetupz.serialization.InventorySetupSerializable;
import inventorysetupz.serialization.LongTypeAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventorySetupsAdapter {
    private static final Logger log = LoggerFactory.getLogger(InventorySetupsAdapter.class);
    public static final String CONFIG_GROUP = "inventorysetups";
    public static final String CONFIG_KEY_SETUPS = "setups";
    public static final String CONFIG_KEY_SETUPS_V2 = "setupsV2";
    public static final String CONFIG_KEY_SETUPS_MIGRATED_V2 = "migratedV2";
    private final BankTagLayoutsPlugin plugin;
    private Gson gson;

    public InventorySetupsAdapter(BankTagLayoutsPlugin plugin) {
        this.plugin = plugin;
    }

    public InventorySetup getInventorySetup(String name) {
        String hasMigratedToV2;
        if (this.gson == null) {
            this.gson = this.plugin.gson.newBuilder().registerTypeAdapter(Long.TYPE, (Object)new LongTypeAdapter()).registerTypeAdapter(InventorySetupItemSerializable.class, (Object)new InventorySetupItemSerializableTypeAdapter()).create();
        }
        if (!Strings.isNullOrEmpty((String)(hasMigratedToV2 = this.plugin.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY_SETUPS_MIGRATED_V2)))) {
            Type setupTypeV2 = new TypeToken<ArrayList<InventorySetupSerializable>>(){}.getType();
            ArrayList issList = new ArrayList(this.loadData(CONFIG_KEY_SETUPS_V2, setupTypeV2));
            for (InventorySetupSerializable iss : issList) {
                InventorySetup setup = InventorySetupSerializable.convertToInventorySetup(iss);
                if (!setup.getName().equals(name)) continue;
                return setup;
            }
            return null;
        }
        try {
            Type setupType = new TypeToken<ArrayList<InventorySetup>>(){}.getType();
            List inventorySetups = this.loadData(CONFIG_KEY_SETUPS, setupType);
            return inventorySetups.stream().filter(s -> s.getName().equals(name)).findAny().orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private <T> List<T> loadData(String configKey, Type type) {
        String storedData = this.plugin.configManager.getConfiguration(CONFIG_GROUP, configKey);
        if (Strings.isNullOrEmpty((String)storedData)) {
            return new ArrayList();
        }
        try {
            return (List)this.plugin.gson.fromJson(storedData, type);
        }
        catch (Exception e) {
            log.error("Exception occurred while loading data", (Throwable)e);
            return new ArrayList();
        }
    }

    public boolean setupContainsItem(InventorySetup setup, int itemID) {
        if (this.gson == null) {
            this.gson = this.plugin.gson.newBuilder().registerTypeAdapter(Long.TYPE, (Object)new LongTypeAdapter()).registerTypeAdapter(InventorySetupItemSerializable.class, (Object)new InventorySetupItemSerializableTypeAdapter()).create();
        }
        if (this.additionalFilteredItemsHasItem(itemID = this.plugin.itemManager.canonicalize(itemID), setup.getAdditionalFilteredItems())) {
            return true;
        }
        if (setup.getRune_pouch() != null && this.checkIfContainerContainsItem(itemID, setup.getRune_pouch())) {
            return true;
        }
        if (setup.getBoltPouch() != null && this.checkIfContainerContainsItem(itemID, setup.getBoltPouch())) {
            return true;
        }
        return this.checkIfContainerContainsItem(itemID, setup.getInventory()) || this.checkIfContainerContainsItem(itemID, setup.getEquipment());
    }

    private boolean additionalFilteredItemsHasItem(int itemId, Map<Integer, InventorySetupsItem> additionalFilteredItems) {
        int canonicalizedId = this.plugin.itemManager.canonicalize(itemId);
        for (Integer additionalItemKey : additionalFilteredItems.keySet()) {
            int finalItemId;
            boolean isFuzzy = additionalFilteredItems.get(additionalItemKey).isFuzzy();
            int addItemId = this.getProcessedID(isFuzzy, additionalFilteredItems.get(additionalItemKey).getId());
            if (addItemId != (finalItemId = this.getProcessedID(isFuzzy, canonicalizedId))) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfContainerContainsItem(int itemID, List<InventorySetupsItem> setupContainer) {
        itemID = this.plugin.itemManager.canonicalize(itemID);
        for (InventorySetupsItem item : setupContainer) {
            int setupItemId = this.plugin.itemManager.canonicalize(item.getId());
            if (this.getProcessedID(item.isFuzzy(), itemID) != this.getProcessedID(item.isFuzzy(), setupItemId)) continue;
            return true;
        }
        return false;
    }

    private int getProcessedID(boolean isFuzzy, int itemId) {
        if (isFuzzy) {
            return InventorySetupsVariationMapping.map(itemId);
        }
        return itemId;
    }
}

