/*
 * Decompiled with CFR 0.152.
 */
package com.banktaglayouts;

import com.banktaglayouts.BankTagLayoutsPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.util.Text;

public class UsedToBeReflection {
    static final String ITEM_KEY_PREFIX = "item_";
    private final BankTagLayoutsPlugin plugin;

    public UsedToBeReflection(BankTagLayoutsPlugin plugin) {
        this.plugin = plugin;
    }

    void setIcon(String tag, String icon) {
        this.plugin.configManager.setConfiguration("banktags", "icon_" + Text.standardize((String)tag), icon);
    }

    boolean findTag(int itemId, String bankTagName) {
        Collection<String> tags = this.getTags(itemId, false);
        tags.addAll(this.getTags(itemId, true));
        return tags.stream().anyMatch(tag -> tag.startsWith(Text.standardize((String)bankTagName)));
    }

    Collection<String> getTags(int itemId, boolean variation) {
        return new LinkedHashSet<String>(Text.fromCSV((String)this.getTagString(itemId, variation).toLowerCase()));
    }

    String getTagString(int itemId, boolean variation) {
        String config = this.plugin.configManager.getConfiguration("banktags", ITEM_KEY_PREFIX + (itemId = this.getItemId(itemId, variation)));
        if (config == null) {
            return "";
        }
        return config;
    }

    private int getItemId(int itemId, boolean variation) {
        itemId = Math.abs(itemId);
        itemId = this.plugin.itemManager.canonicalize(itemId);
        if (variation) {
            itemId = ItemVariationMapping.map((int)itemId) * -1;
        }
        return itemId;
    }

    public void saveNewTab(String newTabName) {
        ArrayList<String> tabs = new ArrayList<String>(Text.fromCSV((String)this.plugin.configManager.getConfiguration("banktags", "tagtabs")));
        tabs.add(newTabName);
        String tags = Text.toCSV(tabs);
        this.plugin.configManager.setConfiguration("banktags", "tagtabs", tags);
    }

    public void loadTab(String name) {
        this.plugin.configManager.setConfiguration("banktags", "useTabs", (Object)false);
        this.plugin.configManager.setConfiguration("banktags", "useTabs", (Object)true);
    }

    public void openTag(String tag) {
    }

    public void scrollTab(int i) {
    }
}

