/*
 * Decompiled with CFR 0.152.
 */
package com.banktaglayouts;

import com.banktaglayouts.BankTagLayoutsConfig;
import com.banktaglayouts.BankTagLayoutsPlugin;
import com.banktaglayouts.Layout;
import inventorysetupz.InventorySetup;
import inventorysetupz.InventorySetupsItem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.client.game.ItemVariationMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutGenerator {
    private static final Logger log = LoggerFactory.getLogger(LayoutGenerator.class);
    private final BankTagLayoutsPlugin plugin;

    public Layout basicBankTagLayout(List<Integer> equippedItems, List<Integer> inventory, List<Integer> runePouch, List<Integer> additionalItems, Layout currentLayout, int duplicateLimit, BankTagLayoutsConfig.LayoutStyles layoutStyle) {
        return this.generateLayout(equippedItems, inventory, runePouch, additionalItems, currentLayout, duplicateLimit, layoutStyle);
    }

    public Layout generateLayout(List<Integer> equippedItems, List<Integer> inventory, List<Integer> runePouch, List<Integer> additionalItems, Layout currentLayout, int duplicateLimit, BankTagLayoutsConfig.LayoutStyles layoutStyle) {
        if (!this.hasRunePouch(inventory)) {
            runePouch = null;
        }
        equippedItems = equippedItems.stream().map(itemId -> this.plugin.itemManager.canonicalize(itemId.intValue())).collect(Collectors.toList());
        switch (layoutStyle) {
            case ZIGZAG: {
                return this.zigzagLayout(equippedItems, inventory, runePouch, additionalItems, currentLayout, duplicateLimit);
            }
            case PRESETS: {
                return this.presetsLayout(equippedItems, inventory, runePouch, additionalItems, currentLayout);
            }
        }
        throw new IllegalArgumentException("Please supply a layout style to this method.");
    }

    private boolean hasRunePouch(List<Integer> inventory) {
        Collection runePouchVariations = ItemVariationMapping.getVariations((int)12791);
        Collection divineRunePouchVariations = ItemVariationMapping.getVariations((int)27281);
        return inventory.stream().filter(itemId -> runePouchVariations.contains(itemId) || divineRunePouchVariations.contains(itemId)).findAny().isPresent();
    }

    public Layout basicInventorySetupsLayout(InventorySetup inventorySetup, Layout currentLayout, int duplicateLimit, BankTagLayoutsConfig.LayoutStyles layoutStyle, boolean includeRunepouchRunes) {
        List<Integer> inventory;
        List<Integer> equippedGear = inventorySetup.getEquipment() == null ? Collections.emptyList() : inventorySetup.getEquipment().stream().map(InventorySetupsItem::getId).collect(Collectors.toList());
        List<Integer> list = inventory = inventorySetup.getInventory() == null ? Collections.emptyList() : inventorySetup.getInventory().stream().map(InventorySetupsItem::getId).collect(Collectors.toList());
        List<Integer> runePouchRunes = includeRunepouchRunes ? (inventorySetup.getRune_pouch() == null ? Collections.emptyList() : inventorySetup.getRune_pouch().stream().map(InventorySetupsItem::getId).collect(Collectors.toList())) : Collections.emptyList();
        List<Integer> additionalItems = inventorySetup.getAdditionalFilteredItems() == null ? Collections.emptyList() : inventorySetup.getAdditionalFilteredItems().values().stream().map(InventorySetupsItem::getId).collect(Collectors.toList());
        return this.generateLayout(equippedGear, inventory, runePouchRunes, additionalItems, currentLayout, duplicateLimit, layoutStyle);
    }

    public Layout presetsLayout(List<Integer> equippedItems, List<Integer> inventory, List<Integer> runePouch, List<Integer> additionalItems, Layout currentLayout) {
        boolean hasPouch;
        Layout previewLayout = Layout.emptyLayout();
        while (equippedItems.size() < 14) {
            equippedItems.add(-1);
        }
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.HEAD.getSlotIdx()), 1);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.CAPE.getSlotIdx()), 8);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.AMULET.getSlotIdx()), 9);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.WEAPON.getSlotIdx()), 16);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.BODY.getSlotIdx()), 17);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.SHIELD.getSlotIdx()), 18);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.AMMO.getSlotIdx()), 10);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.LEGS.getSlotIdx()), 25);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.GLOVES.getSlotIdx()), 32);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.BOOTS.getSlotIdx()), 33);
        previewLayout.putItem(equippedItems.get(EquipmentInventorySlot.RING.getSlotIdx()), 34);
        int invRow = 0;
        int invCol = 4;
        int width = 8;
        for (Integer i : inventory) {
            previewLayout.putItem(i, invCol + invRow * width);
            if (invCol == 7) {
                invCol = 4;
                ++invRow;
                continue;
            }
            ++invCol;
        }
        boolean bl = hasPouch = runePouch != null;
        if (hasPouch) {
            int c = 0;
            for (Integer r : runePouch) {
                previewLayout.putItem(r, c + 40);
                ++c;
            }
        }
        for (Map.Entry<Integer, Integer> e : currentLayout.allPairs()) {
            if (!this.indexInAllowedSpace(inventory, e.getKey())) continue;
            previewLayout.putItem(e.getValue(), e.getKey());
        }
        for (Map.Entry<Integer, Integer> e : currentLayout.allPairs()) {
            if (this.indexInAllowedSpace(inventory, e.getKey()) || inventory.contains(e.getValue()) || equippedItems.contains(e.getValue()) || hasPouch && runePouch.contains(e.getValue())) continue;
            int index = 0;
            while (!this.indexInAllowedSpace(inventory, index) || previewLayout.getItemAtIndex(index) != -1) {
                ++index;
            }
            if (this.layoutContainsItem(e.getValue(), previewLayout)) continue;
            previewLayout.putItem(e.getValue(), index);
        }
        for (Integer i : additionalItems) {
            if (previewLayout.countItemsWithId(i) > 0) continue;
            int index = 0;
            while (!this.indexInAllowedSpace(inventory, index) || previewLayout.getItemAtIndex(index) > 0) {
                ++index;
            }
            previewLayout.putItem(i, index);
        }
        return previewLayout;
    }

    private boolean indexInAllowedSpace(List<Integer> inventory, int index) {
        int inventoryHeight = 0;
        int c = 1;
        for (Integer i : inventory) {
            if (i > 0) {
                inventoryHeight = (int)Math.ceil((double)c / 4.0);
            }
            ++c;
        }
        int[][] mask = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 1, 1}};
        for (int x = 0; x < inventoryHeight; ++x) {
            mask[x] = x == 6 ? new int[]{0, 0, 0, 0, 1, 1, 1, 1} : new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        }
        int[] flatMask = Arrays.stream(mask).flatMapToInt(Arrays::stream).toArray();
        return index >= 56 || flatMask[index] == 0;
    }

    public Layout zigzagLayout(List<Integer> equippedItems, List<Integer> inventory, List<Integer> runePouch, List<Integer> additionalItems, Layout currentLayout, int duplicateLimit) {
        Layout previewLayout = Layout.emptyLayout();
        List<Integer> displacedItems = new ArrayList<Integer>();
        log.debug("generate layout");
        log.debug("equipped gear is " + equippedItems);
        log.debug("inventory is " + inventory);
        int i = 0;
        i = this.layoutItems(equippedItems, currentLayout, previewLayout, displacedItems, i, true);
        inventory = inventory.stream().filter(integer -> integer != -1).collect(Collectors.toList());
        inventory = duplicateLimit <= 0 ? inventory.stream().distinct().collect(Collectors.toList()) : this.limitDuplicates(inventory, duplicateLimit);
        i = this.layoutItems(inventory, currentLayout, previewLayout, displacedItems, i, true);
        if (runePouch != null) {
            i = this.layoutItems(runePouch, currentLayout, previewLayout, displacedItems, i, false);
        }
        int displacedItemsStart = i = this.layoutItems(additionalItems, currentLayout, previewLayout, displacedItems, i, false);
        for (Map.Entry<Integer, Integer> itemPosition : currentLayout.allPairs()) {
            int index = itemPosition.getKey();
            int currentItemAtIndex = itemPosition.getValue();
            int previewItemAtIndex = previewLayout.getItemAtIndex(index);
            if (currentItemAtIndex == -1 || previewItemAtIndex != -1) continue;
            previewLayout.putItem(currentItemAtIndex, index);
        }
        displacedItems = displacedItems.stream().filter(id -> !this.layoutContainsItem((int)id, previewLayout)).collect(Collectors.toList());
        for (int j = displacedItemsStart; displacedItems.size() > 0 && j < 416; ++j) {
            int currentItemAtIndex = currentLayout.getItemAtIndex(j);
            if (currentItemAtIndex != -1) continue;
            Integer itemId = displacedItems.remove(0);
            previewLayout.putItem(itemId, j);
        }
        return previewLayout;
    }

    private List<Integer> limitDuplicates(List<Integer> inventory, int duplicateLimit) {
        int quantity;
        ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> groupedInventory = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
        int inARow = 0;
        int lastItemId = -1;
        for (Integer itemId : inventory) {
            if (lastItemId != itemId) {
                int quantity2 = inARow > duplicateLimit ? 1 : inARow;
                groupedInventory.add(new AbstractMap.SimpleEntry<Integer, Integer>(lastItemId, quantity2));
                inARow = 0;
            }
            ++inARow;
            lastItemId = itemId;
        }
        int n = quantity = inARow > duplicateLimit ? 1 : inARow;
        if (quantity > 0) {
            groupedInventory.add(new AbstractMap.SimpleEntry<Integer, Integer>(lastItemId, quantity));
        }
        inventory = groupedInventory.stream().flatMap(entry -> Collections.nCopies((Integer)entry.getValue(), (Integer)entry.getKey()).stream()).collect(Collectors.toList());
        return inventory;
    }

    private int layoutItems(List<Integer> inventory, Layout currentLayout, Layout previewLayout, List<Integer> displacedItems, int i, boolean useZigZag) {
        Optional<Integer> highestUsedIndex;
        for (Integer itemId : inventory) {
            if (itemId == -1) continue;
            int index = useZigZag ? LayoutGenerator.toZigZagIndex(i, 0, 0) : i;
            previewLayout.putItem(itemId, index);
            int currentLayoutItem = currentLayout.getItemAtIndex(index);
            if (currentLayoutItem != -1) {
                displacedItems.add(currentLayoutItem);
            }
            ++i;
        }
        if (!inventory.isEmpty() && (highestUsedIndex = previewLayout.getAllUsedIndexes().stream().max(Integer::compare)).isPresent()) {
            i = useZigZag ? (highestUsedIndex.get() / 16 * 2 + 2) * 8 : (highestUsedIndex.get() / 8 + 1) * 8;
        }
        return i;
    }

    private boolean layoutContainsItem(int id, Layout previewLayout) {
        int baseId = ItemVariationMapping.map((int)this.plugin.getNonPlaceholderId(id));
        for (Integer item : previewLayout.getAllUsedItemIds()) {
            if (baseId != ItemVariationMapping.map((int)this.plugin.getNonPlaceholderId(item))) continue;
            return true;
        }
        return false;
    }

    private static int toZigZagIndex(int inventoryIndex, int row, int col) {
        if (inventoryIndex < 0 || row < 0 || col < 0) {
            throw new IllegalArgumentException();
        }
        row += inventoryIndex / 16 * 2;
        inventoryIndex -= inventoryIndex / 16 * 16;
        int index = 0;
        index += inventoryIndex % 2 == 0 ? 0 : 8;
        index += inventoryIndex / 2;
        return index += row * 8 + col;
    }

    public LayoutGenerator(BankTagLayoutsPlugin plugin) {
        this.plugin = plugin;
    }
}

