/*
 * Decompiled with CFR 0.152.
 */
package com.banktaglayouts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Layout {
    private static final Logger log = LoggerFactory.getLogger(Layout.class);
    private Map<Integer, Integer> layoutMap = new HashMap<Integer, Integer>();

    public static Layout fromString(String layoutString) {
        return Layout.fromString(layoutString, false);
    }

    public static Layout fromString(String layoutString, boolean ignoreNfe) {
        Layout layout = Layout.emptyLayout();
        if (layoutString.isEmpty()) {
            return layout;
        }
        for (String s1 : layoutString.split(",")) {
            String[] split = s1.split(":");
            try {
                int itemId = Integer.parseInt(split[0]);
                int index = Integer.parseInt(split[1]);
                if (index >= 0) {
                    layout.putItem(itemId, index);
                    continue;
                }
                log.debug("Removed item " + itemId + " due to it having a negative index (" + index + ")");
            }
            catch (NumberFormatException e) {
                if (!ignoreNfe) {
                    throw e;
                }
                log.debug("input string \"" + layoutString + "\"");
            }
        }
        return layout;
    }

    public static Layout emptyLayout() {
        return new Layout();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Integer> integerIntegerEntry : this.allPairs()) {
            sb.append(integerIntegerEntry.getValue() + ":" + integerIntegerEntry.getKey() + ",");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public void putItem(int itemId, int index) {
        if (itemId <= 0) {
            this.layoutMap.remove(index);
            return;
        }
        this.layoutMap.put(index, itemId);
    }

    public int getItemAtIndex(int index) {
        return this.layoutMap.getOrDefault(index, -1);
    }

    public Iterator<Map.Entry<Integer, Integer>> allPairsIterator() {
        return this.layoutMap.entrySet().iterator();
    }

    public Integer getIndexForItem(int itemId) {
        return this.allPairs().stream().filter(e -> (Integer)e.getValue() == itemId).map(e -> (Integer)e.getKey()).findAny().orElse(-1);
    }

    private List<Integer> getIndexesForItem(int itemId) {
        return this.allPairs().stream().filter(e -> (Integer)e.getValue() == itemId).map(e -> (Integer)e.getKey()).collect(Collectors.toList());
    }

    public Collection<Integer> getAllUsedItemIds() {
        return new HashSet<Integer>(this.layoutMap.values());
    }

    public Collection<Integer> getAllUsedIndexes() {
        return this.layoutMap.keySet();
    }

    public Collection<Map.Entry<Integer, Integer>> allPairs() {
        return this.layoutMap.entrySet();
    }

    public int getFirstEmptyIndex() {
        return this.getFirstEmptyIndex(-1);
    }

    public int getFirstEmptyIndex(int afterThisIndex) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(this.getAllUsedIndexes());
        indexes.sort(Integer::compare);
        for (Integer integer : indexes) {
            if (integer < afterThisIndex) continue;
            if (integer - afterThisIndex > 1) break;
            afterThisIndex = integer;
        }
        return afterThisIndex + 1;
    }

    public void clearIndex(int index) {
        this.layoutMap.remove(index);
    }

    public void moveItem(int draggedItemIndex, int targetIndex, int draggedItemId) {
        int layoutItemId = this.getItemAtIndex(draggedItemIndex);
        if (draggedItemId == -1) {
            draggedItemId = layoutItemId;
            assert (draggedItemId != -1);
        } else if (layoutItemId != draggedItemId) {
            for (Integer index : this.getIndexesForItem(layoutItemId)) {
                this.putItem(draggedItemId, index);
            }
        }
        int targetItemId = this.getItemAtIndex(targetIndex);
        this.clearIndex(draggedItemIndex);
        this.clearIndex(targetIndex);
        this.putItem(draggedItemId, targetIndex);
        if (targetItemId != -1) {
            this.putItem(targetItemId, draggedItemIndex);
        }
    }

    public boolean isEmpty() {
        return this.layoutMap.isEmpty();
    }

    public int countItemsWithId(int idAtIndex) {
        int count = 0;
        for (Map.Entry<Integer, Integer> pair : this.allPairs()) {
            if (pair.getValue() != idAtIndex) continue;
            ++count;
        }
        return count;
    }

    public void duplicateItem(int clickedItemIndex, int itemIdAtIndex) {
        int duplicatedItemIndex = this.getFirstEmptyIndex(clickedItemIndex);
        int layoutItemId = this.getItemAtIndex(clickedItemIndex);
        if (itemIdAtIndex == -1) {
            itemIdAtIndex = layoutItemId;
        }
        if (layoutItemId != itemIdAtIndex) {
            List<Integer> indexesToChange = this.getIndexesForItem(layoutItemId);
            for (Integer index : indexesToChange) {
                this.putItem(itemIdAtIndex, index);
            }
        }
        this.putItem(itemIdAtIndex, duplicatedItemIndex);
    }
}

