/*
 * Decompiled with CFR 0.152.
 */
package com.banktaglayouts;

import com.banktaglayouts.BankTagLayoutsConfig;
import com.banktaglayouts.BankTagLayoutsPlugin;
import com.banktaglayouts.Layout;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeItemOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(FakeItemOverlay.class);
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private BankTagLayoutsPlugin plugin;
    @Inject
    private BankTagLayoutsConfig config;

    FakeItemOverlay() {
        this.drawAfterLayer(WidgetInfo.BANK_ITEM_CONTAINER);
        this.setLayer(OverlayLayer.MANUAL);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public Dimension render(Graphics2D graphics) {
        BankTagLayoutsPlugin.LayoutableThing currentLayoutableThing = this.plugin.getCurrentLayoutableThing();
        if (currentLayoutableThing == null) {
            return null;
        }
        Layout layout = this.plugin.getBankOrder(currentLayoutableThing);
        if (layout == null) {
            return null;
        }
        Widget bankItemContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (bankItemContainer == null) {
            return null;
        }
        int scrollY = bankItemContainer.getScrollY();
        Point canvasLocation = bankItemContainer.getCanvasLocation();
        int yOffset = 0;
        Widget widget = bankItemContainer;
        while (widget.getParent() != null) {
            yOffset += widget.getRelativeY();
            widget = widget.getParent();
        }
        Rectangle bankItemArea = new Rectangle(canvasLocation.getX() + 51 - 6, yOffset, bankItemContainer.getWidth() - 51 + 6, bankItemContainer.getHeight());
        graphics.clip(bankItemArea);
        for (BankTagLayoutsPlugin.FakeItem fakeItem : this.plugin.fakeItems) {
            if (fakeItem.isLayoutPlaceholder() && !this.config.showLayoutPlaceholders()) continue;
            int dragDeltaX = 0;
            int dragDeltaY = 0;
            if (fakeItem.index == this.plugin.draggedItemIndex && this.plugin.antiDrag.mayDrag()) {
                dragDeltaX = this.client.getMouseCanvasPosition().getX() - this.plugin.dragStartX;
                dragDeltaY = this.client.getMouseCanvasPosition().getY() - this.plugin.dragStartY;
                dragDeltaY += bankItemContainer.getScrollY() - this.plugin.dragStartScroll;
            }
            int fakeItemId = fakeItem.getItemId();
            int x = BankTagLayoutsPlugin.getXForIndex(fakeItem.index) + canvasLocation.getX() + dragDeltaX;
            int y = BankTagLayoutsPlugin.getYForIndex(fakeItem.index) + yOffset - scrollY + dragDeltaY;
            if (!((double)(y + 32) > bankItemArea.getMinY()) || !((double)y < bankItemArea.getMaxY())) continue;
            if (fakeItem.isLayoutPlaceholder()) {
                graphics.setComposite(AlphaComposite.getInstance(3, 0.3f));
                AsyncBufferedImage image = this.itemManager.getImage(fakeItemId, 1000, false);
                graphics.drawImage((Image)image, x, y, image.getWidth(), image.getHeight(), null);
                BufferedImage outline = this.itemManager.getItemOutline(fakeItemId, 1000, Color.GRAY);
                graphics.drawImage((Image)outline, x, y, null);
                continue;
            }
            if (fakeItem.quantity == 0) {
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
            } else {
                graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
            boolean showQuantity = this.itemManager.getItemComposition(fakeItemId).isStackable() || fakeItem.quantity != 1;
            AsyncBufferedImage image = this.itemManager.getImage(fakeItemId, fakeItem.quantity, showQuantity);
            graphics.drawImage((Image)image, x, y, image.getWidth(), image.getHeight(), null);
        }
        return null;
    }
}

