/*
 * Decompiled with CFR 0.152.
 */
package com.banktaglayouts;

import com.banktaglayouts.AntiDragPluginUtil;
import com.banktaglayouts.BankTagLayoutsConfig;
import com.banktaglayouts.FakeItemOverlay;
import com.banktaglayouts.Layout;
import com.banktaglayouts.LayoutGenerator;
import com.banktaglayouts.Sprites;
import com.banktaglayouts.UsedToBeReflection;
import com.banktaglayouts.VersionNumber;
import com.banktaglayouts.invsetupsstuff.InventorySetupsAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Runnables;
import com.google.gson.Gson;
import com.google.inject.Provides;
import inventorysetupz.InventorySetup;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.MessageNode;
import net.runelite.api.Point;
import net.runelite.api.ScriptEvent;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.DraggingWidgetChanged;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.MenuShouldLeftClick;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemVariationMapping;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.SpriteOverride;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.bank.BankSearch;
import net.runelite.client.plugins.banktags.BankTagsPlugin;
import net.runelite.client.plugins.banktags.TagManager;
import net.runelite.client.plugins.banktags.tabs.TabInterface;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Tag Layouts", description="Right click a bank tag tabs and click \"Enable layout\", select the tag tab, then drag items in the tag to reposition them.", tags={"bank", "tag", "layout"})
@PluginDependency(value=BankTagsPlugin.class)
public class BankTagLayoutsPlugin
extends Plugin
implements MouseListener {
    private static final Logger log = LoggerFactory.getLogger(BankTagLayoutsPlugin.class);
    public static final IntPredicate FILTERED_CHARS = c -> "</>:".indexOf(c) == -1;
    public static final Color itemTooltipColor = new Color(16748608);
    public static final String CONFIG_GROUP = "banktaglayouts";
    public static final String LAYOUT_CONFIG_KEY_PREFIX = "layout_";
    public static final String INVENTORY_SETUPS_LAYOUT_CONFIG_KEY_PREFIX = "inventory_setups_layout_";
    public static final String BANK_TAG_STRING_PREFIX = "banktaglayoutsplugin:";
    public static final String LAYOUT_EXPLICITLY_DISABLED = "DISABLED";
    public static final String ENABLE_LAYOUT = "Enable layout";
    public static final String DISABLE_LAYOUT = "Delete layout";
    public static final String IMPORT_LAYOUT = "Import tag tab with layout";
    public static final String EXPORT_LAYOUT = "Export tag tab with layout";
    public static final String REMOVE_FROM_LAYOUT_MENU_OPTION = "Remove-layout";
    public static final String PREVIEW_AUTO_LAYOUT = "Preview auto layout";
    public static final String DUPLICATE_ITEM = "Duplicate-item";
    public static final String REMOVE_DUPLICATE_ITEM = "Remove-duplicate-item";
    public static final int BANK_ITEM_WIDTH = 36;
    public static final int BANK_ITEM_HEIGHT = 32;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    public ItemManager itemManager;
    @Inject
    public ConfigManager configManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    TabInterface tabInterface;
    @Inject
    private TagManager tagManager;
    @Inject
    private FakeItemOverlay fakeItemOverlay;
    @Inject
    private BankSearch bankSearch;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private BankTagLayoutsConfig config;
    @Inject
    public Gson gson;
    private final Map<Integer, Widget> indexToWidget = new HashMap<Integer, Widget>();
    private Widget showLayoutPreviewButton = null;
    private Widget applyLayoutPreviewButton = null;
    private Widget cancelLayoutPreviewButton = null;
    private LayoutableThing lastLayoutable = null;
    private int lastHeight = Integer.MAX_VALUE;
    final AntiDragPluginUtil antiDrag = new AntiDragPluginUtil(this);
    private final LayoutGenerator layoutGenerator = new LayoutGenerator(this);
    private Layout previewLayout = null;
    private LayoutableThing previewLayoutable = null;
    private final InventorySetupsAdapter inventorySetupsAdapter = new InventorySetupsAdapter(this);
    private static final int[] AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
    private static final int[] RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};
    private String inventorySetup = null;
    int checkInventorySetup = 0;
    private UsedToBeReflection copyPaste = new UsedToBeReflection(this);
    private boolean tutorialMessageShown = false;
    public Set<FakeItem> fakeItems = new HashSet<FakeItem>();
    public volatile int draggedItemIndex = -1;
    public int dragStartX = 0;
    public int dragStartY = 0;
    public int dragStartScroll = 0;
    boolean sawMenuEntryAddedThisClientTick = false;
    private volatile boolean mouseIsPressed = false;

    private void updateButton() {
        if (this.showLayoutPreviewButton == null) {
            Widget parent = this.client.getWidget(WidgetInfo.BANK_CONTENT_CONTAINER);
            if (parent == null) {
                return;
            }
            this.showLayoutPreviewButton = parent.createChild(-1, 5);
            this.showLayoutPreviewButton.setOriginalHeight(18);
            this.showLayoutPreviewButton.setOriginalWidth(18);
            this.showLayoutPreviewButton.setYPositionMode(2);
            this.showLayoutPreviewButton.setOriginalX(434);
            this.showLayoutPreviewButton.setOriginalY(45);
            this.showLayoutPreviewButton.setSpriteId(Sprites.AUTO_LAYOUT.getSpriteId());
            this.showLayoutPreviewButton.setOnOpListener(new Object[]{e -> this.showLayoutPreview()});
            this.showLayoutPreviewButton.setHasListener(true);
            this.showLayoutPreviewButton.revalidate();
            this.showLayoutPreviewButton.setAction(0, PREVIEW_AUTO_LAYOUT);
            this.applyLayoutPreviewButton = parent.createChild(-1, 5);
            this.applyLayoutPreviewButton.setOriginalHeight(18);
            this.applyLayoutPreviewButton.setOriginalWidth(18);
            this.applyLayoutPreviewButton.setYPositionMode(2);
            this.applyLayoutPreviewButton.setOriginalX(404);
            this.applyLayoutPreviewButton.setOriginalY(45);
            this.applyLayoutPreviewButton.setSpriteId(Sprites.APPLY_PREVIEW.getSpriteId());
            this.applyLayoutPreviewButton.setNoClickThrough(true);
            this.applyLayoutPreviewButton.setOnOpListener(new Object[]{e -> this.applyLayoutPreview()});
            this.applyLayoutPreviewButton.setHasListener(true);
            this.applyLayoutPreviewButton.revalidate();
            this.applyLayoutPreviewButton.setAction(0, "Use this layout");
            this.cancelLayoutPreviewButton = parent.createChild(-1, 5);
            this.cancelLayoutPreviewButton.setOriginalHeight(18);
            this.cancelLayoutPreviewButton.setOriginalWidth(18);
            this.cancelLayoutPreviewButton.setYPositionMode(2);
            this.cancelLayoutPreviewButton.setOriginalX(434);
            this.cancelLayoutPreviewButton.setOriginalY(45);
            this.cancelLayoutPreviewButton.setSpriteId(Sprites.CANCEL_PREVIEW.getSpriteId());
            this.cancelLayoutPreviewButton.setNoClickThrough(true);
            this.cancelLayoutPreviewButton.setOnOpListener(new Object[]{e -> this.cancelLayoutPreview()});
            this.cancelLayoutPreviewButton.setHasListener(true);
            this.cancelLayoutPreviewButton.revalidate();
            this.cancelLayoutPreviewButton.setAction(0, "Cancel preview");
        }
        this.hideLayoutPreviewButtons(!this.isShowingPreview());
        this.showLayoutPreviewButton.setHidden(!this.config.showAutoLayoutButton() || this.getCurrentLayoutableThing() == null || this.isShowingPreview());
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 12) {
            this.showLayoutPreviewButton = null;
        }
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.fakeItemOverlay);
        this.spriteManager.addSpriteOverrides((SpriteOverride[])Sprites.values());
        this.mouseManager.registerMouseListener((MouseListener)this);
        this.keyManager.registerKeyListener((KeyListener)this.antiDrag);
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.showLayoutPreviewButton = null;
                this.updateButton();
                this.bankSearch.layoutBank();
            }
        });
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.fakeItemOverlay);
        this.spriteManager.removeSpriteOverrides((SpriteOverride[])Sprites.values());
        this.mouseManager.unregisterMouseListener((MouseListener)this);
        this.keyManager.unregisterKeyListener((KeyListener)this.antiDrag);
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.indexToWidget.clear();
                this.cancelLayoutPreview();
                if (this.showLayoutPreviewButton != null) {
                    this.showLayoutPreviewButton.setHidden(true);
                }
                this.bankSearch.layoutBank();
            }
        });
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (CONFIG_GROUP.equals(event.getGroup())) {
            if ("layoutEnabledByDefault".equals(event.getKey())) {
                this.clientThread.invokeLater(() -> this.applyCustomBankTagItemPositions());
            } else if ("showAutoLayoutButton".equals(event.getKey())) {
                this.clientThread.invokeLater(this::updateButton);
            } else if ("useWithInventorySetups".equals(event.getKey())) {
                this.clientThread.invokeLater(() -> ((BankSearch)this.bankSearch).layoutBank());
            }
        } else if ("banktags".equals(event.getGroup()) && "tagtabs".equals(event.getKey())) {
            this.handlePotentialTagRename(event);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.LOGGED_IN) {
            this.checkVersionUpgrade();
        }
    }

    private void onVersionUpgraded(VersionNumber previousVersion, VersionNumber newVersion) {
        if (previousVersion.compareTo(new VersionNumber(1, 4, 10)) < 0 && this.config.updateMessages()) {
            this.clientThread.invokeLater(() -> {
                this.chatMessage(ColorUtil.wrapWithColorTag((String)"Bank Tag Layouts ", (Color)Color.RED) + "new version: 1.4.10");
                this.chatMessage(" - New Auto-layout mode \"Presets\" shows your gear and inventory in a prettier way. You can switch to it in the plugin's config.");
            });
        }
        if (previousVersion.compareTo(new VersionNumber(1, 4, 11)) < 0) {
            String prefix = "banktaglayouts.inventory_setups_layout_";
            for (String key : this.configManager.getConfigurationKeys(prefix)) {
                String inventorySetupName = key.substring(prefix.length());
                String layoutString = this.configManager.getConfiguration(CONFIG_GROUP, INVENTORY_SETUPS_LAYOUT_CONFIG_KEY_PREFIX + inventorySetupName);
                String escapedKey = LayoutableThing.inventorySetup(inventorySetupName).configKey();
                this.configManager.setConfiguration(CONFIG_GROUP, escapedKey, layoutString);
            }
        }
    }

    void checkVersionUpgrade() {
        try {
            InputStream is = BankTagLayoutsPlugin.class.getResourceAsStream("/version.txt");
            try {
                Properties props = new Properties();
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    log.error("unable to load version number", (Throwable)e);
                    if (is != null) {
                        is.close();
                    }
                    return;
                }
                VersionNumber buildVersion = new VersionNumber(props.getProperty("version"));
                String previousVersionString = this.configManager.getConfiguration(CONFIG_GROUP, "version");
                boolean assumeFreshInstall = previousVersionString == null && this.configManager.getConfigurationKeys("banktaglayouts.layout_").size() == 0 && this.configManager.getConfigurationKeys("banktaglayouts.inventory_setups_layout_").size() == 0;
                VersionNumber previousVersion = new VersionNumber(previousVersionString);
                if (buildVersion.compareTo(previousVersion) > 0 && !assumeFreshInstall) {
                    this.onVersionUpgraded(previousVersion, buildVersion);
                }
                this.configManager.setConfiguration(CONFIG_GROUP, "version", (Object)buildVersion);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("unable to close version file.", (Throwable)e);
        }
    }

    private void handlePotentialTagRename(ConfigChanged event) {
        if (!this.client.isClientThread()) {
            return;
        }
        String oldValue = event.getOldValue();
        String newValue = event.getNewValue();
        HashSet oldTags = new HashSet(Text.fromCSV((String)(oldValue == null ? "" : oldValue)));
        HashSet newTags = new HashSet(Text.fromCSV((String)(newValue == null ? "" : newValue)));
        Iterator iter = oldTags.iterator();
        while (iter.hasNext()) {
            String oldTag = (String)iter.next();
            if (!newTags.remove(oldTag)) continue;
            iter.remove();
        }
        if (oldTags.size() != 1 || newTags.size() != 1) {
            return;
        }
        LayoutableThing oldName = LayoutableThing.bankTag((String)oldTags.iterator().next());
        String newName = (String)newTags.iterator().next();
        Layout oldLayout = this.getBankOrder(oldName);
        if (oldLayout != null) {
            this.saveLayout(LayoutableThing.bankTag(newName), oldLayout);
            this.configManager.unsetConfiguration(CONFIG_GROUP, oldName.configKey());
        }
    }

    @Provides
    BankTagLayoutsConfig getConfig(ConfigManager configManager) {
        return (BankTagLayoutsConfig)configManager.getConfig(BankTagLayoutsConfig.class);
    }

    private void applyLayoutPreview() {
        if (this.previewLayoutable.isBankTab()) {
            for (Integer itemId : this.previewLayout.getAllUsedItemIds()) {
                if (this.copyPaste.findTag(itemId, this.previewLayoutable.name)) continue;
                log.debug("adding item " + this.itemNameWithId(itemId) + " to tag");
                this.tagManager.addTag(itemId.intValue(), this.previewLayoutable.name, false);
            }
        }
        this.saveLayoutNonPreview(this.previewLayoutable, this.previewLayout);
        this.cancelLayoutPreview();
        this.bankSearch.layoutBank();
    }

    private void hideLayoutPreviewButtons(boolean hide) {
        if (this.applyLayoutPreviewButton != null) {
            this.applyLayoutPreviewButton.setHidden(hide);
        }
        if (this.cancelLayoutPreviewButton != null) {
            this.cancelLayoutPreviewButton.setHidden(hide);
        }
        if (this.showLayoutPreviewButton != null && this.config.showAutoLayoutButton() && this.getCurrentLayoutableThing() != null) {
            this.showLayoutPreviewButton.setHidden(!hide);
        }
    }

    private void cancelLayoutPreview() {
        this.previewLayout = null;
        this.previewLayoutable = null;
        this.hideLayoutPreviewButtons(true);
        this.applyCustomBankTagItemPositions();
    }

    private void showLayoutPreview() {
        if (this.isShowingPreview()) {
            return;
        }
        LayoutableThing currentLayoutableThing = this.getCurrentLayoutableThing();
        if (currentLayoutableThing == null) {
            this.chatMessage("Select a tag tab before using this feature.");
            return;
        }
        if (currentLayoutableThing.isBankTab()) {
            List<Integer> equippedGear = this.getEquippedGear();
            List<Integer> inventory = this.getInventory();
            if (equippedGear.stream().noneMatch(id -> id > 0) && inventory.stream().noneMatch(id -> id > 0)) {
                this.chatMessage("This feature uses your equipped items and inventory to automatically create a bank tag layout, but you don't have any items equipped or in your inventory.");
                return;
            }
            this.hideLayoutPreviewButtons(false);
            Layout currentLayout = this.getBankOrderNonPreview(currentLayoutableThing);
            if (currentLayout == null) {
                currentLayout = Layout.emptyLayout();
            }
            this.previewLayout = this.layoutGenerator.basicBankTagLayout(equippedGear, inventory, this.config.autoLayoutIncludeRunePouchRunes() ? this.getRunePouchRunes() : Collections.emptyList(), Collections.emptyList(), currentLayout, this.getAutoLayoutDuplicateLimit(), this.config.autoLayoutStyle());
        } else {
            InventorySetup inventorySetup = this.inventorySetupsAdapter.getInventorySetup(currentLayoutableThing.name);
            Layout currentLayout = this.getBankOrderNonPreview(currentLayoutableThing);
            if (currentLayout == null) {
                currentLayout = Layout.emptyLayout();
            }
            this.previewLayout = this.layoutGenerator.basicInventorySetupsLayout(inventorySetup, currentLayout, this.getAutoLayoutDuplicateLimit(), this.config.autoLayoutStyle(), this.config.autoLayoutIncludeRunePouchRunes());
        }
        this.hideLayoutPreviewButtons(false);
        this.previewLayoutable = currentLayoutableThing;
        this.applyCustomBankTagItemPositions();
    }

    private int getAutoLayoutDuplicateLimit() {
        return !this.config.autoLayoutDuplicatesEnabled() ? 0 : this.config.autoLayoutDuplicateLimit();
    }

    private List<Integer> getEquippedGear() {
        ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (container == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(container.getItems()).map(Item::getId).collect(Collectors.toList());
    }

    private List<Integer> getInventory() {
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        if (container == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(container.getItems()).map(w -> w.getId()).collect(Collectors.toList());
    }

    private boolean isShowingPreview() {
        return this.previewLayout != null;
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        MenuEntry menuEntry;
        MenuEntry[] menuEntries;
        Widget widget;
        if (this.checkInventorySetup + 1 == this.client.getGameCycle()) {
            this.updateInventorySetupShown();
        }
        if ((widget = this.client.getWidget(WidgetInfo.BANK_CONTAINER)) == null || widget.isHidden()) {
            return;
        }
        if (this.config.preventVanillaPlaceholderMenuBug() && this.client.getDraggedWidget() != null && this.client.getDraggedOnWidget() != null && (menuEntries = this.client.getMenuEntries()).length >= 1 && WidgetInfo.TO_GROUP((int)(menuEntry = menuEntries[menuEntries.length - 1]).getParam1()) == 12 && menuEntry.getOption().equals("Release")) {
            menuEntry.setType(MenuAction.CC_OP);
        }
        this.sawMenuEntryAddedThisClientTick = false;
    }

    private List<Integer> getRunePouchRunes() {
        ArrayList<Integer> runes = new ArrayList<Integer>(AMOUNT_VARBITS.length);
        EnumComposition runepouchEnum = this.client.getEnum(982);
        for (int i = 0; i < AMOUNT_VARBITS.length; ++i) {
            int amount = this.client.getVarbitValue(AMOUNT_VARBITS[i]);
            if (amount <= 0) continue;
            int runeId = this.client.getVarbitValue(RUNE_VARBITS[i]);
            int runeItemId = runepouchEnum.getIntValue(runeId);
            runes.add(runeItemId);
        }
        return runes;
    }

    private void updateInventorySetupShown() {
        Widget bankTitleBar = this.client.getWidget(WidgetInfo.BANK_TITLE_BAR);
        String newSetup = null;
        if (bankTitleBar != null) {
            String bankTitle = bankTitleBar.getText();
            Matcher matcher = Pattern.compile("Inventory Setup <col=ff0000>(?<setup>.*) - (?<subfilter>.*)</col>.*").matcher(bankTitle);
            if (matcher.matches()) {
                newSetup = matcher.group("setup");
            }
        }
        this.inventorySetup = newSetup;
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed widgetClosed) {
        if (widgetClosed.getGroupId() == 12) {
            this.checkInventorySetup = this.client.getGameCycle();
        }
    }

    @Subscribe(priority=-1.0f)
    public void onScriptPreFired(ScriptPreFired event) {
        int height;
        if (event.getScriptId() != 505) {
            return;
        }
        this.updateInventorySetupShown();
        LayoutableThing layoutable = this.getCurrentLayoutableThing();
        if (layoutable == null) {
            return;
        }
        Layout layout = this.getBankOrder(layoutable);
        if (layout == null) {
            return;
        }
        int maxIndex = layout.getAllUsedIndexes().stream().max(Integer::compare).orElse(0);
        this.client.getIntStack()[this.client.getIntStackSize() - 7] = height = BankTagLayoutsPlugin.getYForIndex(maxIndex) + 32;
    }

    @Subscribe(priority=-1.0f)
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 277) {
            LayoutableThing layoutable = this.getCurrentLayoutableThing();
            if (layoutable == null || !layoutable.equals(this.lastLayoutable)) {
                this.cancelLayoutPreview();
            }
            this.applyCustomBankTagItemPositions(false);
            this.lastLayoutable = layoutable;
            this.updateButton();
        }
    }

    private void importLayout() {
        Layout layout;
        String layoutString;
        String name;
        String clipboardData;
        try {
            clipboardData = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString().trim();
        }
        catch (UnsupportedFlavorException | IOException e) {
            this.chatErrorMessage("import failed:", " couldn't get an import string from the clipboard");
            return;
        }
        if (!clipboardData.startsWith(BANK_TAG_STRING_PREFIX)) {
            if (Pattern.compile("[^,]+,\\d+(,[\\d-]+)*").matcher(clipboardData).matches()) {
                this.chatErrorMessage("import failed:", " This looks like a regular bank tag, try using \"Import tag tab\" instead of \"Import tag tab with layout\".");
            } else {
                this.chatErrorMessage("import failed:", " Invalid format. layout-ed tag data starts with \"banktaglayoutsplugin:\"; did you copy the wrong thing?");
            }
            return;
        }
        String[] split = clipboardData.split(",banktag:");
        if (split.length != 2) {
            this.chatErrorMessage("import failed:", " invalid format. layout string doesn't include regular bank tag data (It should say \"banktag:\" somewhere in the import string). Maybe you didn't copy the whole thing?");
            return;
        }
        String prefixRemoved = split[0].substring(BANK_TAG_STRING_PREFIX.length());
        int firstCommaIndex = prefixRemoved.indexOf(",");
        if (firstCommaIndex == -1) {
            name = prefixRemoved;
            layoutString = "";
        } else {
            name = prefixRemoved.substring(0, firstCommaIndex);
            layoutString = prefixRemoved.substring(name.length() + 1);
        }
        name = this.validateTagName(name);
        if (name == null) {
            return;
        }
        try {
            layout = Layout.fromString(layoutString);
        }
        catch (NumberFormatException e) {
            this.chatErrorMessage("import failed:", " something in the layout data is not a number");
            return;
        }
        String tagString = split[1];
        log.debug("import string: {}, {}, {}", new Object[]{name, layoutString, split[1]});
        if (!this.tagManager.getItemsForTag(name).isEmpty()) {
            String finalName = name;
            this.chatboxPanelManager.openTextMenuInput("Tag tab with same name (" + name + ") already exists.").option("Keep both, renaming imported tab", () -> this.clientThread.invokeLater(() -> {
                String newName = this.generateUniqueName(finalName);
                if (newName == null) {
                    this.chatErrorMessage("import failed:", " couldn't find a unique name. do you literally have 100 similarly named tags???????????");
                    return;
                }
                this.importLayout(newName, layout, tagString);
            })).option("Overwrite existing tab", () -> this.clientThread.invokeLater(() -> this.importLayout(finalName, layout, tagString))).option("Cancel", Runnables::doNothing).build();
        } else {
            this.importLayout(name, layout, tagString);
        }
    }

    private String generateUniqueName(String name) {
        for (int i = 2; i < 100; ++i) {
            String newName = "(" + i + ") " + name;
            if (!this.tagManager.getItemsForTag(newName).isEmpty()) continue;
            return newName;
        }
        return null;
    }

    private void importLayout(String name, Layout layout, String tagString) {
        boolean successful = this.importBankTag(name, tagString);
        if (!successful) {
            return;
        }
        this.saveLayout(LayoutableThing.bankTag(name), layout);
        this.chatMessage("Imported layout-ed tag tab \"" + name + "\"");
        this.applyCustomBankTagItemPositions();
    }

    void saveLayout(LayoutableThing layoutable, Layout layout) {
        if (this.isShowingPreview()) {
            this.previewLayout = layout;
            return;
        }
        this.saveLayoutNonPreview(layoutable, layout);
    }

    private void saveLayoutNonPreview(LayoutableThing layoutable, Layout layout) {
        this.configManager.setConfiguration(CONFIG_GROUP, layoutable.configKey(), layout.toString());
    }

    private String validateTagName(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            if (!FILTERED_CHARS.test(c)) continue;
            sb.append(c);
        }
        if (sb.length() == 0) {
            this.chatErrorMessage("import failed:", " tag name does not contain any valid characters.");
            return null;
        }
        return sb.toString().toLowerCase();
    }

    private boolean importBankTag(String name, String tagString) {
        log.debug("importing tag data. " + tagString);
        Iterator dataIter = Text.fromCSV((String)tagString).iterator();
        dataIter.next();
        String icon = (String)dataIter.next();
        this.copyPaste.setIcon(name, icon);
        this.tagManager.removeTag(name);
        while (dataIter.hasNext()) {
            int itemId;
            this.tagManager.addTag(itemId, name, (itemId = Integer.parseInt((String)dataIter.next())) < 0);
        }
        this.copyPaste.saveNewTab(name);
        this.copyPaste.loadTab(name);
        return true;
    }

    public boolean hasLayoutEnabled(LayoutableThing layoutable) {
        if (layoutable == null) {
            return false;
        }
        if (this.isShowingPreview()) {
            return true;
        }
        String configuration = this.configManager.getConfiguration(CONFIG_GROUP, layoutable.configKey());
        if (LAYOUT_EXPLICITLY_DISABLED.equals(configuration)) {
            return false;
        }
        return configuration != null || layoutable.isBankTab() && this.config.layoutEnabledByDefault() || layoutable.isInventorySetup() && this.config.useWithInventorySetups();
    }

    private void enableLayout(LayoutableThing layoutable) {
        this.saveLayout(layoutable, Layout.emptyLayout());
        if (layoutable.equals(this.getCurrentLayoutableThing())) {
            this.applyCustomBankTagItemPositions();
        }
    }

    private void disableLayout(String bankTagName) {
        this.chatboxPanelManager.openTextMenuInput("Delete layout for " + bankTagName + "?").option("Yes", () -> this.clientThread.invoke(() -> {
            this.configManager.setConfiguration(CONFIG_GROUP, LAYOUT_CONFIG_KEY_PREFIX + bankTagName, LAYOUT_EXPLICITLY_DISABLED);
            if (this.tabInterface.getActiveTab() != null && bankTagName.equals(this.tabInterface.getActiveTab().getTag())) {
                this.bankSearch.layoutBank();
            }
        })).option("No", Runnables::doNothing).build();
    }

    private void applyCustomBankTagItemPositions() {
        this.applyCustomBankTagItemPositions(true);
    }

    private void applyCustomBankTagItemPositions(boolean setScroll) {
        this.fakeItems.clear();
        LayoutableThing layoutable = this.getCurrentLayoutableThing();
        if (layoutable == null) {
            return;
        }
        log.debug("applyCustomBankTagItemPositions: " + layoutable);
        this.indexToWidget.clear();
        Layout layout = this.getBankOrder(layoutable);
        if (layout == null) {
            return;
        }
        List<Widget> bankItems = Arrays.stream(this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER).getDynamicChildren()).filter(bankItem -> !bankItem.isHidden() && bankItem.getItemId() >= 0).collect(Collectors.toList());
        if (!this.hasLayoutEnabled(layoutable)) {
            for (Widget bankItem2 : bankItems) {
                bankItem2.setOnDragCompleteListener(new Object[]{ev -> {
                    boolean tutorialShown = this.tutorialMessage();
                    if (!tutorialShown) {
                        this.bankReorderWarning(ev);
                    }
                }});
            }
            return;
        }
        if (!this.isShowingPreview()) {
            this.cleanItemsNotInBankTag(layout, layoutable);
        }
        this.indexToWidget.putAll(this.assignItemPositions(layout, bankItems));
        this.moveDuplicateItem();
        this.updateFakeItems(layout);
        for (Widget bankItem3 : bankItems) {
            bankItem3.setOnDragCompleteListener(new Object[]{ev -> this.customBankTagOrderInsert(layoutable, ev.getSource())});
        }
        this.setItemPositions(this.indexToWidget);
        int maxIndex = layout.getAllUsedIndexes().stream().max(Integer::compare).orElse(0);
        int height = BankTagLayoutsPlugin.getYForIndex(maxIndex) + 32 + 8;
        if (setScroll && layoutable.equals(this.lastLayoutable) && height != this.lastHeight) {
            this.resizeBankContainerScrollbar(height, this.lastHeight);
        }
        this.lastHeight = height;
        this.saveLayout(layoutable, layout);
        log.debug("saved tag " + layoutable);
    }

    Map<Integer, Widget> assignItemPositions(Layout layout, List<Widget> bankItems) {
        HashMap<Integer, Widget> indexToWidget = new HashMap<Integer, Widget>();
        this.assignVariantItemPositions(layout, bankItems, indexToWidget);
        this.assignNonVariantItemPositions(layout, bankItems, indexToWidget);
        return indexToWidget;
    }

    private void updateFakeItems(Layout layout) {
        this.fakeItems = this.calculateFakeItems(layout, this.indexToWidget);
    }

    Set<FakeItem> calculateFakeItems(Layout layout, Map<Integer, Widget> indexToWidget) {
        HashSet<FakeItem> fakeItems = new HashSet<FakeItem>();
        for (Map.Entry<Integer, Integer> entry : layout.allPairs()) {
            Integer index = entry.getKey();
            if (indexToWidget.containsKey(index)) continue;
            int itemId = entry.getValue();
            Optional<Widget> any = layout.allPairs().stream().filter(e -> (Integer)e.getValue() == itemId).map(e -> (Widget)indexToWidget.get(e.getKey())).filter(widget -> widget != null).findAny();
            boolean isLayoutPlaceholder = !any.isPresent();
            int quantity = any.isPresent() ? any.get().getItemQuantity() : -1;
            int fakeItemItemId = any.isPresent() ? any.get().getItemId() : itemId;
            fakeItems.add(new FakeItem(index, fakeItemItemId, isLayoutPlaceholder, quantity));
        }
        return fakeItems;
    }

    LayoutableThing getCurrentLayoutableThing() {
        boolean isBankTag = this.tabInterface.isActive();
        if (!(isBankTag || this.inventorySetup != null && this.config.useWithInventorySetups())) {
            return null;
        }
        String name = isBankTag ? this.tabInterface.getActiveTab().getTag() : this.inventorySetup;
        return new LayoutableThing(name, isBankTag);
    }

    private void bankReorderWarning(ScriptEvent ev) {
        if (this.config.warnForAccidentalBankReorder() && ev.getSource().getId() == WidgetInfo.BANK_ITEM_CONTAINER.getId() && this.tabInterface.isActive() && this.client.getDraggedOnWidget() != null && this.client.getDraggedOnWidget().getId() == WidgetInfo.BANK_ITEM_CONTAINER.getId() && this.tabInterface.isActive() && !this.hasLayoutEnabled(this.getCurrentLayoutableThing()) && !Boolean.parseBoolean(this.configManager.getConfiguration("banktags", "preventTagTabDrags"))) {
            this.chatErrorMessage("You just reordered your actual bank!");
            this.chatMessage("If you wanted to use a bank tag layout, make sure you enable it for this tab first.");
            this.chatMessage("You should consider enabling \"Prevent tag tab item dragging\" in the Bank Tags plugin.");
            this.chatMessage("You can disable this warning in the Bank Tag Layouts config.");
        }
    }

    private boolean tutorialMessage() {
        if (!this.config.tutorialMessage()) {
            return false;
        }
        for (String key : this.configManager.getConfigurationKeys(CONFIG_GROUP)) {
            if (!key.startsWith("banktaglayouts.layout_")) continue;
            return false;
        }
        if (!this.tutorialMessageShown) {
            this.tutorialMessageShown = true;
            this.chatMessage("If you want to use Bank Tag Layouts, enable it for the tab by right clicking the tag tab and clicking \"Enable layout\".");
            this.chatMessage("To disable this message, to go the Bank Tag Layouts config and disable \"Layout enable tutorial message\".");
            return true;
        }
        return false;
    }

    private void assignNonVariantItemPositions(Layout layout, List<Widget> bankItems, Map<Integer, Widget> indexToWidget) {
        for (Widget bankItem : bankItems) {
            int itemId = bankItem.getItemId();
            int nonPlaceholderId = this.getNonPlaceholderId(itemId);
            if (this.itemShouldBeTreatedAsHavingVariants(nonPlaceholderId)) continue;
            Integer indexForItem = layout.getIndexForItem(itemId);
            if (indexForItem == -1) {
                int otherItemId = this.switchPlaceholderId(itemId);
                indexForItem = layout.getIndexForItem(otherItemId);
            }
            if (indexForItem == -1) {
                indexForItem = layout.getFirstEmptyIndex();
                layout.putItem(itemId, indexForItem);
            }
            indexToWidget.put(indexForItem, bankItem);
        }
    }

    public MouseEvent mouseClicked(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mousePressed(MouseEvent mouseEvent) {
        this.mouseIsPressed = true;
        if (mouseEvent.getButton() != 1 || !this.hasLayoutEnabled(this.getCurrentLayoutableThing()) || !this.config.showLayoutPlaceholders() || this.client.isMenuOpen()) {
            return mouseEvent;
        }
        if (this.isShowingPreview() && this.applyLayoutPreviewButton != null && this.applyLayoutPreviewButton.contains(this.client.getMouseCanvasPosition())) {
            return mouseEvent;
        }
        int index = this.getIndexForMousePosition(true);
        FakeItem fakeItem = this.fakeItems.stream().filter(fake -> fake.index == index).findAny().orElse(null);
        if (fakeItem != null) {
            this.draggedItemIndex = fakeItem.index;
            this.dragStartX = mouseEvent.getX();
            this.dragStartY = mouseEvent.getY();
            this.dragStartScroll = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER).getScrollY();
            this.antiDrag.startDrag();
            mouseEvent.consume();
        }
        return mouseEvent;
    }

    public MouseEvent mouseReleased(MouseEvent mouseEvent) {
        this.mouseIsPressed = false;
        if (mouseEvent.getButton() != 1 || !this.hasLayoutEnabled(this.getCurrentLayoutableThing())) {
            return mouseEvent;
        }
        if (this.draggedItemIndex == -1) {
            return mouseEvent;
        }
        if (this.config.showLayoutPlaceholders()) {
            int draggedOnIndex = this.getIndexForMousePositionNoLowerLimit();
            this.clientThread.invokeLater(() -> {
                if (draggedOnIndex != -1 && this.antiDrag.mayDrag()) {
                    this.customBankTagOrderInsert(this.getCurrentLayoutableThing(), this.draggedItemIndex, draggedOnIndex);
                }
                this.antiDrag.endDrag();
                this.draggedItemIndex = -1;
            });
        }
        mouseEvent.consume();
        return mouseEvent;
    }

    public MouseEvent mouseEntered(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseExited(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseDragged(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseMoved(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded menuEntryAdded) {
        Widget widget = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        if (widget == null || widget.isHidden()) {
            return;
        }
        if (!this.sawMenuEntryAddedThisClientTick) {
            boolean movedItemWidget;
            this.sawMenuEntryAddedThisClientTick = true;
            if (!this.mouseIsPressed && (movedItemWidget = this.moveDuplicateItem())) {
                this.updateFakeItems(this.getBankOrder(this.getCurrentLayoutableThing()));
                this.setItemPositions(this.indexToWidget);
            }
        }
        this.addBankTagTabMenuEntries(menuEntryAdded);
        this.addFakeItemMenuEntries(menuEntryAdded);
        this.addDuplicateItemMenuEntries(menuEntryAdded);
    }

    private void addBankTagTabMenuEntries(MenuEntryAdded menuEntryAdded) {
        if (WidgetInfo.TO_GROUP((int)menuEntryAdded.getActionParam1()) == WidgetInfo.BANK_CONTENT_CONTAINER.getGroupId()) {
            String bankTagName = Text.removeTags((String)menuEntryAdded.getTarget()).replace("\u00a0", " ");
            if ("Rename tag tab".equals(menuEntryAdded.getOption())) {
                LayoutableThing layoutable = LayoutableThing.bankTag(bankTagName);
                if (this.hasLayoutEnabled(layoutable)) {
                    this.addEntry(bankTagName, EXPORT_LAYOUT);
                }
                this.addEntry(bankTagName, this.hasLayoutEnabled(layoutable) ? DISABLE_LAYOUT : ENABLE_LAYOUT);
            } else if ("New tag tab".equals(menuEntryAdded.getOption())) {
                if (!this.config.showAutoLayoutButton()) {
                    this.addEntry(bankTagName, PREVIEW_AUTO_LAYOUT);
                }
                this.addEntry(bankTagName, IMPORT_LAYOUT);
            }
        }
    }

    private boolean moveDuplicateItem() {
        if (this.getCurrentLayoutableThing() == null) {
            return false;
        }
        int mousePositionIndex = this.getIndexForMousePosition();
        Layout layout = this.getBankOrder(this.getCurrentLayoutableThing());
        if (layout == null) {
            return false;
        }
        int itemId = layout.getItemAtIndex(mousePositionIndex);
        if (itemId == -1) {
            return false;
        }
        int count = 0;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> entry : layout.allPairs()) {
            if (entry.getValue() != itemId) continue;
            ++count;
            indexes.add(entry.getKey());
        }
        if (count > 1) {
            for (Integer index : indexes) {
                if (!this.indexToWidget.containsKey(index) || index == mousePositionIndex) continue;
                Widget widget = this.indexToWidget.get(index);
                this.indexToWidget.remove(index);
                this.indexToWidget.put(mousePositionIndex, widget);
                return true;
            }
        }
        return false;
    }

    private void addDuplicateItemMenuEntries(MenuEntryAdded menuEntryAdded) {
        if (this.config.shiftModifierForExtraBankItemOptions() && !this.client.isKeyPressed(81)) {
            return;
        }
        LayoutableThing layoutable = this.getCurrentLayoutableThing();
        if (layoutable == null) {
            return;
        }
        Layout layout = this.getBankOrder(layoutable);
        if (layout == null) {
            return;
        }
        int index = this.getIndexForMousePosition(true);
        if (index == -1) {
            return;
        }
        int itemIdAtIndex = layout.getItemAtIndex(index);
        if (itemIdAtIndex == -1) {
            return;
        }
        boolean isRealItem = this.indexToWidget.containsKey(index);
        if (!menuEntryAdded.getOption().equals("Examine") && isRealItem) {
            return;
        }
        boolean isLayoutPlaceholder = this.fakeItems.stream().filter(fakeItem -> fakeItem.getIndex() == index && fakeItem.isLayoutPlaceholder()).findAny().isPresent();
        int itemCount = layout.countItemsWithId(itemIdAtIndex);
        if (itemCount > 1 && !isLayoutPlaceholder) {
            this.client.createMenuEntry(-1).setOption(REMOVE_DUPLICATE_ITEM).setTarget(ColorUtil.wrapWithColorTag((String)this.itemName(itemIdAtIndex), (Color)itemTooltipColor)).setType(MenuAction.RUNELITE_OVERLAY).setParam0(index);
        }
        this.client.createMenuEntry(-1).setOption(DUPLICATE_ITEM).setTarget(ColorUtil.wrapWithColorTag((String)this.itemName(itemIdAtIndex), (Color)itemTooltipColor)).setType(MenuAction.RUNELITE_OVERLAY).setParam0(index);
        if (!isRealItem) {
            return;
        }
    }

    private void addEntry(String menuTarget, String menuOption) {
        this.client.createMenuEntry(-2).setOption(menuOption).setTarget(ColorUtil.wrapWithColorTag((String)menuTarget, (Color)itemTooltipColor)).setType(MenuAction.RUNELITE);
    }

    private void addFakeItemMenuEntries(MenuEntryAdded menuEntryAdded) {
        if (!menuEntryAdded.getOption().equalsIgnoreCase("cancel")) {
            return;
        }
        LayoutableThing currentLayoutableThing = this.getCurrentLayoutableThing();
        if (!this.config.showLayoutPlaceholders() || !this.hasLayoutEnabled(currentLayoutableThing)) {
            return;
        }
        Layout layout = this.getBankOrder(currentLayoutableThing);
        int index = this.getIndexForMousePosition(true);
        if (index == -1) {
            return;
        }
        int itemIdAtIndex = layout.getItemAtIndex(index);
        if (itemIdAtIndex != -1 && !this.indexToWidget.containsKey(index)) {
            boolean preventPlaceholderMenuBug = this.config.preventVanillaPlaceholderMenuBug() && this.client.getDraggedWidget() != null;
            this.client.createMenuEntry(-1).setOption(REMOVE_FROM_LAYOUT_MENU_OPTION).setType(preventPlaceholderMenuBug ? MenuAction.CC_OP : MenuAction.RUNELITE_OVERLAY).setTarget(ColorUtil.wrapWithColorTag((String)this.itemName(itemIdAtIndex), (Color)itemTooltipColor)).setParam0(index);
        }
    }

    int getIndexForMousePositionNoLowerLimit() {
        return this.getIndexForMousePosition(false, true);
    }

    int getIndexForMousePosition() {
        return this.getIndexForMousePosition(false);
    }

    int getIndexForMousePosition(boolean dontEnlargeClickbox) {
        return this.getIndexForMousePosition(dontEnlargeClickbox, false);
    }

    int getIndexForMousePosition(boolean dontEnlargeClickbox, boolean noLowerLimit) {
        Widget bankItemContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (bankItemContainer == null) {
            return -1;
        }
        Point mouseCanvasPosition = this.client.getMouseCanvasPosition();
        int mouseX = mouseCanvasPosition.getX();
        int mouseY = mouseCanvasPosition.getY();
        Rectangle bankBounds = bankItemContainer.getBounds();
        if (noLowerLimit && ((double)mouseX < bankBounds.getMinX() || (double)mouseX > bankBounds.getMaxX() || (double)mouseY < bankBounds.getMinY()) || !noLowerLimit && !bankBounds.contains(new java.awt.Point(mouseX, mouseY))) {
            return -1;
        }
        Point canvasLocation = bankItemContainer.getCanvasLocation();
        int scrollY = bankItemContainer.getScrollY();
        int row = (mouseY - canvasLocation.getY() + scrollY + 2) / 36;
        int col = (int)Math.floor((float)(mouseX - canvasLocation.getX() - 51 + 6) / 48.0f);
        int index = row * 8 + col;
        if (row < 0 || col < 0 || col > 7 || index < 0) {
            return -1;
        }
        if (dontEnlargeClickbox) {
            int xDistanceIntoItem = (mouseX - canvasLocation.getX() - 51 + 6) % 48;
            int yDistanceIntoItem = (mouseY - canvasLocation.getY() + scrollY + 2) % 36;
            if (xDistanceIntoItem < 6 || xDistanceIntoItem >= 42 || yDistanceIntoItem < 2 || yDistanceIntoItem >= 34) {
                return -1;
            }
        }
        return index;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        Widget widget = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        if (widget == null || widget.isHidden()) {
            return;
        }
        if (this.config.preventVanillaPlaceholderMenuBug() && !this.client.isMenuOpen() && WidgetInfo.TO_GROUP((int)event.getParam1()) == 12 && event.getMenuOption().equals("Release")) {
            event.consume();
            return;
        }
        if (event.getMenuAction() != MenuAction.RUNELITE_OVERLAY && event.getMenuAction() != MenuAction.RUNELITE) {
            return;
        }
        String menuTarget = Text.removeTags((String)event.getMenuTarget()).replace("\u00a0", " ");
        String menuOption = event.getMenuOption();
        boolean consume = true;
        if (menuOption.startsWith(REMOVE_FROM_LAYOUT_MENU_OPTION)) {
            this.removeFromLayout(event.getParam0());
        } else if (ENABLE_LAYOUT.equals(menuOption)) {
            this.enableLayout(LayoutableThing.bankTag(menuTarget));
        } else if (DISABLE_LAYOUT.equals(menuOption)) {
            this.disableLayout(menuTarget);
        } else if (EXPORT_LAYOUT.equals(menuOption)) {
            this.exportLayout(menuTarget);
        } else if (IMPORT_LAYOUT.equals(menuOption)) {
            this.importLayout();
        } else if (PREVIEW_AUTO_LAYOUT.equals(menuOption)) {
            this.showLayoutPreview();
        } else if (DUPLICATE_ITEM.equals(menuOption)) {
            this.duplicateItem(event.getParam0());
        } else if (REMOVE_DUPLICATE_ITEM.equals(menuOption)) {
            this.removeFromLayout(event.getParam0());
        } else {
            consume = false;
        }
        if (consume) {
            event.consume();
        }
    }

    private void removeFromLayout(int index) {
        LayoutableThing layoutable = this.getCurrentLayoutableThing();
        Layout layout = this.getBankOrder(layoutable);
        layout.clearIndex(index);
        this.saveLayout(layoutable, layout);
        this.applyCustomBankTagItemPositions();
    }

    @VisibleForTesting
    void duplicateItem(int clickedItemIndex) {
        LayoutableThing layoutable = this.getCurrentLayoutableThing();
        Layout layout = this.getBankOrder(layoutable);
        layout.duplicateItem(clickedItemIndex, this.getIdForIndexInRealBank(clickedItemIndex));
        this.saveLayout(layoutable, layout);
        this.applyCustomBankTagItemPositions();
    }

    private void cleanItemsNotInBankTag(Layout layout, LayoutableThing layoutable) {
        Predicate<Integer> containsId;
        if (layoutable.isBankTab()) {
            containsId = id -> this.copyPaste.findTag((int)id, layoutable.name);
        } else {
            InventorySetup inventorySetup = this.inventorySetupsAdapter.getInventorySetup(layoutable.name);
            containsId = id -> this.inventorySetupsAdapter.setupContainsItem(inventorySetup, (int)id);
        }
        Iterator<Map.Entry<Integer, Integer>> iter = layout.allPairsIterator();
        while (iter.hasNext()) {
            int itemId = iter.next().getValue();
            if (containsId.test(itemId)) continue;
            log.debug("removing " + this.itemNameWithId(itemId) + " because it is no longer in the thing");
            iter.remove();
        }
    }

    private void assignVariantItemPositions(Layout layout, List<Widget> bankItems, Map<Integer, Widget> indexToWidget) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        bankItems = new ArrayList<Widget>(bankItems.stream().filter(widget -> seen.add(widget.getItemId())).collect(Collectors.toList()));
        LinkedListMultimap variantItemsInBank = LinkedListMultimap.create();
        for (Widget bankItem : bankItems) {
            int nonPlaceholderId = this.getNonPlaceholderId(bankItem.getItemId());
            if (!this.itemShouldBeTreatedAsHavingVariants(nonPlaceholderId)) continue;
            int variationBaseId = this.getVariationBaseId(nonPlaceholderId);
            variantItemsInBank.put((Object)variationBaseId, (Object)bankItem);
        }
        LinkedListMultimap variantItemsInLayout = LinkedListMultimap.create();
        for (Map.Entry<Integer, Integer> pair : layout.allPairs()) {
            int nonPlaceholderId = this.getNonPlaceholderId(pair.getValue());
            if (!this.itemShouldBeTreatedAsHavingVariants(nonPlaceholderId)) continue;
            int variationBaseId = this.getVariationBaseId(nonPlaceholderId);
            variantItemsInLayout.put((Object)variationBaseId, (Object)pair.getValue());
        }
        for (Integer variationBaseId : variantItemsInBank.keySet()) {
            ArrayList<Widget> notYetPositionedWidgets = new ArrayList<Widget>(variantItemsInBank.get((Object)variationBaseId));
            this.assignitemstrashname(indexToWidget, (Multimap<Integer, Integer>)variantItemsInLayout, variationBaseId, notYetPositionedWidgets, (itemIdsInLayoutForVariant, itemId) -> itemIdsInLayoutForVariant.contains(itemId) ? layout.getIndexForItem(itemId) : -1, "pass 1 (exact itemid match)");
            this.assignitemstrashname(indexToWidget, (Multimap<Integer, Integer>)variantItemsInLayout, variationBaseId, notYetPositionedWidgets, (itemIdsInLayoutForVariant, itemId) -> itemIdsInLayoutForVariant.contains(itemId = this.switchPlaceholderId(itemId)) ? layout.getIndexForItem(itemId) : -1, "pass 2 (placeholder match)");
            this.assignitemstrashname(indexToWidget, (Multimap<Integer, Integer>)variantItemsInLayout, variationBaseId, notYetPositionedWidgets, (itemIdsInLayoutForVariant, itemId) -> {
                for (Integer id : itemIdsInLayoutForVariant) {
                    int index = layout.getIndexForItem(id);
                    if (indexToWidget.containsKey(index)) continue;
                    return index;
                }
                return -1;
            }, "pass 3 (variant item match)");
            if (notYetPositionedWidgets.isEmpty()) continue;
            for (Widget notYetPositionedWidget : notYetPositionedWidgets) {
                int itemId2 = notYetPositionedWidget.getItemId();
                int layoutIndex = layout.getIndexForItem(itemId2);
                if (layoutIndex != -1) continue;
                int index = layout.getFirstEmptyIndex();
                layout.putItem(itemId2, index);
                log.debug("item " + this.itemNameWithId(itemId2) + " assigned on pass 4 (assign to empty spot) to index " + index);
                indexToWidget.put(index, notYetPositionedWidget);
            }
        }
    }

    private int getVariationBaseId(int nonPlaceholderId) {
        int runeliteBaseId = ItemVariationMapping.map((int)nonPlaceholderId);
        if (runeliteBaseId == 713) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(nonPlaceholderId);
            int iconId = itemComposition.getInventoryModel();
            if (iconId == 37162) {
                return nonPlaceholderId;
            }
            if (iconId == 37202) {
                return 2677;
            }
            if (iconId == 37152) {
                return 2801;
            }
            if (iconId == 37181) {
                return 2722;
            }
            if (iconId == 37167) {
                return 12073;
            }
            if (iconId == 37183) {
                return nonPlaceholderId;
            }
        }
        return runeliteBaseId;
    }

    private void assignitemstrashname(Map<Integer, Widget> indexToWidget, Multimap<Integer, Integer> variantItemsInLayout, Integer variationBaseId, List<Widget> notYetPositionedWidgets, functionalinterfacetrashname getIndex, String debugDescription) {
        Iterator<Widget> iter = notYetPositionedWidgets.iterator();
        while (iter.hasNext()) {
            int index;
            Widget widget = iter.next();
            int itemId = widget.getItemId();
            Collection itemIds = variantItemsInLayout.get((Object)variationBaseId);
            if (itemIds == null || (index = getIndex.getIndex(itemIds, itemId)) == -1 || indexToWidget.containsKey(index)) continue;
            log.debug("item " + this.itemNameWithId(itemId) + " assigned on " + debugDescription + " to index " + index);
            indexToWidget.put(index, widget);
            iter.remove();
        }
    }

    private boolean itemHasVariants(int nonPlaceholderItemId) {
        return ItemVariationMapping.getVariations((int)ItemVariationMapping.map((int)nonPlaceholderItemId)).size() > 1;
    }

    boolean itemShouldBeTreatedAsHavingVariants(int nonPlaceholderItemId) {
        return this.itemHasVariants(nonPlaceholderItemId);
    }

    Layout getBankOrder(LayoutableThing layoutable) {
        if (this.isShowingPreview()) {
            return this.previewLayout;
        }
        return this.getBankOrderNonPreview(layoutable);
    }

    private Layout getBankOrderNonPreview(LayoutableThing layoutable) {
        String configuration = this.configManager.getConfiguration(CONFIG_GROUP, layoutable.configKey());
        if (LAYOUT_EXPLICITLY_DISABLED.equals(configuration)) {
            return null;
        }
        if (configuration == null) {
            if (layoutable.isBankTab() && !this.config.layoutEnabledByDefault() || layoutable.isInventorySetup() && !this.config.useWithInventorySetups()) {
                return null;
            }
            if (layoutable.isInventorySetup()) {
                InventorySetup inventorySetup = this.inventorySetupsAdapter.getInventorySetup(layoutable.name);
                return this.layoutGenerator.basicInventorySetupsLayout(inventorySetup, Layout.emptyLayout(), this.getAutoLayoutDuplicateLimit(), this.config.autoLayoutStyle(), this.config.autoLayoutIncludeRunePouchRunes());
            }
            configuration = "";
        }
        return Layout.fromString(configuration, true);
    }

    private void exportLayout(String tagName) {
        String exportString = BANK_TAG_STRING_PREFIX + tagName;
        String layout = this.getBankOrder(LayoutableThing.bankTag(tagName)).toString();
        if (!layout.isEmpty()) {
            exportString = exportString + ",";
        }
        exportString = exportString + layout;
        List tabNames = Text.fromCSV((String)((String)MoreObjects.firstNonNull((Object)this.configManager.getConfiguration("banktags", "tagtabs"), (Object)"")));
        if (!tabNames.contains(tagName)) {
            this.chatErrorMessage("Couldn't export layout-ed tag tab - tag tab doesn't see to exist?");
        }
        ArrayList<String> data = new ArrayList<String>();
        data.add(tagName);
        String tagTabIconItemId = this.configManager.getConfiguration("banktags", "icon_" + tagName);
        if (tagTabIconItemId == null) {
            tagTabIconItemId = "952";
        }
        data.add(tagTabIconItemId);
        for (Integer item : this.tagManager.getItemsForTag(tagName)) {
            data.add(String.valueOf(item));
        }
        exportString = exportString + ",banktag:" + Text.toCSV(data);
        this.putInClipboard(exportString);
        this.chatMessage("Copied layout-ed tag \"" + tagName + "\" to clipboard");
    }

    private void putInClipboard(String exportString) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(exportString), null);
    }

    private MessageNode chatErrorMessage(String message) {
        return this.chatMessage(ColorUtil.wrapWithColorTag((String)message, (Color)Color.RED));
    }

    private MessageNode chatErrorMessage(String redMessage, String regularMessage) {
        return this.chatMessage(ColorUtil.wrapWithColorTag((String)redMessage, (Color)Color.RED) + regularMessage);
    }

    private MessageNode chatMessage(String message) {
        return this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "bla", message, "bla");
    }

    static int getXForIndex(int index) {
        return index % 8 * 48 + 51;
    }

    static int getYForIndex(int index) {
        return index / 8 * 36;
    }

    private void setItemPositions(Map<Integer, Widget> indexToWidget) {
        Widget container = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        block0: for (Widget child : container.getDynamicChildren()) {
            if (child.isHidden()) continue;
            for (Map.Entry<Integer, Widget> integerWidgetEntry : indexToWidget.entrySet()) {
                if (!integerWidgetEntry.getValue().equals(child)) continue;
                continue block0;
            }
            child.setHidden(true);
            child.revalidate();
        }
        for (Map.Entry entry : indexToWidget.entrySet()) {
            Widget widget = (Widget)entry.getValue();
            int index = (Integer)entry.getKey();
            widget.setOriginalX(BankTagLayoutsPlugin.getXForIndex(index));
            widget.setOriginalY(BankTagLayoutsPlugin.getYForIndex(index));
            widget.revalidate();
        }
    }

    private void resizeBankContainerScrollbar(int height, int lastHeight) {
        Widget container = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        container.setScrollHeight(height);
        int itemContainerScroll = height > lastHeight ? height : container.getScrollY();
        this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{72, WidgetInfo.BANK_SCROLLBAR.getId(), WidgetInfo.BANK_ITEM_CONTAINER.getId(), itemContainerScroll}));
    }

    public String itemName(Integer itemId) {
        return itemId == null ? "null" : this.itemManager.getItemComposition(itemId.intValue()).getName();
    }

    public String itemNameWithId(Integer itemId) {
        return (itemId == null ? "null" : this.itemManager.getItemComposition(itemId.intValue()).getName()) + " (" + itemId + ")";
    }

    private int getPlaceholderId(int id) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        return itemComposition.getPlaceholderTemplateId() == 14401 ? id : itemComposition.getPlaceholderId();
    }

    int getNonPlaceholderId(int id) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        return itemComposition.getPlaceholderTemplateId() == 14401 ? itemComposition.getPlaceholderId() : id;
    }

    int switchPlaceholderId(int id) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        return itemComposition.getPlaceholderId();
    }

    public boolean isPlaceholder(int id) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        return itemComposition.getPlaceholderTemplateId() == 14401;
    }

    private void customBankTagOrderInsert(LayoutableThing layoutable, Widget draggedItem) {
        int draggedOnItemIndex = this.getIndexForMousePositionNoLowerLimit();
        if (draggedOnItemIndex == -1) {
            return;
        }
        int draggedItemIndex = -1;
        for (Map.Entry<Integer, Widget> entry : this.indexToWidget.entrySet()) {
            if (!entry.getValue().equals(draggedItem)) continue;
            draggedItemIndex = entry.getKey();
        }
        this.customBankTagOrderInsert(layoutable, draggedItemIndex, draggedOnItemIndex);
    }

    private void customBankTagOrderInsert(LayoutableThing layoutable, int draggedItemIndex, int draggedOnItemIndex) {
        Layout layout = this.getBankOrder(layoutable);
        if (layout == null) {
            return;
        }
        Integer currentDraggedItemId = this.getIdForIndexInRealBank(draggedItemIndex);
        layout.moveItem(draggedItemIndex, draggedOnItemIndex, currentDraggedItemId);
        this.saveLayout(layoutable, layout);
        this.applyCustomBankTagItemPositions();
    }

    private Integer getIdForIndexInRealBank(int index) {
        if (index == -1) {
            return -1;
        }
        Widget widget = this.indexToWidget.get(index);
        if (widget == null) {
            return -1;
        }
        return widget.getItemId();
    }

    @Subscribe(priority=-1.0f)
    public void onDraggingWidgetChanged(DraggingWidgetChanged event) {
        Widget widget = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        if (widget == null || widget.isHidden()) {
            return;
        }
        Widget draggedWidget = this.client.getDraggedWidget();
        if (draggedWidget.getId() == WidgetInfo.BANK_ITEM_CONTAINER.getId() && this.hasLayoutEnabled(this.getCurrentLayoutableThing())) {
            this.client.setDraggedOnWidget(null);
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        this.antiDrag.focusChanged(focusChanged);
    }

    @Subscribe
    public void onMenuShouldLeftClick(MenuShouldLeftClick event) {
        MenuEntry[] menuEntries;
        Widget widget = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        if (widget == null || widget.isHidden()) {
            return;
        }
        for (MenuEntry entry : menuEntries = this.client.getMenuEntries()) {
            if (!entry.getOption().equals(PREVIEW_AUTO_LAYOUT) || entry.getType() == MenuAction.RUNELITE) continue;
            event.setForceRightClick(true);
            return;
        }
    }

    static final class LayoutableThing {
        public final String name;
        public final boolean isBankTab;

        public static LayoutableThing bankTag(String tagName) {
            return new LayoutableThing(tagName, true);
        }

        public static LayoutableThing inventorySetup(String inventorySetupName) {
            return new LayoutableThing(inventorySetupName, false);
        }

        public String toString() {
            return this.name + " " + (this.isBankTab ? "(bank tab)" : "(inventory setup)");
        }

        public String configKey() {
            if (this.isBankTab) {
                return BankTagLayoutsPlugin.LAYOUT_CONFIG_KEY_PREFIX + this.name;
            }
            return BankTagLayoutsPlugin.INVENTORY_SETUPS_LAYOUT_CONFIG_KEY_PREFIX + LayoutableThing.escapeColonCharactersInInventorySetupName(this.name);
        }

        static String escapeColonCharactersInInventorySetupName(String s) {
            return s.replaceAll("&", "&amp;").replaceAll(":", "&#58;");
        }

        public boolean isBankTab() {
            return this.isBankTab;
        }

        public boolean isInventorySetup() {
            return !this.isBankTab;
        }

        public LayoutableThing(String name, boolean isBankTab) {
            this.name = name;
            this.isBankTab = isBankTab;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LayoutableThing)) {
                return false;
            }
            LayoutableThing other = (LayoutableThing)o;
            String this$name = this.name;
            String other$name = other.name;
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.isBankTab() == other.isBankTab();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + (this.isBankTab() ? 79 : 97);
            return result;
        }
    }

    @FunctionalInterface
    private static interface functionalinterfacetrashname {
        public int getIndex(Collection<Integer> var1, int var2);
    }

    public static class FakeItem {
        public final int index;
        public final int itemId;
        public final boolean layoutPlaceholder;
        public final int quantity;

        public FakeItem(int index, int itemId, boolean layoutPlaceholder, int quantity) {
            this.index = index;
            this.itemId = itemId;
            this.layoutPlaceholder = layoutPlaceholder;
            this.quantity = quantity;
        }

        public int getIndex() {
            return this.index;
        }

        public int getItemId() {
            return this.itemId;
        }

        public boolean isLayoutPlaceholder() {
            return this.layoutPlaceholder;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FakeItem)) {
                return false;
            }
            FakeItem other = (FakeItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            if (this.getItemId() != other.getItemId()) {
                return false;
            }
            if (this.isLayoutPlaceholder() != other.isLayoutPlaceholder()) {
                return false;
            }
            return this.getQuantity() == other.getQuantity();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FakeItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            result = result * 59 + this.getItemId();
            result = result * 59 + (this.isLayoutPlaceholder() ? 79 : 97);
            result = result * 59 + this.getQuantity();
            return result;
        }

        public String toString() {
            return "BankTagLayoutsPlugin.FakeItem(index=" + this.getIndex() + ", itemId=" + this.getItemId() + ", layoutPlaceholder=" + this.isLayoutPlaceholder() + ", quantity=" + this.getQuantity() + ")";
        }
    }
}

