/*
 * Decompiled with CFR 0.152.
 */
package com.banktaglayouts;

import com.banktaglayouts.BankTagLayoutsPlugin;
import java.awt.event.KeyEvent;
import net.runelite.api.events.FocusChanged;
import net.runelite.client.input.KeyListener;

public class AntiDragPluginUtil
implements KeyListener {
    private final BankTagLayoutsPlugin plugin;
    private boolean ctrlDown = false;
    private boolean shiftDown = false;
    private boolean earlyAllowDrag = false;
    private long dragStart = -1L;

    public boolean isAntiDragPluginEnabled() {
        return Boolean.parseBoolean(this.plugin.configManager.getConfiguration("runelite", "antidragplugin"));
    }

    public int getDragDelay() {
        int dragDelay;
        try {
            dragDelay = Integer.parseInt(this.plugin.configManager.getConfiguration("antiDrag", "dragDelay"));
        }
        catch (NumberFormatException e) {
            return 30;
        }
        return dragDelay;
    }

    public boolean disableOnCtrl() {
        return Boolean.parseBoolean(this.plugin.configManager.getConfiguration("antiDrag", "disableOnCtrl"));
    }

    public boolean onShiftOnly() {
        String configuration = this.plugin.configManager.getConfiguration("antiDrag", "onShiftOnly");
        if (configuration == null) {
            return true;
        }
        return Boolean.parseBoolean(configuration);
    }

    public int getCurrentDragDelay() {
        if (!this.isAntiDragPluginEnabled()) {
            return 5;
        }
        if (this.onShiftOnly()) {
            return this.shiftDown ? this.getDragDelay() : 5;
        }
        if (this.disableOnCtrl() && this.ctrlDown) {
            return 5;
        }
        return this.getDragDelay();
    }

    public boolean mayDrag() {
        if (this.dragStart == -1L) {
            return true;
        }
        if (this.earlyAllowDrag) {
            return true;
        }
        return System.currentTimeMillis() - this.dragStart > (long)(this.getCurrentDragDelay() * 20);
    }

    public void startDrag() {
        this.dragStart = System.currentTimeMillis();
        this.earlyAllowDrag = false;
    }

    public void endDrag() {
        this.dragStart = -1L;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.ctrlDown = true;
            this.earlyAllowDrag = true;
        } else if (e.getKeyCode() == 16) {
            this.shiftDown = true;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.ctrlDown = false;
        } else if (e.getKeyCode() == 16) {
            this.shiftDown = false;
        }
    }

    public void focusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.ctrlDown = false;
            this.shiftDown = false;
        }
    }

    public AntiDragPluginUtil(BankTagLayoutsPlugin plugin) {
        this.plugin = plugin;
    }
}

