/*
 * Decompiled with CFR 0.152.
 */
package com.smartchatinputcolor;

import com.google.inject.Provides;
import com.smartchatinputcolor.ChatChannel;
import com.smartchatinputcolor.ChatPanel;
import com.smartchatinputcolor.SmartChatInputColorPluginConfig;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.FriendsChatChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Smart Chat Input Color")
public class SmartChatInputColorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SmartChatInputColorPlugin.class);
    private static final int OPEN_CHAT_PANEL = 41;
    @Inject
    private Client client;
    @Inject
    private SmartChatInputColorPluginConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ClientThread clientThread;
    private ChatPanel selectedChatPanel;
    private ChatChannel friendsChatChannel;
    private boolean hoppingWorlds;
    private boolean shouldInitialize;
    private boolean slashSwapperBug;
    private final Map<ChatChannel, Color> channelColorMap = new HashMap<ChatChannel, Color>();

    protected void startUp() {
        log.debug("Smart Chat Input Color starting!");
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.shouldInitialize = true;
        }
    }

    protected void shutDown() {
        log.debug("Smart Chat Input Color stopping!");
        this.selectedChatPanel = null;
        this.friendsChatChannel = null;
        this.channelColorMap.clear();
    }

    @Provides
    SmartChatInputColorPluginConfig provideConfig(ConfigManager configManager) {
        return (SmartChatInputColorPluginConfig)configManager.getConfig(SmartChatInputColorPluginConfig.class);
    }

    private void recolorChatTypedText() {
        Widget inputWidget = this.client.getWidget(10616887);
        if (inputWidget == null) {
            return;
        }
        String input = inputWidget.getText();
        if (input.endsWith("Press Enter to Chat...")) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        String name = input.contains(":") ? input.split(":")[0] : player.getName();
        String text = this.client.getVarcStrValue(335);
        inputWidget.setText(name + ": " + ColorUtil.wrapWithColorTag((String)(Text.escapeJagex((String)text) + "*"), (Color)this.channelColorMap.get((Object)this.deriveChatChannel(name, text))));
    }

    private ChatChannel deriveChatChannel(String name, String text) {
        ChatChannel channel = this.findChannelByMessagePrefix(text);
        if (channel != null) {
            return channel;
        }
        if (name.contains("(")) {
            switch (name.split("\\(")[1].replace(")", "")) {
                case "channel": {
                    return this.friendsChatChannel;
                }
                case "clan": {
                    return ChatChannel.CLAN;
                }
                case "guest clan": {
                    return ChatChannel.GUEST;
                }
                case "group": {
                    return ChatChannel.GIM;
                }
            }
        }
        return this.getSelectedChatPanelChannel();
    }

    private ChatChannel findChannelByMessagePrefix(String text) {
        for (ChatChannel channel : ChatChannel.values()) {
            if (!channel.matchesPrefixRegex(text)) continue;
            return this.getResultingChannel(channel, text);
        }
        ChatChannel channel = ChatChannel.getBySlashPrefix(text);
        return this.getResultingChannel(this.slashSwapperBug && channel == ChatChannel.GUEST ? ChatChannel.FRIEND : channel, text);
    }

    private Color computeChannelColor(ChatChannel channel, boolean transparent) {
        Color color;
        String colorConfigKey = channel.getColorConfigKey();
        if (colorConfigKey != null && (color = (Color)this.configManager.getConfiguration("textrecolor", (transparent ? "transparent" : "opaque") + colorConfigKey, Color.class)) != null) {
            return color;
        }
        int colorCode = this.client.getVarpValue(transparent ? channel.getTransparentVarpId() : channel.getOpaqueVarpId()) - 1;
        if (colorCode == 0) {
            return Color.BLACK;
        }
        if (colorCode == -1) {
            return new Color(transparent ? channel.getTransparentDefaultRgb() : channel.getOpaqueDefaultRgb());
        }
        return new Color(colorCode);
    }

    private void populateChatChannelColorMap() {
        boolean transparent = this.client.isResized() && this.client.getVarbitValue(4608) == 1;
        for (ChatChannel c : ChatChannel.values()) {
            this.channelColorMap.put(c, this.computeChannelColor(c, transparent));
        }
    }

    private void setFriendsChatChannel(boolean isInFriendsChat) {
        this.friendsChatChannel = isInFriendsChat ? ChatChannel.FRIEND : ChatChannel.PUBLIC;
    }

    private void setOpenChatPanel() {
        this.selectedChatPanel = ChatPanel.fromInt(this.client.getVarcIntValue(41));
    }

    private ChatChannel getResultingChannel(ChatChannel channel) {
        if (channel == null) {
            return null;
        }
        return channel == ChatChannel.FRIEND ? this.friendsChatChannel : channel;
    }

    private ChatChannel getResultingChannel(ChatChannel channel, String text) {
        if (channel == null) {
            return null;
        }
        switch (channel) {
            case FRIEND: {
                return this.friendsChatChannel;
            }
            case GIM: {
                return this.getGIMChatChannel(text);
            }
        }
        return channel;
    }

    private ChatChannel getGIMChatChannel(String text) {
        switch (this.client.getVarbitValue(1777)) {
            case 4: 
            case 5: 
            case 6: {
                return ChatChannel.GIM;
            }
        }
        if (text.startsWith("/g")) {
            return this.getResultingChannel(ChatChannel.getBySlashCount(1));
        }
        if (text.startsWith("/@g")) {
            return ChatChannel.CLAN;
        }
        if (text.startsWith("////")) {
            return this.getResultingChannel(ChatChannel.getBySlashCount(3));
        }
        return ChatChannel.GIM;
    }

    private ChatChannel getSelectedChatPanelChannel() {
        switch (this.selectedChatPanel) {
            case CHANNEL: {
                return this.friendsChatChannel;
            }
            case CLAN: {
                return ChatChannel.CLAN;
            }
        }
        return ChatChannel.PUBLIC;
    }

    private boolean getSlashSwapperGuestChatConfig() {
        return (Boolean)this.configManager.getConfiguration("slashswapper", "slashGuestChat", Boolean.TYPE);
    }

    private void configureSlashPrefixes() {
        Optional<Plugin> maybeSlashSwapper = this.pluginManager.getPlugins().stream().filter(p -> p.getName().equals("Slash Swapper") && this.pluginManager.isPluginEnabled(p)).findFirst();
        if (maybeSlashSwapper.isEmpty()) {
            this.slashSwapperBug = false;
            ChatChannel.useDefaultSlashPrefixes();
            return;
        }
        boolean guestChatConfig = this.getSlashSwapperGuestChatConfig();
        this.slashSwapperBug = !guestChatConfig && this.config.slashSwapperBug();
        ChatChannel.useSlashSwapperPrefixes(guestChatConfig);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 223) {
            this.recolorChatTypedText();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case HOPPING: {
                this.hoppingWorlds = true;
                break;
            }
            case LOGGED_IN: {
                if (this.hoppingWorlds) {
                    this.hoppingWorlds = false;
                    return;
                }
                this.shouldInitialize = true;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick ignored) {
        if (!this.shouldInitialize) {
            return;
        }
        this.setOpenChatPanel();
        this.setFriendsChatChannel(this.client.getFriendsChatManager() != null);
        this.configureSlashPrefixes();
        this.populateChatChannelColorMap();
        this.shouldInitialize = false;
        this.recolorChatTypedText();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        String configGroup = configChanged.getGroup();
        if (configGroup.equals("smartchatinputcolor") || configGroup.equals("slashswapper")) {
            this.clientThread.invoke(() -> {
                this.configureSlashPrefixes();
                this.recolorChatTypedText();
            });
        }
        if (configGroup.equals("textrecolor")) {
            this.clientThread.invoke(() -> {
                this.populateChatChannelColorMap();
                this.recolorChatTypedText();
            });
        }
    }

    @Subscribe
    public void onPluginChanged(PluginChanged pluginChanged) {
        Plugin plugin = pluginChanged.getPlugin();
        if (!plugin.getName().equals("Slash Swapper")) {
            return;
        }
        if (this.pluginManager.isPluginEnabled(plugin)) {
            ChatChannel.useSlashSwapperPrefixes(this.getSlashSwapperGuestChatConfig());
        } else {
            ChatChannel.useDefaultSlashPrefixes();
        }
        this.recolorChatTypedText();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int varPlayerId = varbitChanged.getVarpId();
        for (ChatChannel channel : ChatChannel.values()) {
            if (varPlayerId != channel.getOpaqueVarpId() && varPlayerId != channel.getTransparentVarpId()) continue;
            this.populateChatChannelColorMap();
            return;
        }
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        if (varClientIntChanged.getIndex() == 41) {
            this.setOpenChatPanel();
        }
    }

    @Subscribe
    public void onFriendsChatChanged(FriendsChatChanged friendsChatChanged) {
        this.setFriendsChatChannel(friendsChatChanged.isJoined());
        this.recolorChatTypedText();
    }
}

