/*
 * Decompiled with CFR 0.152.
 */
package com.smartchatinputcolor;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

enum ChatChannel {
    PUBLIC("PublicChat", 3000, 2992, 0x9090FF, 255, Pattern.compile("^/(@p|p ).*"), 0),
    FRIEND("ClanChatMessage", 3004, 2996, 15683664, 0x7F0000, Pattern.compile("^/(@?f).*"), 1),
    CLAN("ClanMessage", 3005, 2997, 0x7F0000, 0x7F0000, Pattern.compile("^/(@c|c ).*"), 2),
    GUEST("ClanGuestMessage", 3061, 3060, 0x7F0000, 0x7F0000, Pattern.compile("^/(@gc|gc ).*"), 3),
    GIM(null, 3194, 3191, 0x7F0000, 0x7F0000, Pattern.compile("^/(@g[^c]|g ).*"), 4);

    private final String colorConfigKey;
    private final int transparentVarpId;
    private final int opaqueVarpId;
    private final int transparentDefaultRgb;
    private final int opaqueDefaultRgb;
    private final Pattern prefixRegex;
    private final int defaultSlashPrefixCount;
    private static final Map<Integer, ChatChannel> slashPrefixMap;

    public static void useDefaultSlashPrefixes() {
        slashPrefixMap.clear();
        for (ChatChannel channel : ChatChannel.values()) {
            slashPrefixMap.put(channel.defaultSlashPrefixCount, channel);
        }
        slashPrefixMap.remove(ChatChannel.PUBLIC.defaultSlashPrefixCount);
    }

    public static void useSlashSwapperPrefixes(boolean guestChatConfig) {
        slashPrefixMap.clear();
        slashPrefixMap.put(2, FRIEND);
        slashPrefixMap.put(4, GIM);
        if (guestChatConfig) {
            slashPrefixMap.put(3, CLAN);
            slashPrefixMap.put(1, GUEST);
            return;
        }
        slashPrefixMap.put(1, CLAN);
        slashPrefixMap.put(3, GUEST);
    }

    @Nullable
    public static ChatChannel getBySlashPrefix(String text) {
        int slashCount;
        for (slashCount = 0; slashCount < text.length() && text.charAt(slashCount) == '/'; ++slashCount) {
        }
        return slashPrefixMap.get(Math.min(slashCount, 4));
    }

    @Nullable
    public static ChatChannel getBySlashCount(int count) {
        return slashPrefixMap.get(count);
    }

    public boolean matchesPrefixRegex(String text) {
        return this.prefixRegex.matcher(text).matches();
    }

    private ChatChannel(String colorConfigKey, int transparentVarpId, int opaqueVarpId, int transparentDefaultRgb, int opaqueDefaultRgb, Pattern prefixRegex, int defaultSlashPrefixCount) {
        this.colorConfigKey = colorConfigKey;
        this.transparentVarpId = transparentVarpId;
        this.opaqueVarpId = opaqueVarpId;
        this.transparentDefaultRgb = transparentDefaultRgb;
        this.opaqueDefaultRgb = opaqueDefaultRgb;
        this.prefixRegex = prefixRegex;
        this.defaultSlashPrefixCount = defaultSlashPrefixCount;
    }

    public String getColorConfigKey() {
        return this.colorConfigKey;
    }

    public int getTransparentVarpId() {
        return this.transparentVarpId;
    }

    public int getOpaqueVarpId() {
        return this.opaqueVarpId;
    }

    public int getTransparentDefaultRgb() {
        return this.transparentDefaultRgb;
    }

    public int getOpaqueDefaultRgb() {
        return this.opaqueDefaultRgb;
    }

    static {
        slashPrefixMap = new HashMap<Integer, ChatChannel>();
    }
}

