/*
 * Decompiled with CFR 0.152.
 */
package com.rlweather;

import com.google.gson.Gson;
import com.rlweather.WeatherModel;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.client.RuneLite;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherAPI {
    private static final Logger log = LoggerFactory.getLogger(WeatherAPI.class);
    private final int MAX_STALENESS = 360;
    private String location = "";
    private String apiKey = "";
    private ChatMessageManager chatMessageManager;
    private int staleness = 360;
    private boolean isSnowing = false;
    private boolean isRaining = false;
    private boolean isThundering = false;
    private Optional<Boolean> isHealthy = Optional.empty();
    private OkHttpClient okHttpClient;
    private Gson gson;

    @Inject
    private WeatherAPI(OkHttpClient okHttpClient, Gson gson) {
        this.okHttpClient = okHttpClient;
        this.gson = gson;
        log.debug("Weather API starting");
    }

    public void zeroStaleness() {
        this.staleness = 460;
        this.sendMessage("Weather location config change detected, refreshing..");
    }

    public void setLocation(String location) {
        if (!this.location.equals(location)) {
            this.location = location;
            this.isHealthy = Optional.empty();
        }
    }

    public void setApiKey(String apiKey) {
        if (!this.apiKey.equals(apiKey)) {
            this.apiKey = apiKey;
            this.isHealthy = Optional.empty();
        }
    }

    public void setChatMessageManager(ChatMessageManager chatMessageManager) {
        this.chatMessageManager = chatMessageManager;
    }

    private void sendMessage(String chat) {
        String message = new ChatMessageBuilder().append(chat).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    public void update() {
        if (this.location.equals("") || this.apiKey.equals("")) {
            return;
        }
        if (this.staleness > 360) {
            log.debug("Weather data stale, refreshing from API");
            HttpUrl httpUrl = new HttpUrl.Builder().scheme("https").host("api.openweathermap.org").addPathSegment("data").addPathSegment("2.5").addPathSegment("weather").addQueryParameter("q", this.location).addQueryParameter("units", "metric").addQueryParameter("cnt", "10").build();
            Request getRequest = new Request.Builder().url(httpUrl).header("User-Agent", RuneLite.USER_AGENT + " (rl-weather").header("x-api-key", this.apiKey).build();
            this.okHttpClient.newCall(getRequest).enqueue(new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(Call call, Response response) throws IOException {
                    log.info(call.toString(), (Object)response.body().toString());
                    if (response.isSuccessful()) {
                        if (response.body() != null) {
                            WeatherModel weatherModel = (WeatherModel)WeatherAPI.this.gson.fromJson(response.body().string(), WeatherModel.class);
                            WeatherAPI.this.isRaining = weatherModel.getWeather().isRainingFromID();
                            WeatherAPI.this.isSnowing = weatherModel.getWeather().isSnowingFromID();
                            WeatherAPI.this.isThundering = weatherModel.getWeather().isThunderingFromID();
                            if (!WeatherAPI.this.isHealthy.orElse(false).booleanValue()) {
                                WeatherAPI.this.sendMessage("Now connected to weather in " + WeatherAPI.this.location);
                            }
                            WeatherAPI.this.isHealthy = Optional.of(true);
                            log.debug("Updated weather --\nisRaining: " + WeatherAPI.this.isRaining() + "\nisSnowing: " + WeatherAPI.this.isSnowing() + "\nisThundering: " + WeatherAPI.this.isThundering() + "\n");
                        } else {
                            log.error("Empty body response: " + response.code());
                        }
                    } else {
                        log.error("Responded with error code: " + response.code());
                        String error = "";
                        try {
                            error = response.body().string();
                            log.error(error);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            log.error("Disabling weather statuses due to broken API request");
                            WeatherAPI.this.isRaining = false;
                            WeatherAPI.this.isSnowing = false;
                            WeatherAPI.this.isThundering = false;
                            if (WeatherAPI.this.isHealthy.orElse(true).booleanValue()) {
                                WeatherAPI.this.sendMessage("Could not load weather data with given API key and/or location " + WeatherAPI.this.location);
                                WeatherAPI.this.sendMessage(error);
                                log.debug("API health dropped, sent message to console.");
                            } else {
                                log.debug("API has not been healthy, won't notify.");
                            }
                            WeatherAPI.this.isHealthy = Optional.of(false);
                        }
                    }
                    response.close();
                }

                public void onFailure(Call call, IOException e) {
                    log.error("Error in call" + call.toString());
                    log.error(e.toString());
                    e.printStackTrace();
                }
            });
            this.staleness = 0;
        } else {
            ++this.staleness;
        }
    }

    public boolean isSnowing() {
        return this.isSnowing;
    }

    public boolean isRaining() {
        return this.isRaining;
    }

    public boolean isThundering() {
        return this.isThundering;
    }
}

