/*
 * Decompiled with CFR 0.152.
 */
package com.rlweather;

import java.util.HashMap;
import java.util.Random;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sound {
    private static final Logger log = LoggerFactory.getLogger(Sound.class);
    private final HashMap<String, Clip> clips = new HashMap();

    public void rain(String key, int volume) {
        Clip clip = this.play(key, "/normalized/177479__unfa__slowly-raining-loop-3.wav", true, volume);
        this.subscribe(key, clip);
    }

    public void thunder(String key, int volume) {
        String[] thunderSounds = new String[]{"/normalized/195344__morninggloryproductions__thunder-2.wav", "/normalized/352574__dobroide__20160816-thunder-03-2.wav", "/normalized/505113__fission9__thunder-close-2.wav"};
        int r = new Random().nextInt(thunderSounds.length);
        Clip clip = this.play(key, thunderSounds[r], false, volume);
        this.subscribe(key, clip);
    }

    public void snow(String key, int volume) {
        Clip clip = this.play(key, "/normalized/201208__rivv3t__raw-wind_edited.wav", true, volume);
        this.subscribe(key, clip);
    }

    private void subscribe(String key, Clip clip) {
        this.clips.put(key, clip);
    }

    public Clip play(String key, String soundFilePath, boolean loop, int volume) {
        Clip clip = null;
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(this.getClass().getResource(soundFilePath));
            clip = AudioSystem.getClip();
            clip.addLineListener(e -> {
                if (e.getType() == LineEvent.Type.STOP) {
                    this.clips.remove(key);
                }
            });
            clip.open(stream);
            try {
                FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                if (volume == 100) {
                    volume = 99;
                }
                float vol = (float)(10.0 * Math.log10((float)volume / 100.0f));
                gainControl.setValue(vol);
            }
            catch (IllegalArgumentException e2) {
                log.error("It seems like gain control may not be supported on your system: ", (Throwable)e2);
            }
            clip.start();
            if (loop) {
                clip.loop(-1);
            }
            return clip;
        }
        catch (Exception e3) {
            log.warn("Failed to play sound: " + soundFilePath, (Throwable)e3);
            return clip;
        }
    }

    public boolean isPlaying(String key) {
        return this.clips.containsKey(key);
    }

    public void stop(String key) {
        Clip clip = this.clips.get(key);
        try {
            clip.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAll() {
        for (String key : this.clips.keySet()) {
            this.stop(key);
        }
    }
}

