/*
 * Decompiled with CFR 0.152.
 */
package com.rlweather;

import com.google.inject.Provides;
import com.rlweather.RlweatherConfig;
import com.rlweather.RlweatherOverlay;
import com.rlweather.Sound;
import com.rlweather.WeatherAPI;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Weather")
public class RlweatherPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RlweatherPlugin.class);
    @Inject
    private Client client;
    @Inject
    private RlweatherConfig config;
    @Inject
    private RlweatherOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private WeatherAPI weatherAPI;
    public int lastLightning = 10;
    public Sound sound = new Sound();
    protected String KEY_RAIN = "rain";
    protected String KEY_THUNDER = "thunder";
    protected String KEY_SNOW = "snow";
    public boolean PLAYER_OUTSIDE = false;
    public boolean PERFORM_LIGHTNING = false;
    public boolean PERFORM_RAIN = false;
    public boolean PERFORM_SNOW = false;

    protected void startUp() throws Exception {
        log.info("Weather started!");
        this.overlayManager.add((Overlay)this.overlay);
        this.weatherAPI.setChatMessageManager(this.chatMessageManager);
    }

    protected void shutDown() throws Exception {
        log.info("Weather stopped!");
        this.sound.stopAll();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private boolean isLightningEnabled() {
        if (this.config.locationEnabled()) {
            return this.config.lightningEnabled() && this.weatherAPI.isThundering();
        }
        return this.config.lightningEnabled();
    }

    private boolean isThunderEnabled() {
        if (this.config.locationEnabled()) {
            return this.config.thunderEnabled() && this.weatherAPI.isThundering();
        }
        return this.config.thunderEnabled();
    }

    private boolean isRainEnabled() {
        if (this.config.locationEnabled()) {
            return this.config.rainEnabled() && this.weatherAPI.isRaining();
        }
        return this.config.rainEnabled();
    }

    private boolean isSnowEnabled() {
        if (this.config.locationEnabled()) {
            return this.config.snowEnabled() && this.weatherAPI.isSnowing();
        }
        return this.config.snowEnabled();
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("Weather")) {
            return;
        }
        if (event.getKey().equals("soundvolume")) {
            this.sound.stopAll();
        }
        if (!this.config.locationEnabled()) {
            return;
        }
        if (event.getKey().equals("locationenabled") || event.getKey().equals("location") || event.getKey().equals("apiKey")) {
            this.weatherAPI.setApiKey(this.config.apiKey());
            this.weatherAPI.setLocation(this.config.location());
            this.weatherAPI.zeroStaleness();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        Random r;
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        this.PLAYER_OUTSIDE = player.getWorldLocation().getY() < 4160;
        this.PERFORM_LIGHTNING = false;
        this.PERFORM_RAIN = false;
        this.PERFORM_SNOW = false;
        if (!this.PLAYER_OUTSIDE) {
            return;
        }
        if (this.config.locationEnabled()) {
            this.weatherAPI.setApiKey(this.config.apiKey());
            this.weatherAPI.setLocation(this.config.location());
            this.weatherAPI.update();
        }
        if ((this.isLightningEnabled() || this.isThunderEnabled()) && this.lastLightning <= 0 && (r = new Random()).nextInt(20) == 0) {
            if (this.isLightningEnabled()) {
                this.PERFORM_LIGHTNING = true;
            }
            this.lastLightning = this.config.lightningFrequency();
            if (this.config.soundsEnabled() && this.isThunderEnabled()) {
                this.sound.thunder(this.KEY_THUNDER, this.config.soundVolume());
            }
        }
        if (this.lastLightning > 0) {
            --this.lastLightning;
        } else if (this.lastLightning < 0) {
            this.lastLightning = 0;
        }
        if (this.isRainEnabled()) {
            this.PERFORM_RAIN = true;
            if (!this.sound.isPlaying(this.KEY_RAIN) && this.config.soundsEnabled()) {
                this.sound.rain(this.KEY_RAIN, this.config.soundVolume());
            }
        } else {
            this.sound.stop(this.KEY_RAIN);
        }
        if (this.isSnowEnabled()) {
            this.PERFORM_SNOW = true;
            if (!this.sound.isPlaying(this.KEY_SNOW) && this.config.soundsEnabled()) {
                this.sound.snow(this.KEY_SNOW, this.config.soundVolume());
            }
        } else {
            this.sound.stop(this.KEY_SNOW);
        }
        if (!this.config.soundsEnabled()) {
            this.sound.stopAll();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.LOGIN_SCREEN_AUTHENTICATOR || gameStateChanged.getGameState() == GameState.LOGGING_IN || gameStateChanged.getGameState() == GameState.HOPPING || gameStateChanged.getGameState() == GameState.CONNECTION_LOST) {
            this.sound.stopAll();
        }
    }

    @Provides
    RlweatherConfig provideConfig(ConfigManager configManager) {
        return (RlweatherConfig)configManager.getConfig(RlweatherConfig.class);
    }
}

