/*
 * Decompiled with CFR 0.152.
 */
package com.rlweather;

import com.rlweather.Drop;
import com.rlweather.RlweatherConfig;
import com.rlweather.RlweatherPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class RlweatherOverlay
extends Overlay {
    private Client client;
    private final RlweatherPlugin plugin;
    private final RlweatherConfig config;
    private final List<Drop> rain = new LinkedList<Drop>();
    private final List<Drop> snow = new LinkedList<Drop>();
    private double chanceOfSpawn = 0.8;
    private final Random r = new Random();

    @Inject
    public RlweatherOverlay(Client client, RlweatherPlugin plugin, RlweatherConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Dimension canvasDim = this.client.getRealDimensions();
        if (this.plugin.PERFORM_LIGHTNING) {
            this.plugin.PERFORM_LIGHTNING = false;
            graphics.setColor(this.config.lightningColor());
            graphics.fillRect(0, 0, canvasDim.width, canvasDim.height);
        }
        if (this.plugin.PERFORM_RAIN) {
            this.renderDrops(this.rain, canvasDim, graphics, "rain");
        }
        if (this.plugin.PERFORM_SNOW) {
            this.renderDrops(this.snow, canvasDim, graphics, "snow");
        }
        return null;
    }

    private void addDrop(List<Drop> list, int width, Color color, int wind, int gravity, int div, boolean depthEnabled) {
        list.add(new Drop(width, color, wind, gravity, div, depthEnabled));
    }

    private void renderDrops(List<Drop> drops, Dimension c, Graphics2D g, String type) {
        int length = this.config.rainLength();
        int thickness = this.config.rainThickness();
        Color color = this.config.rainColor();
        int wind = this.config.rainWind();
        int gravity = this.config.rainGravity();
        int div = this.config.rainDiv();
        if (type.equals("snow")) {
            thickness = this.config.snowThickness();
            color = this.config.snowColor();
            wind = this.config.snowWind();
            gravity = this.config.snowGravity();
            div = this.config.snowDiv();
        }
        if (Math.random() < this.chanceOfSpawn) {
            this.addDrop(drops, c.width, color, wind, gravity, div, this.config.depthEnabled());
        }
        for (Drop drop2 : drops) {
            g.setColor(drop2.color);
            if (type.equals("rain")) {
                if (this.config.depthEnabled()) {
                    drop2.depth = this.r.nextInt(9);
                    length += drop2.depth;
                }
                g.setStroke(new BasicStroke(thickness));
                g.drawLine(drop2.x2, drop2.y2, drop2.x1, drop2.y2 + length);
            }
            if (type.equals("snow")) {
                if (this.config.depthEnabled()) {
                    thickness += drop2.depth;
                }
                int radius = thickness / 2;
                g.fillOval(drop2.x1 - radius, drop2.y1 - radius, thickness, thickness);
            }
            drop2.update();
            length = this.config.rainLength();
            if (!type.equals("snow")) continue;
            thickness = this.config.snowThickness();
        }
        drops.removeIf(drop -> drop.y1 > c.height || drop.x1 > c.width || drop.y1 < 0 || drop.x1 < -c.width / 2);
    }
}

