/*
 * Decompiled with CFR 0.152.
 */
package com.bwanaian;

import com.bwanaian.ParaTodosConfig;
import com.google.inject.Provides;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="OSRS Para Todos")
public class ParaTodosPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ParaTodosPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ParaTodosConfig config;
    private HashMap<String, String> translation;

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        try {
            String eng = event.getMenuEntry().getOption();
            if (this.translation.containsKey(eng)) {
                String tran = this.translation.get(eng);
                event.getMenuEntry().setOption(event.getOption().replace(eng, tran));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) throws Exception {
        log.info("Loading new language... " + this.config.lang().getCode());
        this.loadTranslation(this.config.lang().getCode());
    }

    protected void startUp() throws Exception {
        log.info("OSRSParaTodos started!");
        this.loadTranslation(this.config.lang().getCode());
    }

    private void loadTranslation(String lang2) throws Exception {
        this.translation = new HashMap();
        String fileName = "/" + lang2 + ".csv";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName)));){
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] str = line.split(",");
                this.translation.put(str[0], str[1]);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    protected void shutDown() throws Exception {
        log.info("OSRSParaTodos stopped!");
    }

    @Provides
    ParaTodosConfig provideConfig(ConfigManager configManager) {
        return (ParaTodosConfig)configManager.getConfig(ParaTodosConfig.class);
    }
}

