/*
 * Decompiled with CFR 0.152.
 */
package com.brooklyn.annoyancemute;

import com.brooklyn.annoyancemute.AnnoyanceMuteConfig;
import com.brooklyn.annoyancemute.SoundEffect;
import com.brooklyn.annoyancemute.SoundEffectID;
import com.brooklyn.annoyancemute.SoundEffectType;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.AmbientSoundEffect;
import net.runelite.api.Client;
import net.runelite.api.Deque;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.AmbientSoundEffectCreated;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Annoyance Mute", description="Selectively mute annoying game sounds", tags={"sound", "volume", "mute", "hub", "brooklyn", "pet", "stomp"})
public class AnnoyanceMutePlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private AnnoyanceMuteConfig config;
    @VisibleForTesting
    public HashSet<SoundEffect> soundEffects = new HashSet();
    public HashSet<SoundEffect> ambientSoundsToMute = new HashSet();

    @Provides
    AnnoyanceMuteConfig provideConfig(ConfigManager configManager) {
        return (AnnoyanceMuteConfig)configManager.getConfig(AnnoyanceMuteConfig.class);
    }

    public void startUp() {
        this.setUpMutes();
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
        });
    }

    public void shutDown() {
        this.soundEffects.clear();
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
        });
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("annoyancemute")) {
            this.setUpMutes();
            switch (configChanged.getKey()) {
                case "muteMagicTrees": 
                case "muteWhiteNoise": 
                case "muteChirps": 
                case "muteWater": 
                case "muteRanges": {
                    this.clientThread.invoke(() -> {
                        if (this.client.getGameState() == GameState.LOGGED_IN) {
                            this.client.setGameState(GameState.LOADING);
                        }
                    });
                }
            }
        }
    }

    @Subscribe(priority=-2.0f)
    public void onAmbientSoundEffectCreated(AmbientSoundEffectCreated ambientSoundEffectCreated) {
        if (this.ambientSoundsToMute.isEmpty()) {
            return;
        }
        List mutedAmbientsSameID = this.ambientSoundsToMute.stream().filter(mutedSounds -> mutedSounds.id == ambientSoundEffectCreated.getAmbientSoundEffect().getSoundEffectId()).collect(Collectors.toList());
        if (mutedAmbientsSameID.size() > 0) {
            this.muteAmbientSounds();
        }
    }

    @Subscribe(priority=-2.0f)
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (this.ambientSoundsToMute.isEmpty()) {
            return;
        }
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.LOGGED_IN) {
            this.muteAmbientSounds();
        }
    }

    private void muteAmbientSounds() {
        Deque ambientSoundEffects = this.client.getAmbientSoundEffects();
        ArrayList<AmbientSoundEffect> soundsToKeep = new ArrayList<AmbientSoundEffect>();
        for (AmbientSoundEffect ambientSoundEffect : ambientSoundEffects) {
            List mutedAmbientsSameID = this.ambientSoundsToMute.stream().filter(mutedSounds -> mutedSounds.id == ambientSoundEffect.getSoundEffectId()).collect(Collectors.toList());
            boolean muteSound = false;
            for (int i = 0; i < mutedAmbientsSameID.size() && !muteSound; ++i) {
                int[] backgroundSounds = ambientSoundEffect.getBackgroundSoundEffectIds();
                int[] backgroundSoundsToMute = ((SoundEffect)mutedAmbientsSameID.get((int)i)).backGroundSoundEffect;
                if (backgroundSounds == null && backgroundSoundsToMute.length == 0) {
                    muteSound = true;
                }
                if (backgroundSounds != null && backgroundSoundsToMute.length == 0) {
                    muteSound = true;
                }
                if (backgroundSounds == null || backgroundSoundsToMute.length == 0 || !this.arraysLikeEnough(backgroundSounds, backgroundSoundsToMute)) continue;
                muteSound = true;
            }
            if (muteSound) continue;
            soundsToKeep.add(ambientSoundEffect);
        }
        this.client.getAmbientSoundEffects().clear();
        for (AmbientSoundEffect ambientSoundEffect : soundsToKeep) {
            this.client.getAmbientSoundEffects().addLast((Object)ambientSoundEffect);
        }
    }

    private boolean arraysLikeEnough(int[] array1, int[] array2) {
        int total = 0;
        int totalSimilar = 0;
        for (int int1 : array1) {
            ++total;
            for (int int2 : array2) {
                if (int1 != int2) continue;
                ++totalSimilar;
            }
        }
        return (double)totalSimilar / (double)total > 0.75;
    }

    private void setUpMutes() {
        this.soundEffects = new HashSet();
        if (this.config.muteREEEE()) {
            this.soundEffects.add(new SoundEffect(3892, SoundEffectType.EITHER));
        }
        if (this.config.muteCannon()) {
            this.soundEffects.add(new SoundEffect(2877, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2174, SoundEffectType.EITHER));
        }
        if (this.config.muteIceSpells()) {
            this.soundEffects.add(new SoundEffect(168, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(169, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(170, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(171, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(173, SoundEffectType.EITHER));
        }
        if (this.config.muteThralls()) {
            this.soundEffects.add(new SoundEffect(211, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(212, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(918, SoundEffectType.EITHER));
        }
        if (this.config.muteCaveHorrors()) {
            this.soundEffects.add(new SoundEffect(497, SoundEffectType.EITHER));
        }
        if (this.config.muteCows()) {
            this.soundEffects.add(new SoundEffect(3044, SoundEffectType.EITHER));
        }
        if (this.config.muteDemons()) {
            this.soundEffects.add(new SoundEffect(397, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(398, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(399, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(400, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(403, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(404, SoundEffectType.EITHER));
        }
        if (this.config.muteDustDevils()) {
            this.soundEffects.add(new SoundEffect(414, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(415, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(416, SoundEffectType.EITHER));
        }
        if (this.config.muteWyverns()) {
            this.soundEffects.add(new SoundEffect(769, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(771, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(773, SoundEffectType.EITHER));
        }
        if (this.config.muteJellies()) {
            this.soundEffects.add(new SoundEffect(547, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(549, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(550, SoundEffectType.EITHER));
        }
        if (this.config.muteNailBeasts()) {
            this.soundEffects.add(new SoundEffect(3482, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(3484, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(3485, SoundEffectType.EITHER));
        }
        if (this.config.muteNechryael()) {
            this.soundEffects.add(new SoundEffect(645, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(646, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(647, SoundEffectType.EITHER));
        }
        if (this.config.muteNightmare()) {
            this.soundEffects.add(new SoundEffect(4281, SoundEffectType.EITHER));
        }
        if (this.config.mutePetSounds()) {
            this.soundEffects.add(new SoundEffect(794, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(941, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(3882, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(4118, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(4132, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(4112, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(4134, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(3834, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(6986, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(6985, SoundEffectType.EITHER));
        }
        if (this.config.mutePetSounds() || this.config.muteRandoms()) {
            this.soundEffects.add(new SoundEffect(333, SoundEffectType.EITHER));
        }
        if (this.config.muteRandoms()) {
            this.soundEffects.add(new SoundEffect(1930, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2297, SoundEffectType.EITHER));
        }
        if (this.config.muteScarabs()) {
            this.soundEffects.add(new SoundEffect(1481, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(1478, SoundEffectType.EITHER));
        }
        if (this.config.muteSire()) {
            this.soundEffects.add(new SoundEffect(236, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(237, SoundEffectType.EITHER));
        }
        if (this.config.muteSpectres()) {
            this.soundEffects.add(new SoundEffect(272, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(273, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(274, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(275, SoundEffectType.EITHER));
        }
        if (this.config.muteTekton()) {
            this.soundEffects.add(new SoundEffect(156, SoundEffectType.EITHER));
        }
        if (this.config.muteTownCrierSounds()) {
            this.soundEffects.add(new SoundEffect(3813, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(3817, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(3816, SoundEffectType.EITHER));
        }
        if (this.config.muteAlchemy()) {
            this.soundEffects.add(new SoundEffect(97, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(98, SoundEffectType.EITHER));
        }
        if (this.config.muteChopChop()) {
            this.soundEffects.add(new SoundEffect(2531, SoundEffectType.EITHER));
        }
        if (this.config.muteSmashing()) {
            this.soundEffects.add(new SoundEffect(2655, SoundEffectType.AREA_SOUND_EFFECT));
        }
        if (this.config.muteDenseEssence()) {
            this.soundEffects.add(new SoundEffect(1553, SoundEffectType.EITHER));
        }
        if (this.config.muteFiremaking()) {
            this.soundEffects.add(new SoundEffect(2596, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2597, SoundEffectType.EITHER));
        }
        if (this.config.muteFishing()) {
            this.soundEffects.add(new SoundEffect(2600, SoundEffectType.EITHER));
        }
        if (this.config.muteFletching()) {
            this.soundEffects.add(new SoundEffect(2605, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2586, SoundEffectType.EITHER));
        }
        if (this.config.muteAOESounds()) {
            this.soundEffects.add(new SoundEffect(3614, SoundEffectType.EITHER));
        }
        if (this.config.mutePickpocket()) {
            this.soundEffects.add(new SoundEffect(2581, SoundEffectType.EITHER));
        }
        if (this.config.mutePickpocketStun()) {
            this.soundEffects.add(new SoundEffect(2727, SoundEffectType.EITHER));
        }
        if (this.config.muteMining()) {
            this.soundEffects.add(new SoundEffect(3220, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(3221, SoundEffectType.EITHER));
        }
        if (this.config.mutePlankMake()) {
            this.soundEffects.add(new SoundEffect(3617, SoundEffectType.EITHER));
        }
        if (this.config.muteStringJewellery()) {
            this.soundEffects.add(new SoundEffect(2903, SoundEffectType.EITHER));
        }
        if (this.config.muteWoodcutting()) {
            this.soundEffects.add(new SoundEffect(2735, SoundEffectType.EITHER));
        }
        if (this.config.muteChargeOrb()) {
            this.soundEffects.add(new SoundEffect(115, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(116, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(117, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(118, SoundEffectType.EITHER));
        }
        if (this.config.muteThickSkin()) {
            this.soundEffects.add(new SoundEffect(2690, SoundEffectType.EITHER));
        }
        if (this.config.muteBurstofStrength()) {
            this.soundEffects.add(new SoundEffect(2688, SoundEffectType.EITHER));
        }
        if (this.config.muteClarityOfThought()) {
            this.soundEffects.add(new SoundEffect(2664, SoundEffectType.EITHER));
        }
        if (this.config.muteRockSkin()) {
            this.soundEffects.add(new SoundEffect(2684, SoundEffectType.EITHER));
        }
        if (this.config.muteSuperhumanStrength()) {
            this.soundEffects.add(new SoundEffect(2689, SoundEffectType.EITHER));
        }
        if (this.config.muteImprovedReflexes()) {
            this.soundEffects.add(new SoundEffect(2662, SoundEffectType.EITHER));
        }
        if (this.config.muteRapidHeal()) {
            this.soundEffects.add(new SoundEffect(2678, SoundEffectType.EITHER));
        }
        if (this.config.muteProtectItem()) {
            this.soundEffects.add(new SoundEffect(1982, SoundEffectType.EITHER));
        }
        if (this.config.muteHawkEye()) {
            this.soundEffects.add(new SoundEffect(2666, SoundEffectType.EITHER));
        }
        if (this.config.muteMysticLore()) {
            this.soundEffects.add(new SoundEffect(2668, SoundEffectType.EITHER));
        }
        if (this.config.muteSteelSkin()) {
            this.soundEffects.add(new SoundEffect(2687, SoundEffectType.EITHER));
        }
        if (this.config.muteUltimateStrength()) {
            this.soundEffects.add(new SoundEffect(2691, SoundEffectType.EITHER));
        }
        if (this.config.muteIncredibleReflexes()) {
            this.soundEffects.add(new SoundEffect(2667, SoundEffectType.EITHER));
        }
        if (this.config.muteProtectFromMagic()) {
            this.soundEffects.add(new SoundEffect(2675, SoundEffectType.EITHER));
        }
        if (this.config.muteProtectFromRange()) {
            this.soundEffects.add(new SoundEffect(2677, SoundEffectType.EITHER));
        }
        if (this.config.muteProtectFromMelee()) {
            this.soundEffects.add(new SoundEffect(2676, SoundEffectType.EITHER));
        }
        if (this.config.muteEagleEye()) {
            this.soundEffects.add(new SoundEffect(2665, SoundEffectType.EITHER));
        }
        if (this.config.muteMysticMight()) {
            this.soundEffects.add(new SoundEffect(2669, SoundEffectType.EITHER));
        }
        if (this.config.muteRetribution()) {
            this.soundEffects.add(new SoundEffect(2682, SoundEffectType.EITHER));
        }
        if (this.config.muteRedemption()) {
            this.soundEffects.add(new SoundEffect(2680, SoundEffectType.EITHER));
        }
        if (this.config.muteSmite()) {
            this.soundEffects.add(new SoundEffect(2686, SoundEffectType.EITHER));
        }
        if (this.config.mutePreserve()) {
            this.soundEffects.add(new SoundEffect(2679, SoundEffectType.EITHER));
        }
        if (this.config.muteChivalry()) {
            this.soundEffects.add(new SoundEffect(3826, SoundEffectType.EITHER));
        }
        if (this.config.mutePiety()) {
            this.soundEffects.add(new SoundEffect(3825, SoundEffectType.EITHER));
        }
        if (this.config.muteRigour()) {
            this.soundEffects.add(new SoundEffect(2685, SoundEffectType.EITHER));
        }
        if (this.config.muteAugury()) {
            this.soundEffects.add(new SoundEffect(2670, SoundEffectType.EITHER));
        }
        if (this.config.muteDeactivatePrayer()) {
            this.soundEffects.add(new SoundEffect(2663, SoundEffectType.EITHER));
        }
        if (this.config.muteFishingExplosive()) {
            this.soundEffects.add(new SoundEffect(1487, SoundEffectType.EITHER));
        }
        if (this.config.muteHealOther()) {
            this.soundEffects.add(new SoundEffect(2892, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2893, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2894, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2895, SoundEffectType.EITHER));
        }
        if (this.config.muteItemDrop()) {
            this.soundEffects.add(new SoundEffect(2739, SoundEffectType.EITHER));
        }
        if (this.config.muteLevelUp()) {
            this.soundEffects.add(new SoundEffect(2396, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2384, SoundEffectType.EITHER));
        }
        if (this.config.muteNPCContact()) {
            this.soundEffects.add(new SoundEffect(3618, SoundEffectType.EITHER));
        }
        if (this.config.muteSnowballSounds()) {
            this.soundEffects.add(new SoundEffect(3292, SoundEffectType.EITHER));
            this.soundEffects.add(new SoundEffect(2708, SoundEffectType.EITHER));
        }
        if (this.config.muteTeleother()) {
            this.soundEffects.add(new SoundEffect(199, SoundEffectType.EITHER));
        }
        if (this.config.muteTeleport()) {
            if (this.config.muteTeleportOthers()) {
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 714));
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 1816));
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3864));
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3865));
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3867));
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3869));
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3872));
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3874));
            } else {
                this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER));
            }
        } else if (this.config.muteTeleportOthers()) {
            this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 714));
            this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 1816));
            this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3864));
            this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3865));
            this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3867));
            this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3869));
            this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3872));
            this.soundEffects.add(new SoundEffect(200, SoundEffectType.EITHER, 3874));
        }
        if (this.config.muteRubberChickenSounds()) {
            this.soundEffects.add(new SoundEffect(2257, SoundEffectType.EITHER));
        }
        if (this.config.muteObelisk()) {
            this.soundEffects.add(new SoundEffect(204, SoundEffectType.EITHER));
        }
        this.ambientSoundsToMute = new HashSet();
        if (this.config.muteMagicTrees()) {
            this.ambientSoundsToMute.add(new SoundEffect(3134, SoundEffectType.AMBIENT));
        }
        if (this.config.muteHousePortal()) {
            this.ambientSoundsToMute.add(new SoundEffect(3139, SoundEffectType.AMBIENT));
        }
        if (this.config.muteWhiteNoise()) {
            this.ambientSoundsToMute.add(new SoundEffect(2184, SoundEffectType.AMBIENT, SoundEffectID.COMMON_BACKGROUND_2184_STATIC_1));
            this.ambientSoundsToMute.add(new SoundEffect(2185, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2083, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2066, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2169, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2088, SoundEffectType.AMBIENT));
        }
        if (this.config.muteChirps()) {
            this.ambientSoundsToMute.add(new SoundEffect(2184, SoundEffectType.AMBIENT, SoundEffectID.COMMON_BACKGROUND_2184_BIRD_1));
            this.ambientSoundsToMute.add(new SoundEffect(2184, SoundEffectType.AMBIENT, SoundEffectID.COMMON_BACKGROUND_2184_BIRD_2));
            this.ambientSoundsToMute.add(new SoundEffect(2184, SoundEffectType.AMBIENT, SoundEffectID.COMMON_BACKGROUND_2184_BIRD_3));
            this.ambientSoundsToMute.add(new SoundEffect(2184, SoundEffectType.AMBIENT, SoundEffectID.COMMON_BACKGROUND_2184_BIRD_4));
            this.ambientSoundsToMute.add(new SoundEffect(1990, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(1991, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(1992, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(1993, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(1994, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(1995, SoundEffectType.AMBIENT));
        }
        if (this.config.muteWater()) {
            this.ambientSoundsToMute.add(new SoundEffect(2184, SoundEffectType.AMBIENT, SoundEffectID.COMMON_BACKGROUND_2184_WATER_1));
            this.ambientSoundsToMute.add(new SoundEffect(2184, SoundEffectType.AMBIENT, SoundEffectID.COMMON_BACKGROUND_2184_WATER_2));
            this.ambientSoundsToMute.add(new SoundEffect(2158, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(3094, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2223, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2168, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(3083, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2149, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2151, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2150, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2147, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2170, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(3087, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2041, SoundEffectType.AMBIENT));
        }
        if (this.config.muteRanges()) {
            this.ambientSoundsToMute.add(new SoundEffect(2199, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2065, SoundEffectType.AMBIENT));
            this.ambientSoundsToMute.add(new SoundEffect(2200, SoundEffectType.AMBIENT));
        }
        for (int i : this.getSelectedAmbientSounds()) {
            this.ambientSoundsToMute.add(new SoundEffect(i, SoundEffectType.AMBIENT));
        }
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed areaSoundEffectPlayed) {
        Actor source = areaSoundEffectPlayed.getSource();
        int soundId = areaSoundEffectPlayed.getSoundId();
        if (source != this.client.getLocalPlayer() && source instanceof Player) {
            if (this.config.muteOthersAreaSounds()) {
                areaSoundEffectPlayed.consume();
            } else if (this.shouldMute(soundId, SoundEffectType.AREA_SOUND_EFFECT)) {
                areaSoundEffectPlayed.consume();
            }
        } else if (source == null) {
            if (soundId == 3834 && this.client.getVarbitValue(5432) == 1) {
                return;
            }
            if (soundId == 2700 && this.config.muteThralls()) {
                areaSoundEffectPlayed.consume();
            }
            if (this.shouldMute(soundId, SoundEffectType.AREA_SOUND_EFFECT)) {
                areaSoundEffectPlayed.consume();
            }
        } else if (this.shouldMute(soundId, SoundEffectType.AREA_SOUND_EFFECT)) {
            areaSoundEffectPlayed.consume();
        }
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed soundEffectPlayed) {
        int soundId = soundEffectPlayed.getSoundId();
        if (this.shouldMute(soundId, SoundEffectType.SOUND_EFFECT)) {
            soundEffectPlayed.consume();
        }
    }

    @VisibleForTesting
    boolean shouldMute(int soundId, SoundEffectType type) {
        SoundEffect soundEffect = new SoundEffect(soundId, type, this.client.getLocalPlayer().getAnimation());
        if (this.getSelectedSounds().contains(Integer.toString(soundId))) {
            return true;
        }
        List filteredSoundEffects = this.soundEffects.stream().filter(s -> s.id == soundEffect.id && (s.type == SoundEffectType.EITHER || s.type == soundEffect.type)).collect(Collectors.toCollection(ArrayList::new));
        if (filteredSoundEffects.size() == 0) {
            return false;
        }
        return filteredSoundEffects.stream().anyMatch(s -> s.animID == -1) || filteredSoundEffects.stream().noneMatch(s -> s.animID == soundEffect.animID);
    }

    public List<String> getSelectedSounds() {
        String configSounds = this.config.soundsToMute().toLowerCase();
        if (configSounds.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configSounds);
    }

    public List<Integer> getSelectedAmbientSounds() {
        String configSounds = this.config.ambientSoundsToMute().toLowerCase();
        List configValue = Text.fromCSV((String)configSounds);
        ArrayList<Integer> returnValues = new ArrayList<Integer>();
        for (String str : configValue) {
            if (!this.tryParseInt(str)) continue;
            returnValues.add(Integer.parseInt(str));
        }
        return returnValues;
    }

    private boolean tryParseInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public HashSet<SoundEffect> getAmbientSoundsToMute() {
        return this.ambientSoundsToMute;
    }
}

