/*
 * Decompiled with CFR 0.152.
 */
package com.brooklyn.annoyancemute;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="annoyancemute")
public interface AnnoyanceMuteConfig
extends Config {
    @ConfigSection(name="Combat", description="Combat sounds to mute", position=0)
    public static final String combatSection = "Combat";
    @ConfigSection(name="NPCs", description="NPC sounds to mute", position=1)
    public static final String npcSection = "NPCs";
    @ConfigSection(name="Skilling", description="Skilling sounds to mute", position=2)
    public static final String skillingSection = "Skilling";
    @ConfigSection(name="Prayers", description="Pray activation/deactivation sounds to mute", position=3, closedByDefault=true)
    public static final String prayerSection = "Prayers";
    @ConfigSection(name="Miscellaneous", description="Miscellaneous sounds to mute", position=4)
    public static final String miscSection = "Miscellaneous";
    @ConfigSection(name="Ambient", description="Ambient sounds to mute", position=5)
    public static final String ambientSection = "Ambient";

    @ConfigItem(keyName="mutePetSounds", name="Pets", description="Mutes the sounds of noise-making pets", section="NPCs")
    default public boolean mutePetSounds() {
        return true;
    }

    @ConfigItem(keyName="muteAreaOfEffectSpells", name="Humidify", description="Mutes humidify spell sound", section="Skilling")
    default public boolean muteAOESounds() {
        return true;
    }

    @ConfigItem(keyName="muteSnowballs", name="Snowballs", description="Mutes the sounds of snowballs being thrown", section="Miscellaneous")
    default public boolean muteSnowballSounds() {
        return true;
    }

    @ConfigItem(keyName="muteWhack", name="Whack", description="Mutes the Rubber chicken and Stale baguette whack sound", section="Miscellaneous")
    default public boolean muteRubberChickenSounds() {
        return true;
    }

    @ConfigItem(keyName="muteOthersAreaSounds", name="Others' Area Sounds", description="Mutes other players' area sounds", section="Miscellaneous")
    default public boolean muteOthersAreaSounds() {
        return false;
    }

    @ConfigItem(keyName="muteCrier", name="Town Crier", description="Mutes the sounds of the Town Crier", section="NPCs")
    default public boolean muteTownCrierSounds() {
        return true;
    }

    @ConfigItem(keyName="muteCannon", name="Cannon spin", description="Mutes the sounds of a cannon spinning", section="Combat")
    default public boolean muteCannon() {
        return true;
    }

    @ConfigItem(keyName="muteREEEE", name="Armadyl Crossbow", description="Mutes the REEEEE of the ACB spec", section="Combat")
    default public boolean muteREEEE() {
        return true;
    }

    @ConfigItem(keyName="muteIceSpells", name="Ice Spells", description="Mutes the sounds of Ice Barrage, Ice Blitz, etc.", section="Combat")
    default public boolean muteIceSpells() {
        return false;
    }

    @ConfigItem(keyName="muteThralls", name="Thralls", description="Mutes the sounds of Thrall attacks", section="Combat")
    default public boolean muteThralls() {
        return false;
    }

    @ConfigItem(keyName="muteSire", name="Sire Spawns", description="Mutes the sounds of the Abyssal Sire's spawns", section="NPCs")
    default public boolean muteSire() {
        return true;
    }

    @ConfigItem(keyName="muteFishingExplosive", name="Fishing Explosive", description="Mutes the sound of Fishing Explosives", section="Miscellaneous")
    default public boolean muteFishingExplosive() {
        return false;
    }

    @ConfigItem(keyName="muteObelisk", name="Wilderness Obelisk", description="Mutes the sounds of the Wilderness Obelisk", section="Miscellaneous")
    default public boolean muteObelisk() {
        return true;
    }

    @ConfigItem(keyName="muteNPCContact", name="NPC Contact", description="Mutes the sound of NPC Contact", section="Miscellaneous")
    default public boolean muteNPCContact() {
        return true;
    }

    @ConfigItem(keyName="muteHealOther", name="Heal Other", description="Mutes the sound of Heal Other and Heal Group", section="Miscellaneous")
    default public boolean muteHealOther() {
        return false;
    }

    @ConfigItem(keyName="muteItemDrop", name="Item Dropping", description="Mutes the sound that occurs when dropping an item", section="Miscellaneous")
    default public boolean muteItemDrop() {
        return false;
    }

    @ConfigItem(keyName="muteLevelUp", name="Level Up", description="Mutes the sound of the Level-up fireworks", section="Miscellaneous")
    default public boolean muteLevelUp() {
        return false;
    }

    @ConfigItem(keyName="muteTeleother", name="Teleother", description="Mutes the sound of the Teleother spell", section="Miscellaneous")
    default public boolean muteTeleother() {
        return false;
    }

    @ConfigItem(keyName="muteTeleport", name="Teleport", description="Mutes the teleport vwoop sound", section="Miscellaneous")
    default public boolean muteTeleport() {
        return false;
    }

    @ConfigItem(keyName="muteTeleportOthers", name="Teleport (only others)", description="Mutes the sound of other players' teleports", section="Miscellaneous")
    default public boolean muteTeleportOthers() {
        return true;
    }

    @ConfigItem(keyName="muteMagicTrees", name="Magic Trees", description="Mutes the sound of Magic Trees", section="Ambient")
    default public boolean muteMagicTrees() {
        return true;
    }

    @ConfigItem(keyName="muteHousePortal", name="House Portal", description="Mutes the sound of House Portal", section="Ambient")
    default public boolean muteHousePortal() {
        return true;
    }

    @ConfigItem(keyName="muteWhiteNoise", name="White Noise", description="Mutes the white noises/static filler sounds", section="Ambient")
    default public boolean muteWhiteNoise() {
        return true;
    }

    @ConfigItem(keyName="muteChirps", name="Chirps", description="Mutes the birds and cricket sounds", section="Ambient")
    default public boolean muteChirps() {
        return true;
    }

    @ConfigItem(keyName="muteWater", name="Water", description="Mutes the sound of water at shores or fountains", section="Ambient")
    default public boolean muteWater() {
        return true;
    }

    @ConfigItem(keyName="muteRanges", name="Ranges", description="Mutes the sound of cooking ranges", section="Ambient")
    default public boolean muteRanges() {
        return true;
    }

    @ConfigItem(keyName="muteRandoms", name="Random Events", description="Mutes the sounds produced by random events", section="NPCs")
    default public boolean muteRandoms() {
        return true;
    }

    @ConfigItem(keyName="muteTekton", name="Tekton meteors", description="Mutes the sound of Tekton's meteor attack", section="NPCs")
    default public boolean muteTekton() {
        return false;
    }

    @ConfigItem(keyName="muteCows", name="Cows", description="Mutes the sounds of Cows' moomoo", section="NPCs")
    default public boolean muteCows() {
        return true;
    }

    @ConfigItem(keyName="muteCaveHorrors", name="Cave Horrors", description="Mutes the sound of Cave Horrors", section="NPCs")
    default public boolean muteCaveHorrors() {
        return true;
    }

    @ConfigItem(keyName="muteWyverns", name="Fossil Island Wyverns", description="Mutes the sounds of Fossil Island Wyverns", section="NPCs")
    default public boolean muteWyverns() {
        return true;
    }

    @ConfigItem(keyName="muteJellies", name="Jellies", description="Mutes the sounds of Jellies", section="NPCs")
    default public boolean muteJellies() {
        return true;
    }

    @ConfigItem(keyName="muteNailBeasts", name="Nail Beasts", description="Mutes the sounds of Nail Beasts", section="NPCs")
    default public boolean muteNailBeasts() {
        return true;
    }

    @ConfigItem(keyName="muteDemons", name="Demons", description="Mutes the sounds of various Demons", section="NPCs")
    default public boolean muteDemons() {
        return false;
    }

    @ConfigItem(keyName="muteNechryael", name="Nechryael", description="Mutes the sounds of Nechryaels", section="NPCs")
    default public boolean muteNechryael() {
        return false;
    }

    @ConfigItem(keyName="muteDustDevils", name="Dust Devils", description="Mutes the sounds of Dust Devils", section="NPCs")
    default public boolean muteDustDevils() {
        return false;
    }

    @ConfigItem(keyName="muteSpectres", name="Spectres", description="Mutes the sounds of Aberrant and Deviant Spectres", section="NPCs")
    default public boolean muteSpectres() {
        return false;
    }

    @ConfigItem(keyName="muteDenseEssence", name="Dense Essence", description="Mutes the sound of chiseling Dense Essence", section="Skilling")
    default public boolean muteDenseEssence() {
        return true;
    }

    @ConfigItem(keyName="muteChopChop", name="Chop Chop!", description="Mutes the sound of the Dragon axe special", section="Skilling")
    default public boolean muteChopChop() {
        return true;
    }

    @ConfigItem(keyName="muteSmashing!", name="Smashing!", description="Mutes the sound of the Dragon Pickaxe special", section="Skilling")
    default public boolean muteSmashing() {
        return true;
    }

    @ConfigItem(keyName="muteWoodcutting", name="Woodcutting", description="Mutes the sound of Woodcutting", section="Skilling")
    default public boolean muteWoodcutting() {
        return true;
    }

    @ConfigItem(keyName="plankMake", name="Plank Make", description="Mutes the sound of Plank Make", section="Skilling")
    default public boolean mutePlankMake() {
        return true;
    }

    @ConfigItem(keyName="mutePickpocket", name="Pickpocket", description="Mutes the sound of the pickpocket plop", section="Skilling")
    default public boolean mutePickpocket() {
        return false;
    }

    @ConfigItem(keyName="mutePickpocketStun", name="Pickpocket Stun", description="Mutes the sound of the pickpocket stun", section="Skilling")
    default public boolean mutePickpocketStun() {
        return false;
    }

    @ConfigItem(keyName="muteStringJewellery", name="String Jewellery", description="Mutes the sound of the String Jewellery spell", section="Skilling")
    default public boolean muteStringJewellery() {
        return true;
    }

    @ConfigItem(keyName="muteNightmare", name="Nightmare", description="Mutes the sound of the Nightmare's parry", section="NPCs")
    default public boolean muteNightmare() {
        return true;
    }

    @ConfigItem(keyName="muteScarabs", name="Scarab Swarm", description="Mutes the sound of the Scarab swarm in Pyramid Plunder", section="NPCs")
    default public boolean muteScarabs() {
        return true;
    }

    @ConfigItem(keyName="muteFiremaking", name="Firemaking", description="Mutes the sound of burning and lighting logs", section="Skilling")
    default public boolean muteFiremaking() {
        return false;
    }

    @ConfigItem(keyName="muteFishing", name="Fishing", description="Mutes the sound of Fishing", section="Skilling")
    default public boolean muteFishing() {
        return true;
    }

    @ConfigItem(keyName="muteFletching", name="Fletching", description="Mutes the sound of Fletching", section="Skilling")
    default public boolean muteFletching() {
        return false;
    }

    @ConfigItem(keyName="muteMining", name="Mining", description="Mutes the sounds of Mining", section="Skilling")
    default public boolean muteMining() {
        return false;
    }

    @ConfigItem(keyName="muteAlchemy", name="Alchemy", description="Mutes the sounds of Low and High Alchemy", section="Skilling")
    default public boolean muteAlchemy() {
        return true;
    }

    @ConfigItem(keyName="muteChargeOrb", name="Charge Orb", description="Mutes the sounds of Charge Orb spells", section="Skilling")
    default public boolean muteChargeOrb() {
        return false;
    }

    @ConfigItem(keyName="muteThickSkin", name="Thick Skin", description="Mutes the activation sound of Thick Skin", section="Prayers", position=1)
    default public boolean muteThickSkin() {
        return false;
    }

    @ConfigItem(keyName="muteBurstOfStrength", name="Burst of Strength", description="Mutes the activation sound of Burst of Strength", section="Prayers", position=2)
    default public boolean muteBurstofStrength() {
        return false;
    }

    @ConfigItem(keyName="muteClarityOfThought", name="Clarity of Thought", description="Mutes the activation sound of Clarity of Thought", section="Prayers", position=3)
    default public boolean muteClarityOfThought() {
        return false;
    }

    @ConfigItem(keyName="muteRockSkin", name="Rock Skin", description="Mutes the activation sound of Rock Skin", section="Prayers", position=4)
    default public boolean muteRockSkin() {
        return false;
    }

    @ConfigItem(keyName="muteSuperhumanStrength", name="Superhuman Strength", description="Mutes the activation sound of Superhuman Strength", section="Prayers", position=5)
    default public boolean muteSuperhumanStrength() {
        return false;
    }

    @ConfigItem(keyName="muteImprovedReflexes", name="Improved Reflexes", description="Mutes the activation sound of Improved Reflexes", section="Prayers", position=6)
    default public boolean muteImprovedReflexes() {
        return false;
    }

    @ConfigItem(keyName="muteRapidHeal", name="Rapid Heal", description="Mutes the activation sound of Rapid Heal", section="Prayers", position=7)
    default public boolean muteRapidHeal() {
        return false;
    }

    @ConfigItem(keyName="muteProtectItem", name="Protect Item", description="Mutes the activation sound of Protect Item", section="Prayers", position=8)
    default public boolean muteProtectItem() {
        return false;
    }

    @ConfigItem(keyName="muteHawkEye", name="Hawk Eye", description="Mutes the activation sound of Hawk Eye", section="Prayers", position=9)
    default public boolean muteHawkEye() {
        return false;
    }

    @ConfigItem(keyName="muteMysticLore", name="Mystic Lore", description="Mutes the activation sound of Mystic Lore", section="Prayers", position=10)
    default public boolean muteMysticLore() {
        return false;
    }

    @ConfigItem(keyName="muteSteelSkin", name="Steel Skin", description="Mutes the activation sound of Steel Skin", section="Prayers", position=11)
    default public boolean muteSteelSkin() {
        return false;
    }

    @ConfigItem(keyName="muteUltimateStrength", name="Ultimate Strength", description="Mutes the activation sound of Ultimate Strength", section="Prayers", position=12)
    default public boolean muteUltimateStrength() {
        return false;
    }

    @ConfigItem(keyName="muteIncredibleReflexes", name="Incredible Reflexes", description="Mutes the activation sound of Incredible Reflexes", section="Prayers", position=13)
    default public boolean muteIncredibleReflexes() {
        return false;
    }

    @ConfigItem(keyName="muteProtectFromMagic", name="Protect from Magic", description="Mutes the activation sound of Protect from Magic", section="Prayers", position=14)
    default public boolean muteProtectFromMagic() {
        return false;
    }

    @ConfigItem(keyName="muteProtectFromRange", name="Protect from Range", description="Mutes the activation sound of Protect from Range", section="Prayers", position=15)
    default public boolean muteProtectFromRange() {
        return false;
    }

    @ConfigItem(keyName="muteProtectFromMelee", name="Protect from Melee", description="Mutes the activation sound of Protect from Melee", section="Prayers", position=16)
    default public boolean muteProtectFromMelee() {
        return false;
    }

    @ConfigItem(keyName="muteEagleEye", name="Eagle Eye", description="Mutes the activation sound of Eagle Eye", section="Prayers", position=17)
    default public boolean muteEagleEye() {
        return false;
    }

    @ConfigItem(keyName="muteMysticMight", name="Mystic Might", description="Mutes the activation sound of Mystic Might", section="Prayers", position=18)
    default public boolean muteMysticMight() {
        return false;
    }

    @ConfigItem(keyName="muteRetribution", name="Retribution", description="Mutes the activation sound of Retribution", section="Prayers", position=19)
    default public boolean muteRetribution() {
        return false;
    }

    @ConfigItem(keyName="muteRedemption", name="Redemption", description="Mutes the activation sound of Redemption", section="Prayers", position=20)
    default public boolean muteRedemption() {
        return false;
    }

    @ConfigItem(keyName="muteSmite", name="Smite", description="Mutes the activation sound of Smite", section="Prayers", position=21)
    default public boolean muteSmite() {
        return false;
    }

    @ConfigItem(keyName="mutePreserve", name="Preserve", description="Mutes the activation sound of Preserve and Rapid Restore", section="Prayers", position=22)
    default public boolean mutePreserve() {
        return false;
    }

    @ConfigItem(keyName="muteChivalry", name="Chivalry", description="Mutes the activation sound of Chivalry", section="Prayers", position=23)
    default public boolean muteChivalry() {
        return false;
    }

    @ConfigItem(keyName="mutePiety", name="Piety", description="Mutes the activation sound of Piety", section="Prayers", position=24)
    default public boolean mutePiety() {
        return false;
    }

    @ConfigItem(keyName="muteRigour", name="Rigour", description="Mutes the activation sound of Rigour and Sharp Eye", section="Prayers", position=25)
    default public boolean muteRigour() {
        return false;
    }

    @ConfigItem(keyName="muteAugury", name="Augury", description="Mutes the activation sound of Augury and Mystic Will", section="Prayers", position=26)
    default public boolean muteAugury() {
        return false;
    }

    @ConfigItem(keyName="muteDeactivatePrayer", name="Deactivate Prayer", description="Mutes the prayer deactivation sound", section="Prayers", position=27)
    default public boolean muteDeactivatePrayer() {
        return false;
    }

    @ConfigItem(keyName="soundsToMute", name="Muted Sounds", description="Enter IDs of the sounds you wish to mute", position=28)
    default public String soundsToMute() {
        return "";
    }

    @ConfigItem(keyName="ambientSoundsToMute", name="Muted Ambient Sounds", description="Enter IDs of the ambient sounds you wish to mute", position=29)
    default public String ambientSoundsToMute() {
        return "";
    }
}

