/*
 * Decompiled with CFR 0.152.
 */
package com.trailblazer.audio.announcement;

import com.google.inject.Provides;
import com.trailblazer.audio.announcement.Sound;
import com.trailblazer.audio.announcement.SoundEngine;
import com.trailblazer.audio.announcement.TrailblazerAudioAnnouncementConfig;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Trailblazer Audio Announcement", description="Plays the Leagues 2: Trailblazer jingle when completing specific tasks", tags={"trailblazer", "leagues", "sound", "combat achievements", "collection log"})
public class TrailblazerAudioAnnouncementPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TrailblazerAudioAnnouncementPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private TrailblazerAudioAnnouncementConfig config;
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log:.*");
    private static final Pattern COMBAT_TASK_REGEX = Pattern.compile("Congratulations, you've completed an? (?:\\w+) combat task:.*");
    private int ticksSinceLogin = 0;
    private boolean resetTicks = false;

    protected void startUp() throws Exception {
        log.info("Trailblazer Audio Announcement started!");
    }

    protected void shutDown() throws Exception {
        log.info("Trailblazer Audio Announcement stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: 
            case LOGGING_IN: 
            case LOGIN_SCREEN_AUTHENTICATOR: 
            case CONNECTION_LOST: {
                this.resetTicks = true;
                this.ticksSinceLogin = 0;
                break;
            }
            case LOGGED_IN: {
                if (!this.resetTicks) break;
                this.resetTicks = false;
                this.ticksSinceLogin = 0;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        ++this.ticksSinceLogin;
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (this.config.playCollectionLog() && COLLECTION_LOG_ITEM_REGEX.matcher(chatMessage.getMessage()).matches()) {
            this.soundEngine.playClip(Sound.JINGLE);
        } else if (this.config.playCombatAchievement() && COMBAT_TASK_REGEX.matcher(chatMessage.getMessage()).matches()) {
            this.soundEngine.playClip(Sound.JINGLE);
        }
    }

    @Provides
    TrailblazerAudioAnnouncementConfig provideConfig(ConfigManager configManager) {
        return (TrailblazerAudioAnnouncementConfig)configManager.getConfig(TrailblazerAudioAnnouncementConfig.class);
    }

    ClientThread getClientThread() {
        return this.clientThread;
    }
}

