/*
 * Decompiled with CFR 0.152.
 */
package com.trailblazer.audio.announcement;

import com.trailblazer.audio.announcement.Sound;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundEngine {
    private static final Logger log = LoggerFactory.getLogger(SoundEngine.class);
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private long lastClipMTime = -2L;
    private Clip clip = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadClip(Sound sound) {
        try (InputStream resourceStream = SoundEngine.class.getResourceAsStream(sound.getResourceName());){
            if (resourceStream == null) {
                log.warn("Failed to load jingle " + sound + " as resource stream was null!");
                return false;
            }
            try (BufferedInputStream fileStream = new BufferedInputStream(resourceStream);
                 AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(fileStream);){
                this.clip.open(audioInputStream);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.warn("Failed to load jingle " + sound, (Throwable)e);
        }
        return false;
    }

    public void playClip(Sound sound) {
        long currentMTime = System.currentTimeMillis();
        if (this.clip == null || currentMTime != this.lastClipMTime || !this.clip.isOpen()) {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.close();
            }
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                this.lastClipMTime = -2L;
                log.warn("Failed to get clip for jingle " + sound, (Throwable)e);
                return;
            }
            this.lastClipMTime = currentMTime;
            if (!this.loadClip(sound)) {
                return;
            }
        }
        this.clip.loop(0);
    }
}

