/*
 * Decompiled with CFR 0.152.
 */
package com.acoldoneclogging;

import com.acoldoneclogging.AColdOneCloggingConfig;
import com.acoldoneclogging.Sound;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundEngine {
    private static final Logger log = LoggerFactory.getLogger(SoundEngine.class);
    @Inject
    private AColdOneCloggingConfig config;
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private long lastClipMTime = -2L;
    private Clip clip = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadClip(Sound sound) {
        try (InputStream resourceStream = SoundEngine.class.getResourceAsStream(sound.getResourceName());){
            if (resourceStream == null) {
                log.warn("Failed to load sound " + sound + " as resource stream was null!");
                return false;
            }
            try (BufferedInputStream fileStream = new BufferedInputStream(resourceStream);
                 AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(fileStream);){
                this.clip.open(audioInputStream);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.warn("Failed to load sound " + sound, (Throwable)e);
        }
        return false;
    }

    public void playClip(Sound sound) {
        long currentMTime = System.currentTimeMillis();
        if (this.clip == null || currentMTime != this.lastClipMTime || !this.clip.isOpen()) {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.close();
            }
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                this.lastClipMTime = -2L;
                log.warn("Failed to get clip for C Engineer sound " + sound, (Throwable)e);
                return;
            }
            this.lastClipMTime = currentMTime;
            if (!this.loadClip(sound)) {
                return;
            }
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = 20.0f * (float)Math.log10((float)this.config.Volume() / 100.0f);
        gain = Math.min(gain, volume.getMaximum());
        gain = Math.max(gain, volume.getMinimum());
        volume.setValue(gain);
        this.clip.loop(0);
    }

    public void close() {
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.close();
        }
    }
}

