/*
 * Decompiled with CFR 0.152.
 */
package com.acoldoneclogging;

import com.acoldoneclogging.AColdOneCloggingConfig;
import com.acoldoneclogging.DiscordWebhookBody;
import com.acoldoneclogging.Overlays.LeoSpinOverlay;
import com.acoldoneclogging.Overlays.WideLeoOverlay;
import com.acoldoneclogging.Sound;
import com.acoldoneclogging.SoundEngine;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Projectile;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="AColdOne Clogging")
public class AColdOneCloggingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AColdOneCloggingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private AColdOneCloggingConfig config;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ScheduledExecutorService executorService;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private DrawManager drawManager;
    @Inject
    private OkHttpClient okHttpClient;
    private final WideLeoOverlay wideLeoOverlay = new WideLeoOverlay();
    private final LeoSpinOverlay leoSpinOverlay = new LeoSpinOverlay();
    private final DiscordWebhookBody discordWebhook = new DiscordWebhookBody();
    private static final Pattern ClogRegex = Pattern.compile("New item added to your collection log:.*");
    private static final Pattern TaskRegex = Pattern.compile("Congratulations, you've completed an? (?:\\w+) combat task:.*");
    private static final Pattern BaronRegex = Pattern.compile("New item added to your collection log: Baron");
    private static final Set<Integer> BadClogSettings = new HashSet<Integer>(){
        {
            this.add(0);
            this.add(2);
        }
    };
    private int LastClogWarning = -1;
    private int lastBalledTick = -1;
    private boolean functionRunning = false;
    private final String[] wideLeoIcons = new String[52];
    private final String[] leoSpinIcons = new String[66];

    protected void startUp() throws Exception {
        this.OverlaysSetup();
    }

    protected void shutDown() throws Exception {
        this.soundEngine.close();
    }

    @Subscribe
    protected void onGameStateChanged(GameStateChanged stateChanged) {
        switch (stateChanged.getGameState()) {
            case LOGIN_SCREEN: 
            case LOGGING_IN: 
            case HOPPING: 
            case CONNECTION_LOST: {
                this.LastClogWarning = this.client.getTickCount();
                break;
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        String Message;
        if (chatMessage.getType() == ChatMessageType.PUBLICCHAT) {
            Message = chatMessage.getMessage();
            boolean isUser = Text.sanitize((String)chatMessage.getName()).equalsIgnoreCase(this.client.getLocalPlayer().getName());
            if (this.config.WideLeo() && Message.equalsIgnoreCase("!Leo") && isUser) {
                this.overlayManager.add((Overlay)this.wideLeoOverlay);
                this.LeoWiden();
            } else if (this.config.LeoSpin() && Message.equalsIgnoreCase("!LeoSpin") && isUser) {
                this.overlayManager.add((Overlay)this.leoSpinOverlay);
                this.LeoSpin();
            }
        }
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            Message = chatMessage.getMessage();
            if (this.config.Baron() && BaronRegex.matcher(chatMessage.getMessage()).matches()) {
                this.soundEngine.playClip(Sound.Baron);
            } else if (this.config.AnnounceClog() && ClogRegex.matcher(Message).matches()) {
                Random random = new Random();
                int logNumber = random.nextInt(10) + 1;
                Sound selectedLog = Sound.valueOf("CollectionLog_" + logNumber);
                this.soundEngine.playClip(selectedLog);
            } else if (this.config.AnnounceCombatTasks() && TaskRegex.matcher(Message).matches()) {
                this.soundEngine.playClip(Sound.valueOf("TaskCompletion"));
            }
        }
    }

    private void WarnForClogSettings(int newVarbitValue) {
        if (BadClogSettings.contains(newVarbitValue) && (this.LastClogWarning == -1 || this.client.getTickCount() - this.LastClogWarning > 10)) {
            this.LastClogWarning = this.client.getTickCount();
            this.SendMessage("Please enable \"Collection log - New addition notification\" in your game settings or switch off the \"AColdOne Clogging\" plugin to switch off this warning");
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarbitId() == 11959) {
            this.WarnForClogSettings(varbitChanged.getValue());
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        int currentTick = this.client.getTickCount();
        if (currentTick - this.lastBalledTick > 500) {
            this.functionRunning = false;
        }
        if (this.functionRunning) {
            return;
        }
        Projectile projectile = projectileMoved.getProjectile();
        if (projectile.getId() != 55) {
            return;
        }
        Player Me = this.client.getLocalPlayer();
        if (Me == null) {
            return;
        }
        Actor projectileInteraction = projectile.getInteracting();
        if (!Me.equals(projectileInteraction)) {
            return;
        }
        if (!this.config.Balled()) {
            return;
        }
        this.functionRunning = true;
        this.lastBalledTick = currentTick;
        this.client.getLocalPlayer().setOverheadText("Oh no, i got balled");
        this.executorService.schedule(() -> {
            this.soundEngine.playClip(Sound.valueOf("Balled_1"));
            if (this.config.BalledScreenshot() && this.config.WebhookLink() != null) {
                this.sendScreenshot();
            }
            this.client.getLocalPlayer().setOverheadText("");
        }, 1200L, TimeUnit.MILLISECONDS);
    }

    public void SendMessage(String Message) {
        String HighlightedMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(Message).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(HighlightedMessage).build());
    }

    public void LeoWiden() {
        final Timer timer = new Timer();
        long interval = 40L;
        TimerTask task = new TimerTask(){
            int currentIndex = 0;

            @Override
            public void run() {
                if (this.currentIndex < AColdOneCloggingPlugin.this.wideLeoIcons.length) {
                    String image = AColdOneCloggingPlugin.this.wideLeoIcons[this.currentIndex];
                    AColdOneCloggingPlugin.this.wideLeoOverlay.setImage(image);
                    ++this.currentIndex;
                } else {
                    timer.cancel();
                    AColdOneCloggingPlugin.this.executorService.schedule(() -> AColdOneCloggingPlugin.this.overlayManager.remove((Overlay)AColdOneCloggingPlugin.this.wideLeoOverlay), 250L, TimeUnit.MILLISECONDS);
                }
            }
        };
        timer.scheduleAtFixedRate(task, 0L, interval);
    }

    public void LeoSpin() {
        final Timer timer = new Timer();
        long interval = 40L;
        TimerTask task = new TimerTask(){
            int currentIndex = 0;

            @Override
            public void run() {
                if (this.currentIndex < AColdOneCloggingPlugin.this.leoSpinIcons.length * AColdOneCloggingPlugin.this.config.LoopAmount()) {
                    String image = AColdOneCloggingPlugin.this.leoSpinIcons[this.currentIndex % AColdOneCloggingPlugin.this.leoSpinIcons.length];
                    AColdOneCloggingPlugin.this.leoSpinOverlay.setImage(image);
                    ++this.currentIndex;
                } else {
                    timer.cancel();
                    AColdOneCloggingPlugin.this.executorService.schedule(() -> AColdOneCloggingPlugin.this.overlayManager.remove((Overlay)AColdOneCloggingPlugin.this.leoSpinOverlay), 250L, TimeUnit.MILLISECONDS);
                }
            }
        };
        timer.scheduleAtFixedRate(task, 0L, interval);
    }

    public void OverlaysSetup() {
        int i;
        for (i = 0; i < 52; ++i) {
            this.wideLeoIcons[i] = "/WideLeo/" + i + ".gif";
        }
        for (i = 0; i < 66; ++i) {
            this.leoSpinIcons[i] = "/LeoSpin/" + i + ".gif";
        }
    }

    private void sendScreenshot() {
        String playerName = this.client.getLocalPlayer().getName();
        String MessageString = String.format("%s %s", playerName, "got balled <:x0r6ztlurk:948329913734275093>");
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(MessageString);
        String webhookLink = this.config.WebhookLink();
        HttpUrl url = HttpUrl.parse((String)webhookLink);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = AColdOneCloggingPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Provides
    AColdOneCloggingConfig provideConfig(ConfigManager configManager) {
        return (AColdOneCloggingConfig)configManager.getConfig(AColdOneCloggingConfig.class);
    }
}

