/*
 * Decompiled with CFR 0.152.
 */
package com.spawnpredictor.util;

import java.util.EnumSet;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StartLocations {
    ROTATION_1(1, 2),
    ROTATION_2(2, 13),
    ROTATION_3(3, 8),
    ROTATION_4(4, 12),
    ROTATION_5(5, 7),
    ROTATION_6(6, 3),
    ROTATION_7(7, 6),
    ROTATION_8(8, 6),
    ROTATION_9(9, 14),
    ROTATION_10(10, 5),
    ROTATION_11(11, 0),
    ROTATION_12(12, 9),
    ROTATION_13(13, 1),
    ROTATION_14(14, 10),
    ROTATION_15(15, 4);

    private static final Logger log;
    private final int r;
    private final int rsVal;
    private static final HashMap<Integer, Integer> lookupMap;

    private StartLocations(int r, int rsVal) {
        this.r = r;
        this.rsVal = rsVal;
    }

    public static int translateRotation(int r) {
        switch (r) {
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 13;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 15;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 5;
            }
            case 12: {
                return 3;
            }
            case 13: {
                return 12;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 7;
            }
        }
        log.debug("Invalid Rotation Column Number -> {}", (Object)r);
        return -1;
    }

    public int getR() {
        return this.r;
    }

    public int getRsVal() {
        return this.rsVal;
    }

    public static HashMap<Integer, Integer> getLookupMap() {
        return lookupMap;
    }

    static {
        log = LoggerFactory.getLogger(StartLocations.class);
        lookupMap = new HashMap();
        EnumSet.allOf(StartLocations.class).forEach(n -> lookupMap.put(n.getR(), n.getRsVal()));
    }
}

