/*
 * Decompiled with CFR 0.152.
 */
package com.spawnpredictor.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SpawnLocations {
    NW(10, 50),
    C(30, 30),
    SE(50, 25),
    S(35, 15),
    SW(10, 15);

    private static final Logger log;
    private final int regionX;
    private final int regionY;

    private SpawnLocations(int regionX, int regionY) {
        this.regionX = regionX;
        this.regionY = regionY;
    }

    public static SpawnLocations lookup(int sVal) {
        switch (sVal) {
            case 3: 
            case 7: 
            case 12: {
                return NW;
            }
            case 2: 
            case 8: 
            case 13: {
                return C;
            }
            case 0: 
            case 5: 
            case 9: {
                return SE;
            }
            case 6: 
            case 11: 
            case 14: {
                return S;
            }
            case 1: 
            case 4: 
            case 10: {
                return SW;
            }
        }
        log.debug("Invalid sVal -> {}", (Object)sVal);
        return null;
    }

    public int getRegionX() {
        return this.regionX;
    }

    public int getRegionY() {
        return this.regionY;
    }

    static {
        log = LoggerFactory.getLogger(SpawnLocations.class);
    }
}

