/*
 * Decompiled with CFR 0.152.
 */
package com.spawnpredictor.overlays;

import com.spawnpredictor.SpawnPredictorConfig;
import com.spawnpredictor.SpawnPredictorPlugin;
import com.spawnpredictor.util.StartLocations;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class RotationOverlayPanel
extends OverlayPanel {
    private final SpawnPredictorPlugin plugin;
    private final SpawnPredictorConfig config;

    @Inject
    private RotationOverlayPanel(SpawnPredictorPlugin plugin, SpawnPredictorConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPriority(OverlayPriority.HIGH);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInTzhaarArea() || !this.config.lobbyRotationInfoOverlay()) {
            return null;
        }
        int rotation = this.plugin.getRotationCol();
        this.panelComponent.setPreferredSize(new Dimension(125, 0));
        if (this.config.includeUTCTime()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Time:").leftColor(Color.WHITE).right(this.plugin.getUTCFormatted()).rightColor(Color.ORANGE).build());
        }
        if (this.plugin.isServerUTCTimeSecondSet()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Current Rotation:").leftColor(Color.WHITE).right(Integer.toString(StartLocations.translateRotation(rotation))).rightColor(Color.GREEN).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Next:").leftColor(Color.WHITE).right("[T - " + (60 - this.plugin.getServerUTCTime().getSecond()) + "s, Rot: " + (rotation + 1 > 15 ? "4" : Integer.toString(StartLocations.translateRotation(rotation + 1))) + "]").rightColor(Color.YELLOW).build());
        } else {
            this.panelComponent.getChildren().add(LineComponent.builder().right("Determining...").rightColor(Color.YELLOW).build());
        }
        return super.render(graphics);
    }
}

