/*
 * Decompiled with CFR 0.152.
 */
package com.spawnpredictor.overlays;

import com.spawnpredictor.SpawnPredictorConfig;
import com.spawnpredictor.SpawnPredictorPlugin;
import com.spawnpredictor.util.FightCavesNpc;
import com.spawnpredictor.util.FightCavesNpcSpawn;
import com.spawnpredictor.util.SpawnLocations;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayModeOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(DisplayModeOverlay.class);
    private final Client client;
    private final SpawnPredictorPlugin plugin;
    private final SpawnPredictorConfig config;

    @Inject
    private DisplayModeOverlay(Client client, SpawnPredictorPlugin plugin, SpawnPredictorConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPriority(OverlayPriority.HIGH);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isFightCavesActive() || this.config.displayMode() == SpawnPredictorConfig.DisplayMode.OFF || this.plugin.getCurrentWave() <= 0 || this.plugin.getCurrentRotation() == -1) {
            return null;
        }
        int wave = this.plugin.getCurrentWave() - 1;
        DisplayModeOverlay displayModeOverlay = this;
        List<FightCavesNpcSpawn> currentWaveContents = displayModeOverlay.plugin.getWaveData().get(wave);
        switch (this.config.displayMode()) {
            case CURRENT_WAVE: {
                this.renderWaveContents(graphics, currentWaveContents, this.config.currentWaveColor());
                break;
            }
            case NEXT_WAVE: {
                if (wave == 0 || this.config.displayCurrentWave() != SpawnPredictorConfig.CurrentWaveDisplayMode.OFF && this.plugin.isHotkeyEnabled()) {
                    this.renderWaveContents(graphics, currentWaveContents, this.config.currentWaveColor());
                }
                if (wave == 63) break;
                DisplayModeOverlay displayModeOverlay2 = this;
                this.renderWaveContents(graphics, displayModeOverlay2.plugin.getWaveData().get(wave + 1), this.config.nextWaveColor());
                break;
            }
            case BOTH: {
                this.renderWaveContents(graphics, currentWaveContents, this.config.currentWaveColor());
                if (wave == 63) break;
                DisplayModeOverlay displayModeOverlay3 = this;
                this.renderWaveContents(graphics, displayModeOverlay3.plugin.getWaveData().get(wave + 1), this.config.nextWaveColor());
                break;
            }
            default: {
                throw new IllegalStateException("Illegal 'Display Mode' config state... How did this happen? Who knows");
            }
        }
        return null;
    }

    private void renderWaveContents(Graphics2D graphics, List<FightCavesNpcSpawn> waveContents, Color color) {
        waveContents.forEach(fcNpc -> {
            FightCavesNpc npc = fcNpc.getNpc();
            String name = npc.getName();
            int size = npc.getSize();
            SpawnLocations spawnLoc = SpawnLocations.lookup(fcNpc.getSpawnLocation());
            if (spawnLoc == null) {
                return;
            }
            LocalPoint localPoint = this.getCenterLocalPoint(spawnLoc.getRegionX(), spawnLoc.getRegionY(), size);
            if (localPoint == null) {
                return;
            }
            Polygon poly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)localPoint, (int)size);
            this.renderPolygon(graphics, poly, color);
            Point textLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (String)name, (int)0);
            if (textLocation != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)name, (Color)(this.config.multicolorNames() ? color : Color.WHITE));
            }
        });
    }

    private LocalPoint getCenterLocalPoint(int regionX, int regionY, int size) {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)WorldPoint.fromRegion((int)this.client.getLocalPlayer().getWorldLocation().getRegionID(), (int)regionX, (int)regionY, (int)this.client.getPlane()));
        if (lp == null) {
            return null;
        }
        return new LocalPoint(lp.getX() + (size - 1) * 64, lp.getY() + (size - 1) * 64);
    }

    private void renderPolygon(Graphics2D graphics, @Nullable Shape poly, @Nonnull Color color) {
        if (poly == null) {
            return;
        }
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(this.config.overlayStrokeSize()));
        graphics.draw(poly);
        graphics.setColor(new Color(0, 0, 0, 50));
        graphics.fill(poly);
    }
}

