/*
 * Decompiled with CFR 0.152.
 */
package com.spawnpredictor.overlays;

import com.google.inject.Inject;
import com.spawnpredictor.SpawnPredictorConfig;
import com.spawnpredictor.SpawnPredictorPlugin;
import com.spawnpredictor.util.StartLocations;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class DebugOverlayPanel
extends OverlayPanel {
    private final SpawnPredictorPlugin plugin;
    private final SpawnPredictorConfig config;

    @Inject
    private DebugOverlayPanel(SpawnPredictorPlugin plugin, SpawnPredictorConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPriority(OverlayPriority.HIGH);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.debug()) {
            return null;
        }
        this.panelComponent.setPreferredSize(new Dimension(75, 0));
        if (!this.plugin.isFightCavesActive() && this.plugin.isInTzhaarArea()) {
            int rotationCol = this.plugin.getRotationCol();
            this.panelComponent.getChildren().add(LineComponent.builder().left("RCol:").leftColor(Color.WHITE).right(Integer.toString(rotationCol)).rightColor(Color.GREEN).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("RTrans:").leftColor(Color.WHITE).right(Integer.toString(StartLocations.translateRotation(rotationCol))).rightColor(Color.GREEN).build());
        }
        if (this.plugin.isFightCavesActive() && !this.plugin.isInTzhaarArea()) {
            int rotation = this.plugin.getCurrentRotation();
            this.panelComponent.getChildren().add(LineComponent.builder().left("Wave:").leftColor(Color.WHITE).right(Integer.toString(this.plugin.getCurrentWave())).rightColor(Color.GREEN).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Rotation:").leftColor(Color.WHITE).right(Integer.toString(rotation)).rightColor(Color.GREEN).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("rsV:").leftColor(Color.WHITE).right(Integer.toString(SpawnPredictorPlugin.getRsVal())).rightColor(Color.ORANGE).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("rsF:").leftColor(Color.WHITE).right(Integer.toString(StartLocations.getLookupMap().get(rotation))).rightColor(Color.ORANGE).build());
        }
        return super.render(graphics);
    }
}

