/*
 * Decompiled with CFR 0.152.
 */
package com.spawnpredictor;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.spawnpredictor.SpawnPredictorConfig;
import com.spawnpredictor.overlays.DebugOverlayPanel;
import com.spawnpredictor.overlays.DisplayModeOverlay;
import com.spawnpredictor.overlays.RotationOverlayPanel;
import com.spawnpredictor.util.AccountMemory;
import com.spawnpredictor.util.FightCavesNpc;
import com.spawnpredictor.util.FightCavesNpcSpawn;
import com.spawnpredictor.util.StartLocations;
import java.awt.event.KeyEvent;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="FC Spawn Predictor", description="Determine the spawn rotations for Fight Caves", tags={"fight", "caves", "jad", "spawn", "predictor", "waves", "time", "timer", "rotation", "damen"})
public class SpawnPredictorPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(SpawnPredictorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private KeyManager keyManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RotationOverlayPanel rotationOverlayPanel;
    @Inject
    private DisplayModeOverlay displayModeOverlay;
    @Inject
    private DebugOverlayPanel debugOverlayPanel;
    @Inject
    private SpawnPredictorConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    private static List<List<FightCavesNpcSpawn>> waveData = new ArrayList<List<FightCavesNpcSpawn>>();
    private LocalTime serverUTCTime;
    private int serverTime = -1;
    private int oldServerTime = -1;
    private int serverTimeSecondOffset = 1;
    private boolean serverUTCTimeSecondSet = false;
    private int currentUTCTime;
    private int rotationCol = -1;
    private int currentWave = -1;
    private int currentRotation = -1;
    private static int rsVal = -1;
    private boolean hotkeyEnabled = false;
    private boolean active = false;
    private boolean confirmedReset = false;
    private final Pattern WAVE_PATTERN = Pattern.compile(".*Wave: (\\d+).*");

    @Provides
    SpawnPredictorConfig providesConfig(ConfigManager configManager) {
        return (SpawnPredictorConfig)configManager.getConfig(SpawnPredictorConfig.class);
    }

    public boolean isFightCavesActive() {
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9551) && this.client.isInInstancedRegion();
    }

    public boolean isInTzhaarArea() {
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9808) && !this.client.isInInstancedRegion();
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.rotationOverlayPanel);
        this.overlayManager.add((Overlay)this.displayModeOverlay);
        this.overlayManager.add((Overlay)this.debugOverlayPanel);
        this.keyManager.registerKeyListener((KeyListener)this);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.rotationOverlayPanel);
        this.overlayManager.remove((Overlay)this.displayModeOverlay);
        this.overlayManager.remove((Overlay)this.debugOverlayPanel);
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.reset();
    }

    private void reset() {
        this.currentUTCTime = -1;
        this.rotationCol = -1;
        this.currentWave = -1;
        this.currentRotation = -1;
        rsVal = -1;
        this.active = false;
        this.hotkeyEnabled = false;
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equalsIgnoreCase("spawnpredictor")) {
            switch (event.getKey()) {
                case "displayMode": 
                case "displayCurrentWaveToggle": 
                case "displayCurrentWaveKey": {
                    this.hotkeyEnabled = false;
                }
            }
        }
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        if (!(this.isFightCavesActive() || this.confirmedReset || !this.isInTzhaarArea() && this.client.isInInstancedRegion() || this.client.getLocalPlayer() == null)) {
            if (this.getRotationConfig(this.client.getLocalPlayer().getName()) != null) {
                this.removeRotationConfig(this.client.getLocalPlayer().getName());
            }
            this.confirmedReset = true;
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            if (event.getGameState() == GameState.HOPPING || event.getGameState() == GameState.LOGIN_SCREEN) {
                this.reset();
                this.confirmedReset = false;
            }
            return;
        }
        if (this.isFightCavesActive() && !this.active) {
            AccountMemory memory = this.getRotationConfig(this.client.getLocalPlayer().getName());
            if (memory != null) {
                this.rotationCol = memory.getRotation();
                this.currentRotation = StartLocations.translateRotation(this.rotationCol);
                this.currentWave = memory.getWave();
            } else {
                this.currentRotation = StartLocations.translateRotation(this.rotationCol);
                this.currentWave = 1;
            }
            if (this.rotationCol == -1 || this.currentRotation == -1) {
                return;
            }
            rsVal = StartLocations.getLookupMap().get(this.currentRotation);
            this.updateWaveData(rsVal);
            this.active = true;
        } else if (!this.isFightCavesActive()) {
            this.reset();
            this.removeRotationConfig(this.client.getLocalPlayer().getName());
        }
    }

    @Subscribe
    private void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().contains("Your TzTok-Jad kill count")) {
            this.removeRotationConfig(this.client.getLocalPlayer().getName());
            return;
        }
        if (this.isFightCavesActive() && this.getCurrentRotation() != -1) {
            if (event.getMessage().contains("The Fight Cave has been paused.")) {
                ++this.currentWave;
                this.saveRotation(this.client.getLocalPlayer().getName(), this.rotationCol, this.currentWave);
                return;
            }
            Matcher waveMatcher = this.WAVE_PATTERN.matcher(event.getMessage());
            if (!waveMatcher.matches()) {
                return;
            }
            this.currentWave = Integer.parseInt(waveMatcher.group(1));
            if (this.currentWave != 0) {
                this.saveRotation(this.client.getLocalPlayer().getName(), this.rotationCol, this.currentWave);
            }
            if (this.currentRotation == 7 && this.currentWave == 3) {
                rsVal = 11;
                this.updateWaveData(rsVal);
            }
        }
    }

    private void updateWaveData(int rsVal) {
        waveData = SpawnPredictorPlugin.calculateSpawns(rsVal);
    }

    private static List<List<FightCavesNpcSpawn>> calculateSpawns(int rsVal) {
        ArrayList<List<FightCavesNpcSpawn>> spawns = new ArrayList<List<FightCavesNpcSpawn>>();
        int currentCycle = rsVal;
        for (FightCavesNpc npc : FightCavesNpc.values()) {
            if (npc == FightCavesNpc.JAD) continue;
            List<List<FightCavesNpcSpawn>> subSpawns = SpawnPredictorPlugin.generateSubSpawns((currentCycle + 1) % 15, npc, spawns);
            ArrayList<FightCavesNpcSpawn> initialSpawn = new ArrayList<FightCavesNpcSpawn>();
            initialSpawn.add(new FightCavesNpcSpawn(npc, currentCycle));
            spawns.add(initialSpawn);
            currentCycle = (currentCycle + 1) % 15;
            spawns.addAll(subSpawns);
            currentCycle = (currentCycle + subSpawns.size()) % 15;
            ArrayList<FightCavesNpcSpawn> postSpawns = new ArrayList<FightCavesNpcSpawn>();
            postSpawns.add(new FightCavesNpcSpawn(npc, currentCycle));
            postSpawns.add(new FightCavesNpcSpawn(npc, (currentCycle + 1) % 15));
            spawns.add(postSpawns);
            currentCycle = (currentCycle + 1) % 15;
        }
        ArrayList<FightCavesNpcSpawn> jadSpawn = new ArrayList<FightCavesNpcSpawn>();
        jadSpawn.add(new FightCavesNpcSpawn(FightCavesNpc.JAD, currentCycle));
        spawns.add(jadSpawn);
        return spawns;
    }

    private static List<List<FightCavesNpcSpawn>> generateSubSpawns(int currentCycle, FightCavesNpc npc, List<List<FightCavesNpcSpawn>> existing) {
        ArrayList<List<FightCavesNpcSpawn>> subSpawns = new ArrayList<List<FightCavesNpcSpawn>>();
        for (List<FightCavesNpcSpawn> existingWave : existing) {
            ArrayList<FightCavesNpcSpawn> newSpawn = new ArrayList<FightCavesNpcSpawn>();
            newSpawn.add(new FightCavesNpcSpawn(npc, currentCycle));
            for (int i = 0; i < existingWave.size(); ++i) {
                FightCavesNpcSpawn existingSpawn = existingWave.get(i);
                newSpawn.add(new FightCavesNpcSpawn(existingSpawn.getNpc(), (currentCycle + i + 1) % 15));
            }
            subSpawns.add(newSpawn);
            currentCycle = (currentCycle + 1) % 15;
        }
        return subSpawns;
    }

    public final LocalTime getUTCTime() {
        return LocalTime.now(ZoneId.of("UTC"));
    }

    public final String getUTCFormatted() {
        if (this.serverTime == -1) {
            return "";
        }
        return this.serverUTCTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    @Schedule(period=500L, unit=ChronoUnit.MILLIS)
    public void updateSchedule() {
        if (this.client.getGameState() != GameState.LOGGED_IN || !this.isInTzhaarArea() || this.client.isInInstancedRegion()) {
            this.serverUTCTime = null;
            this.serverUTCTimeSecondSet = false;
            this.serverTime = -1;
            this.oldServerTime = -1;
            this.serverTimeSecondOffset = -1;
            return;
        }
        int currentLocalSecond = LocalTime.now().getSecond();
        this.serverTime = this.client.getVarbitValue(8354);
        if (!this.serverUTCTimeSecondSet) {
            if (this.oldServerTime > 0 && this.serverTime != this.oldServerTime) {
                this.serverUTCTime = LocalTime.of(this.serverTime / 60, this.serverTime % 60, 0);
                this.serverUTCTimeSecondSet = true;
                this.serverTimeSecondOffset = LocalTime.now().getSecond();
            } else {
                this.serverUTCTime = LocalTime.of(this.serverTime / 60, this.serverTime % 60, currentLocalSecond);
            }
            this.oldServerTime = this.serverTime;
        } else if (this.serverUTCTimeSecondSet && this.serverTimeSecondOffset != -1) {
            this.oldServerTime = this.serverTime;
            if (this.serverTime != this.oldServerTime) {
                this.serverUTCTime = LocalTime.of(this.serverTime / 60, this.serverTime % 60, 0);
                this.serverTimeSecondOffset = LocalTime.now().getSecond();
            } else {
                this.serverUTCTime = LocalTime.of(this.serverTime / 60, this.serverTime % 60, OffsetDateTime.now().plusSeconds(-this.serverTimeSecondOffset).getSecond());
            }
        }
        if (!this.active && this.serverUTCTimeSecondSet) {
            this.rotationCol = this.serverTime % 16;
            int minute = this.serverUTCTime.getMinute();
            this.rotationCol = this.rotationCol == 15 && minute % 2 != 0 || this.rotationCol == 0 && minute % 2 == 0 ? 1 : ++this.rotationCol;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.config.displayCurrentWave() != SpawnPredictorConfig.CurrentWaveDisplayMode.OFF && this.config.displayCurrentWaveKey().matches(e)) {
            switch (this.config.displayCurrentWave()) {
                case FLASH: {
                    this.hotkeyEnabled = true;
                    break;
                }
                case TOGGLE: {
                    this.hotkeyEnabled = !this.hotkeyEnabled;
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.config.displayCurrentWave() != SpawnPredictorConfig.CurrentWaveDisplayMode.OFF && this.config.displayCurrentWave() == SpawnPredictorConfig.CurrentWaveDisplayMode.FLASH && this.config.displayCurrentWaveKey().matches(e)) {
            this.hotkeyEnabled = false;
        }
    }

    private void saveRotation(String name, int rotation, int wave) {
        AccountMemory memory = new AccountMemory(rotation, wave);
        this.setRotationConfig(name, memory);
    }

    AccountMemory getRotationConfig(String name) {
        String json = this.configManager.getConfiguration("spawnpredictor", "spawnpredictor_" + name);
        if (json == null) {
            return null;
        }
        return (AccountMemory)this.gson.fromJson(json, AccountMemory.class);
    }

    void setRotationConfig(String name, AccountMemory memory) {
        String json = this.gson.toJson((Object)memory);
        this.configManager.setConfiguration("spawnpredictor", "spawnpredictor_" + name, json);
        log.info("spawnpredictor: set rotation config for {} with rotation: {} and wave: {}", new Object[]{name, memory.getRotation(), memory.getWave()});
    }

    void removeRotationConfig(String name) {
        if (name == null || this.getRotationConfig(name) == null) {
            return;
        }
        this.configManager.unsetConfiguration("spawnpredictor", "spawnpredictor_" + name);
        log.info("spawnpredictor: removed rotation config for {}", (Object)name);
    }

    public static List<List<FightCavesNpcSpawn>> getWaveData() {
        return waveData;
    }

    public LocalTime getServerUTCTime() {
        return this.serverUTCTime;
    }

    public boolean isServerUTCTimeSecondSet() {
        return this.serverUTCTimeSecondSet;
    }

    public int getCurrentUTCTime() {
        return this.currentUTCTime;
    }

    public int getRotationCol() {
        return this.rotationCol;
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public int getCurrentRotation() {
        return this.currentRotation;
    }

    public static int getRsVal() {
        return rsVal;
    }

    public boolean isHotkeyEnabled() {
        return this.hotkeyEnabled;
    }
}

