/*
 * Decompiled with CFR 0.152.
 */
package com.spawnpredictor;

import com.google.gson.Gson;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="spawnpredictor")
public interface SpawnPredictorConfig
extends Config {
    public static final String GROUP = "spawnpredictor";

    @ConfigItem(name="Debug", keyName="debugOverlay", description="", position=0, hidden=true)
    default public boolean debug() {
        return false;
    }

    @ConfigItem(name="Lobby Rotation Info", keyName="lobbyRotationInfoOverlay", description="- Displays information about the current/upcoming rotation in the lobby area", position=1)
    default public boolean lobbyRotationInfoOverlay() {
        return false;
    }

    @ConfigItem(name="Include UTC Time", keyName="includeUTCTime", description="- Display the UTC Time within the overlay", position=2)
    default public boolean includeUTCTime() {
        return false;
    }

    @ConfigItem(name="Wave Display Mode", keyName="displayMode", description="- Choose the display mode of the overlays", position=3)
    default public DisplayMode displayMode() {
        return DisplayMode.OFF;
    }

    @ConfigItem(name="Display Current Wave with Key", keyName="displayCurrentWaveToggle", description="- Only works with the 'Next Wave' display mode", position=4)
    default public CurrentWaveDisplayMode displayCurrentWave() {
        return CurrentWaveDisplayMode.OFF;
    }

    @ConfigItem(name="Display Key", keyName="displayCurrentWaveKey", description="- Set a key to display the current wave with when held/pressed to toggle", position=5)
    default public Keybind displayCurrentWaveKey() {
        return Keybind.NOT_SET;
    }

    @ConfigItem(name="Overlay Stroke Size", keyName="overlayStrokeSize", description="Sets the stroke size of the tile overlay", position=6)
    @Range(max=3, min=1)
    @Units(value="px")
    default public int overlayStrokeSize() {
        return 2;
    }

    @ConfigItem(name="Multicolor Names", keyName="multicolorNames", description="- Color the overlay names inside the Fight Caves to it's respective color.<br>Example: Current Wave Color = White -> Name = White<br>Next Wave Color = Green -> Name = Green", position=7)
    default public boolean multicolorNames() {
        return false;
    }

    @ConfigItem(name="Current Wave Color", keyName="currentWaveColor", description="- Sets the current wave tile overlay colors", position=8)
    @Alpha
    default public Color currentWaveColor() {
        return Color.WHITE;
    }

    @ConfigItem(name="Next Wave Color", keyName="nextWaveColor", description="- Sets the next wave tile overlay colors", position=9)
    @Alpha
    default public Color nextWaveColor() {
        return Color.GREEN;
    }

    @ConfigItem(name="Account Memory", keyName="accountMemory", description="Handles storing rotation and waves on logout", position=99, hidden=true)
    default public Gson accountMemory() {
        return null;
    }

    public static enum CurrentWaveDisplayMode {
        OFF("Off"),
        FLASH("Flash"),
        TOGGLE("Toggle");

        private final String name;

        public String toString() {
            return this.name;
        }

        private CurrentWaveDisplayMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum DisplayMode {
        OFF("Off"),
        CURRENT_WAVE("Current"),
        NEXT_WAVE("Next"),
        BOTH("Both");

        private final String name;

        public String toString() {
            return this.name;
        }

        private DisplayMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

