/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.utils;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class NumberUtils {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return NumberUtils.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + NumberUtils.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "m");
        suffixes.put(1000000000L, "b");
    }
}

