/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.utils;

import java.time.Duration;

public class DurationUtils {
    public static long toSecondsPart(Duration duration) {
        return duration.getSeconds() % 60L;
    }

    public static long toMinutesPart(Duration duration) {
        return duration.getSeconds() % 3600L / 60L;
    }

    public static long toHoursPart(Duration duration) {
        return duration.getSeconds() / 3600L;
    }

    public static String toSessionTimeString(Duration duration) {
        long totalSeconds = duration.getSeconds();
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static String toCountDownTimeString(Duration duration) {
        long totalSeconds = duration.getSeconds();
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        String timeString = "";
        if (hours > 0L) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }
}

