/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.overlays;

import com.github.iant89.ultimatenmz.UltimateNMZConfig;
import com.github.iant89.ultimatenmz.UltimateNMZPlugin;
import com.github.iant89.ultimatenmz.drivers.ConstantDriver;
import com.github.iant89.ultimatenmz.drivers.SineDriver;
import com.github.iant89.ultimatenmz.drivers.ValueDriver;
import com.github.iant89.ultimatenmz.icons.IconManager;
import com.github.iant89.ultimatenmz.notifications.VisualNotification;
import com.github.iant89.ultimatenmz.notifications.VisualNotificationManager;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class VisualNotificationOverlay
extends OverlayPanel {
    private final Client client;
    private final UltimateNMZConfig config;
    private final UltimateNMZPlugin plugin;
    private final VisualNotificationManager notificationManager;
    private final SkillIconManager skillIconManager;
    private final ItemManager itemManager;
    @Inject
    private IconManager iconManager;
    private ValueDriver iconSizeDriver = new SineDriver(2.0f, 5.0f, 25L);

    @Inject
    private VisualNotificationOverlay(Client client, UltimateNMZConfig config, UltimateNMZPlugin plugin, VisualNotificationManager notificationManager, SkillIconManager skillIconManager, ItemManager itemManager) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.notificationManager = notificationManager;
        this.skillIconManager = skillIconManager;
        this.itemManager = itemManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.HIGH);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Ultimate-NMZ Notification Overlay."));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.visualAlerts() || !this.plugin.isInNightmareZone()) {
            return super.render(graphics);
        }
        if (!this.plugin.getUltimateNmzOverlay().hasNightmareZoneStarted()) {
            return super.render(graphics);
        }
        this.notificationManager.cleanNotifications();
        if (this.notificationManager.getNotificationCount() == 0) {
            return super.render(graphics);
        }
        ArrayList<VisualNotification> notificationList = this.notificationManager.getNotifications();
        notificationList.sort(Comparator.comparingInt(o -> o.getType().getPriority()));
        Iterator<VisualNotification> notificationIterator = notificationList.iterator();
        int x = 0;
        int width = this.client.getCanvasWidth() / notificationList.size();
        while (notificationIterator.hasNext()) {
            VisualNotification visualNotification = notificationIterator.next();
            if (visualNotification.isExpired()) {
                notificationIterator.remove();
                continue;
            }
            ValueDriver opacityDriver = visualNotification.getOpacityDriver();
            if (opacityDriver == null) {
                opacityDriver = new ConstantDriver();
                opacityDriver.setValue(Float.valueOf(1.0f));
            }
            Rectangle notificationBounds = new Rectangle(x, 0, width, this.client.getCanvasHeight());
            graphics.setClip(notificationBounds);
            visualNotification.renderNotification(graphics, notificationBounds);
            graphics.setClip(null);
            BufferedImage icon = this.iconManager.getIconForNotification(visualNotification);
            if (icon != null) {
                Composite originalComposite = graphics.getComposite();
                double iconSize = ((Number)this.iconSizeDriver.getValue()).doubleValue();
                switch (visualNotification.getType()) {
                    case ZAPPER_SPAWNED: 
                    case ULTIMATE_FORCE_SPAWNED: 
                    case POWER_SURGE_SPAWNED: 
                    case RECURRENT_DAMAGE_SPAWNED: {
                        iconSize /= 4.0;
                    }
                }
                int iW = (int)((double)icon.getWidth() * iconSize);
                int iH = (int)((double)icon.getHeight() * iconSize);
                float iconOpacity = 1.0f - ((Number)opacityDriver.getValue()).floatValue();
                if (opacityDriver instanceof ConstantDriver) {
                    iconOpacity = ((Number)opacityDriver.getValue()).floatValue();
                }
                graphics.setComposite(AlphaComposite.getInstance(3, iconOpacity));
                graphics.drawImage(icon, x + width / 2 - iW / 2, this.client.getCanvasHeight() / 2 - iH / 2, iW, iH, null);
                graphics.setComposite(originalComposite);
            }
            x += width;
        }
        return super.render(graphics);
    }
}

