/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.overlays;

import com.github.iant89.ultimatenmz.UltimateNMZConfig;
import com.github.iant89.ultimatenmz.UltimateNMZPlugin;
import com.github.iant89.ultimatenmz.utils.DurationUtils;
import com.github.iant89.ultimatenmz.utils.InventoryUtils;
import com.github.iant89.ultimatenmz.utils.NumberUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.QuantityFormatter;

public class UltimateNMZOverlay
extends OverlayPanel {
    private final Client client;
    private final UltimateNMZConfig config;
    private final UltimateNMZPlugin plugin;
    private boolean nmzStarted = false;
    private long nmzStartTimer = -1L;

    @Inject
    private UltimateNMZOverlay(Client client, UltimateNMZConfig config, UltimateNMZPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setPriority(OverlayPriority.HIGH);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Ultimate-NMZ Overlay."));
    }

    public Dimension render(Graphics2D graphics) {
        Duration overloadDuration;
        if (!this.plugin.isInNightmareZone()) {
            Widget nmzWidget = this.client.getWidget(WidgetInfo.NIGHTMARE_ZONE);
            if (nmzWidget != null) {
                nmzWidget.setHidden(false);
            }
            return null;
        }
        if (!this.nmzStarted && this.nmzStartTimer > -1L && System.currentTimeMillis() > this.nmzStartTimer) {
            this.nmzStarted = true;
            this.nmzStartTimer = -1L;
        }
        if (!this.nmzStarted) {
            return super.render(graphics);
        }
        Widget nmzWidget = this.client.getWidget(WidgetInfo.NIGHTMARE_ZONE);
        if (nmzWidget != null) {
            nmzWidget.setHidden(this.config.removeNMZOverlay());
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text("-- Ultimate NMZ --").color(Color.GREEN).build());
        int currentHP = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        boolean aboveHPThreshold = false;
        boolean belowHPThreshold = false;
        if (this.config.minimumHPNotification() && this.config.maximumHPNotification()) {
            if (currentHP < this.config.minimumHPThresholdValue() && this.config.minimumHPThresholdValue() != -1) {
                belowHPThreshold = true;
            } else if (currentHP > this.config.maximumHPThresholdValue() && this.config.maximumHPThresholdValue() != -1) {
                aboveHPThreshold = true;
            }
        } else if (this.config.minimumHPNotification()) {
            if (currentHP < this.config.minimumHPThresholdValue() && this.config.minimumHPThresholdValue() != -1) {
                belowHPThreshold = true;
            }
        } else if (this.config.maximumHPNotification() && currentHP > this.config.maximumHPThresholdValue() && this.config.maximumHPThresholdValue() != -1) {
            aboveHPThreshold = true;
        }
        Color hpColor = aboveHPThreshold ? Color.RED : (belowHPThreshold ? Color.YELLOW : Color.GREEN);
        String str = ColorUtil.prependColorTag((String)Integer.toString(currentHP), (Color)hpColor);
        int currentPoints = this.client.getVar(3949);
        int totalPoints = currentPoints + this.client.getVar(1060);
        int absorptionPoints = this.client.getVar(3956);
        this.panelComponent.getChildren().add(LineComponent.builder().left("Session:").right(DurationUtils.toSessionTimeString(this.plugin.getSessionDuration())).rightColor(Color.GREEN).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Hitpoints:").right(str).rightColor(hpColor).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("").build());
        if (absorptionPoints == 0) {
            if (InventoryUtils.hasOneOfItems(this.client, 11734, 11735, 11736, 11737)) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Absorption:").right("0").rightColor(Color.RED).build());
            }
        } else if (absorptionPoints <= this.config.absorptionThreshold()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Absorption:").right(QuantityFormatter.formatNumber((long)absorptionPoints)).rightColor(Color.RED).build());
        } else {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Absorption:").right(QuantityFormatter.formatNumber((long)absorptionPoints)).rightColor(Color.GREEN).build());
        }
        Color overloadColor = Color.GREEN;
        if (this.plugin.getOverloadDurationLeft() != null && ((overloadDuration = this.plugin.getOverloadDurationLeft()).toMinutes() > 0L || overloadDuration.getSeconds() > 0L)) {
            if ((long)this.config.overloadRunoutTime() >= overloadDuration.getSeconds()) {
                overloadColor = Color.RED;
            }
            this.panelComponent.getChildren().add(LineComponent.builder().left("Overload:").right(DurationUtils.toCountDownTimeString(overloadDuration)).rightColor(overloadColor).build());
        }
        if (this.config.showPointsPerHour() || this.config.showTotalPoints() || this.config.removeNMZOverlay()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("").build());
        }
        if (this.config.removeNMZOverlay()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Points:").right(NumberUtils.format(currentPoints)).build());
        }
        if (this.config.showPointsPerHour()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Points/Hour:").right(NumberUtils.format(this.plugin.getPointsPerHour())).build());
        }
        if (this.config.showTotalPoints()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Total Points:").right(NumberUtils.format(totalPoints)).build());
        }
        return super.render(graphics);
    }

    public void updateConfig() {
    }

    public boolean hasNightmareZoneStarted() {
        return this.nmzStarted;
    }

    public void nightmareZoneStarted() {
        this.nmzStartTimer = System.currentTimeMillis() + 25000L;
    }

    public void nightmareZoneEnded() {
        this.nmzStarted = false;
        this.nmzStartTimer = -1L;
    }
}

