/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.overlays;

import com.github.iant89.ultimatenmz.UltimateNMZConfig;
import com.github.iant89.ultimatenmz.UltimateNMZPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.MenuAction;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class PowerUpOverlay
extends OverlayPanel {
    public static final int OBJECT_ZAPPER = 26256;
    public static final int OBJECT_POWER_SURGE = 26264;
    public static final int OBJECT_RECURRENT_DAMAGE = 26265;
    public static final int OBJECT_ULTIMATE_FORCE = 26266;
    private final Client client;
    private final UltimateNMZConfig config;
    private final UltimateNMZPlugin plugin;

    @Inject
    private PowerUpOverlay(Client client, UltimateNMZConfig config, UltimateNMZPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setMovable(false);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.HIGH);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Ultimate NMZ Overlay."));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInNightmareZone()) {
            return super.render(graphics);
        }
        this.renderTileObjects(graphics);
        return super.render(graphics);
    }

    public void renderTileObjects(Graphics2D graphics) {
        if (!this.plugin.isInNightmareZone()) {
            return;
        }
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int z = this.client.getPlane();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[z][x][y];
                if (tile == null) continue;
                this.renderGameObjects(graphics, tile, this.client.getLocalPlayer());
            }
        }
    }

    private void renderGameObjects(Graphics2D graphics, Tile tile, Player player) {
        GameObject[] gameObjects = tile.getGameObjects();
        if (gameObjects != null) {
            block6: for (GameObject gameObject : gameObjects) {
                Color objectColor;
                String objectName;
                if (gameObject == null) continue;
                switch (gameObject.getId()) {
                    case 26264: {
                        if (!this.config.drawPowerSurgeLocation()) continue block6;
                        objectName = "POWER SURGE";
                        objectColor = this.config.powerSurgeAlertColor();
                        break;
                    }
                    case 26265: {
                        if (!this.config.drawRecurrentDamageLocation()) continue block6;
                        objectName = "RECURRENT DAMAGE";
                        objectColor = this.config.recurrentDamageAlertColor();
                        break;
                    }
                    case 26256: {
                        if (!this.config.drawZapperLocation()) continue block6;
                        objectName = "ZAPPER";
                        objectColor = this.config.zapperAlertColor();
                        break;
                    }
                    case 26266: {
                        if (!this.config.drawUltimateForceLocation()) continue block6;
                        objectName = "ULTIMATE FORCE";
                        objectColor = this.config.ultimateForceAlertColor();
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                if (!gameObject.getSceneMinLocation().equals((Object)tile.getSceneLocation()) || player.getLocalLocation().distanceTo(gameObject.getLocalLocation()) > 3500) continue;
                LocalPoint lp = gameObject.getLocalLocation();
                Polygon tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)1);
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)tilePoly, (Color)objectColor, (Stroke)new BasicStroke(2.0f));
                Point textLocation = gameObject.getCanvasTextLocation(graphics, objectName, (int)(gameObject.getCanvasTilePoly().getBounds2D().getHeight() + 140.0));
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)objectName, (Color)objectColor);
            }
        }
    }
}

