/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.overlays;

import com.github.iant89.ultimatenmz.UltimateNMZConfig;
import com.github.iant89.ultimatenmz.UltimateNMZPlugin;
import com.github.iant89.ultimatenmz.utils.DurationUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class CountdownOverlay
extends OverlayPanel {
    private final Client client;
    private final UltimateNMZConfig config;
    private final UltimateNMZPlugin plugin;
    private Instant endTime;

    @Inject
    private CountdownOverlay(Client client, UltimateNMZConfig config, UltimateNMZPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setPriority(OverlayPriority.HIGH);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Ultimate-NMZ Overlay."));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.endTime == null) {
            return super.render(graphics);
        }
        long secondsRemaining = DurationUtils.toSecondsPart(Duration.between(Instant.now(), this.endTime));
        if (secondsRemaining > 0L) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("NMZ STARTING IN").build());
            this.panelComponent.getChildren().add(TitleComponent.builder().text(secondsRemaining + " SECOND" + (secondsRemaining > 1L ? "S" : "") + ".").color(Color.GREEN).build());
        } else {
            this.endTime = null;
        }
        return super.render(graphics);
    }

    public void triggerCountdown(Instant endTime) {
        this.endTime = endTime;
    }
}

