/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.notifications;

import com.github.iant89.ultimatenmz.UltimateNMZConfig;
import com.github.iant89.ultimatenmz.notifications.VisualNotification;
import com.github.iant89.ultimatenmz.notifications.VisualNotificationType;
import com.github.iant89.ultimatenmz.utils.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;

public class VisualNotificationManager {
    private static ArrayList<VisualNotification> notificationList = new ArrayList();
    private static HashMap<VisualNotificationType, Long> notificationBlockMap = new HashMap();
    @Inject
    private Client client;
    @Inject
    private UltimateNMZConfig config;

    @Inject
    protected VisualNotificationManager(Client client, UltimateNMZConfig config) {
        this.client = client;
        this.config = config;
    }

    public void blockNotification(VisualNotificationType type, int seconds) {
        this.cleanNotifications();
        if (seconds <= 0) {
            return;
        }
        if (notificationBlockMap.containsKey((Object)type)) {
            notificationBlockMap.remove((Object)type);
        }
        notificationBlockMap.put(type, System.currentTimeMillis() + (long)(seconds * 1000));
    }

    public void addNotification(VisualNotification notification) {
        this.cleanNotifications();
        if (notificationBlockMap.containsKey((Object)notification.getType())) {
            return;
        }
        notificationList.add(notification);
    }

    public synchronized void removeAll() {
        notificationList.clear();
    }

    public synchronized void createNotification(VisualNotificationType type) {
        VisualNotification visualNotification = this.getNotificationByType(type);
        long notificationLength = -1L;
        this.cleanNotifications();
        if (notificationBlockMap.containsKey((Object)type)) {
            return;
        }
        if (visualNotification != null) {
            if (visualNotification.getLength() == -1L) {
                return;
            }
            this.removeNotification(type);
        }
        switch (type) {
            case HP_ABOVE_THRESHOLD: 
            case OVERLOAD_ALMOST_EXPIRED: {
                notificationLength = -1L;
                break;
            }
            case OVERLOAD_EXPIRED: {
                if (!InventoryUtils.hasOneOfItems(this.client, 11730, 11731, 11732, 11733)) {
                    return;
                }
                notificationLength = -1L;
                break;
            }
            case ABSORPTION_BELOW_THRESHOLD: {
                if (!InventoryUtils.hasOneOfItems(this.client, 11734, 11735, 11736, 11737)) {
                    return;
                }
                notificationLength = -1L;
                break;
            }
            case HP_BELOW_THRESHOLD: 
            case ZAPPER_SPAWNED: 
            case ULTIMATE_FORCE_SPAWNED: 
            case POWER_SURGE_SPAWNED: 
            case RECURRENT_DAMAGE_SPAWNED: {
                notificationLength = 10L;
                break;
            }
            default: {
                return;
            }
        }
        if (notificationLength > -1L) {
            notificationLength *= 1000L;
        }
        visualNotification = new VisualNotification(this.config, type, notificationLength);
        notificationList.add(visualNotification);
    }

    public int getNotificationCount() {
        return notificationList.size();
    }

    public synchronized ArrayList<VisualNotification> getNotifications() {
        return new ArrayList<VisualNotification>(notificationList);
    }

    public synchronized void cleanNotifications() {
        notificationList.removeIf(VisualNotification::isExpired);
        for (Map.Entry<VisualNotificationType, Long> entry : notificationBlockMap.entrySet()) {
            if (System.currentTimeMillis() < entry.getValue()) continue;
            notificationBlockMap.remove((Object)entry.getKey());
        }
    }

    public ArrayList<VisualNotification> getNotificationsByPriority(int priority) {
        ArrayList<VisualNotification> priorityList = new ArrayList<VisualNotification>();
        Iterator<VisualNotification> notificationIterator = notificationList.iterator();
        while (notificationIterator.hasNext()) {
            VisualNotification notification = notificationIterator.next();
            if (notification.isExpired()) {
                notificationIterator.remove();
            }
            if (notification.getType().getPriority() != priority) continue;
            priorityList.add(notification);
        }
        return priorityList;
    }

    public synchronized boolean hasNotificationType(VisualNotificationType type) {
        return this.getNotificationByType(type) != null;
    }

    public synchronized VisualNotification getNotificationByType(VisualNotificationType type) {
        for (VisualNotification notification : notificationList) {
            if (notification.getType() != type) continue;
            return notification;
        }
        return null;
    }

    public void removeNotification(VisualNotificationType type) {
        Iterator<VisualNotification> notificationIterator = notificationList.iterator();
        while (notificationIterator.hasNext()) {
            VisualNotification notification = notificationIterator.next();
            if (notification.getType() != type) continue;
            notificationIterator.remove();
            break;
        }
    }

    public void configUpdated() {
        if (!this.config.visualAlerts()) {
            notificationList.clear();
        } else {
            if (!this.config.overloadRunoutNotification()) {
                this.removeNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
            }
            if (!this.config.overloadExpiredNotification()) {
                this.removeNotification(VisualNotificationType.OVERLOAD_EXPIRED);
            }
            if (!this.config.overloadRunoutNotification()) {
                this.removeNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
            }
            if (!this.config.overloadExpiredNotification()) {
                this.removeNotification(VisualNotificationType.OVERLOAD_EXPIRED);
            }
            if (!this.config.absorptionNotification()) {
                this.removeNotification(VisualNotificationType.ABSORPTION_BELOW_THRESHOLD);
            }
            if (!this.config.maximumHPNotification()) {
                this.removeNotification(VisualNotificationType.HP_ABOVE_THRESHOLD);
            }
            if (!this.config.minimumHPNotification()) {
                this.removeNotification(VisualNotificationType.HP_BELOW_THRESHOLD);
            }
            if (!this.config.powerSurgeNotification()) {
                this.removeNotification(VisualNotificationType.POWER_SURGE_SPAWNED);
            }
            if (!this.config.zapperNotification()) {
                this.removeNotification(VisualNotificationType.ZAPPER_SPAWNED);
            }
            if (!this.config.recurrentDamageNotification()) {
                this.removeNotification(VisualNotificationType.RECURRENT_DAMAGE_SPAWNED);
            }
            if (!this.config.ultimateForceNotification()) {
                this.removeNotification(VisualNotificationType.ULTIMATE_FORCE_SPAWNED);
            }
        }
        for (VisualNotification notification : notificationList) {
            notification.configUpdated();
        }
    }

    public void clearNotifications() {
        notificationList.clear();
    }
}

