/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.notifications;

import com.github.iant89.ultimatenmz.UltimateNMZConfig;
import com.github.iant89.ultimatenmz.drivers.ConstantDriver;
import com.github.iant89.ultimatenmz.drivers.SineDriver;
import com.github.iant89.ultimatenmz.drivers.StepDriver;
import com.github.iant89.ultimatenmz.drivers.ValueDriver;
import com.github.iant89.ultimatenmz.notifications.VisualNotificationEffectType;
import com.github.iant89.ultimatenmz.notifications.VisualNotificationSpeed;
import com.github.iant89.ultimatenmz.notifications.VisualNotificationType;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class VisualNotification {
    private VisualNotificationType notificationType;
    private ValueDriver opacityDriver;
    private ValueDriver animationDriver;
    private long notificationLength = -1L;
    private long notificationExpireTime = -1L;
    private boolean notificationExpired = false;
    private boolean notificationVisible = true;
    private long nextFlashTime = -1L;
    private long flashDelay = 500L;
    private UltimateNMZConfig config;

    public VisualNotification(UltimateNMZConfig config, VisualNotificationType type, long length) {
        this.config = config;
        this.notificationType = type;
        this.notificationLength = length;
        if (length != -1L) {
            this.notificationExpireTime = System.currentTimeMillis() + length;
        }
        switch (this.getEffect()) {
            case FADE_IN_OUT: {
                this.opacityDriver = new SineDriver(0.125f, 0.55f, this.getEffectSpeed().getDelay());
                break;
            }
            case FLASH: 
            case SOLID: {
                this.flashDelay = this.getEffectSpeed().getDelay() * 20;
                this.nextFlashTime = System.currentTimeMillis() + this.flashDelay;
                this.opacityDriver = new ConstantDriver(Float.valueOf(0.55f));
                break;
            }
            default: {
                this.opacityDriver = new ConstantDriver(Float.valueOf(1.0f));
            }
        }
        this.animationDriver = new StepDriver(0, 4, 300L);
    }

    public void configUpdated() {
        float previousValue = -1.0f;
        if (this.getOpacityDriver() != null && this.getOpacityDriver() instanceof SineDriver) {
            previousValue = ((SineDriver)this.getOpacityDriver()).getValue().floatValue();
        }
        switch (this.getEffect()) {
            case FADE_IN_OUT: {
                this.opacityDriver = new SineDriver(0.125f, 0.55f, this.getEffectSpeed().getDelay());
                break;
            }
            case FLASH: 
            case SOLID: {
                this.flashDelay = this.getEffectSpeed().getDelay() * 20;
                this.nextFlashTime = System.currentTimeMillis() + this.flashDelay;
                this.opacityDriver = new ConstantDriver(Float.valueOf(0.55f));
                break;
            }
            default: {
                this.opacityDriver = new ConstantDriver(Float.valueOf(1.0f));
            }
        }
        if (this.opacityDriver != null && previousValue > 0.0f) {
            this.opacityDriver.setValue(Float.valueOf(previousValue));
        }
    }

    public VisualNotificationType getType() {
        return this.notificationType;
    }

    public long getLength() {
        return this.notificationLength;
    }

    public boolean isVisible() {
        return this.notificationVisible;
    }

    public void setVisible(boolean visible) {
        this.notificationVisible = visible;
    }

    public void extendLength(long length) {
        this.notificationExpireTime = this.notificationExpireTime == -1L || this.isExpired() ? System.currentTimeMillis() + length : (this.notificationExpireTime += length);
    }

    public void expire() {
        this.notificationExpired = true;
    }

    public boolean isExpired() {
        if (!this.notificationExpired) {
            if (this.notificationExpireTime == -1L) {
                return false;
            }
            if (System.currentTimeMillis() >= this.notificationExpireTime) {
                this.notificationExpired = true;
            }
        }
        return this.notificationExpired;
    }

    public void renderNotification(Graphics2D graphics, Rectangle bounds) {
        switch (this.getEffect()) {
            case FADE_IN_OUT: {
                this.renderFadeNotification(graphics, bounds);
                break;
            }
            case FLASH: {
                this.renderFlashNotification(graphics, bounds);
                break;
            }
            case SOLID: {
                this.renderSolidNotification(graphics, bounds);
            }
        }
    }

    private void renderBorder(Graphics2D graphics, Rectangle bounds, Color color, float size) {
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(size));
        graphics.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        graphics.setStroke(new BasicStroke(1.0f));
    }

    private void renderFadeNotification(Graphics2D graphics, Rectangle bounds) {
        if (this.getOpacityDriver() == null) {
            return;
        }
        Composite originalComposite = graphics.getComposite();
        graphics.setColor(this.getColor());
        graphics.setComposite(AlphaComposite.getInstance(3, ((Float)this.getOpacityDriver().getValue()).floatValue()));
        graphics.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.renderBorder(graphics, bounds, this.getColor(), 2.0f);
        graphics.setComposite(originalComposite);
    }

    private void renderFlashNotification(Graphics2D graphics, Rectangle bounds) {
        if (this.isVisible()) {
            if (System.currentTimeMillis() >= this.nextFlashTime) {
                this.setVisible(false);
                this.nextFlashTime = System.currentTimeMillis() + this.flashDelay;
            }
        } else if (System.currentTimeMillis() >= this.nextFlashTime) {
            this.setVisible(true);
            this.nextFlashTime = System.currentTimeMillis() + this.flashDelay;
        } else {
            return;
        }
        Composite originalComposite = graphics.getComposite();
        graphics.setColor(this.getColor());
        if (this.getOpacityDriver() == null) {
            return;
        }
        graphics.setComposite(AlphaComposite.getInstance(3, ((Float)this.getOpacityDriver().getValue()).floatValue()));
        graphics.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.renderBorder(graphics, bounds, this.getColor(), 2.0f);
        graphics.setComposite(originalComposite);
    }

    public void renderSolidNotification(Graphics2D graphics, Rectangle bounds) {
        Composite originalComposite = graphics.getComposite();
        graphics.setColor(this.getColor());
        if (this.getOpacityDriver() == null) {
            return;
        }
        graphics.setComposite(AlphaComposite.getInstance(3, ((Float)this.getOpacityDriver().getValue()).floatValue()));
        graphics.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.renderBorder(graphics, bounds, this.getColor(), 2.0f);
        graphics.setComposite(originalComposite);
    }

    public Color getColor() {
        switch (this.getType()) {
            case HP_BELOW_THRESHOLD: {
                return this.config.minimumHPAlertColor();
            }
            case HP_ABOVE_THRESHOLD: {
                return this.config.maximumHPAlertColor();
            }
            case ABSORPTION_BELOW_THRESHOLD: {
                return this.config.absorptionAlertColor();
            }
            case OVERLOAD_ALMOST_EXPIRED: {
                return this.config.overloadRunOutColor();
            }
            case OVERLOAD_EXPIRED: {
                return this.config.overloadExpiredColor();
            }
            case ZAPPER_SPAWNED: {
                return this.config.zapperAlertColor();
            }
            case POWER_SURGE_SPAWNED: {
                return this.config.powerSurgeAlertColor();
            }
            case RECURRENT_DAMAGE_SPAWNED: {
                return this.config.recurrentDamageAlertColor();
            }
            case ULTIMATE_FORCE_SPAWNED: {
                return this.config.ultimateForceAlertColor();
            }
        }
        return null;
    }

    public VisualNotificationEffectType getEffect() {
        switch (this.getType()) {
            case HP_BELOW_THRESHOLD: {
                return this.config.minimumHPEffectType();
            }
            case HP_ABOVE_THRESHOLD: {
                return this.config.maximumHPEffectType();
            }
            case ABSORPTION_BELOW_THRESHOLD: {
                return this.config.absorptionEffectType();
            }
            case OVERLOAD_ALMOST_EXPIRED: {
                return this.config.overloadRunOutEffectType();
            }
            case OVERLOAD_EXPIRED: {
                return this.config.overloadExpiredEffectType();
            }
            case ZAPPER_SPAWNED: {
                return this.config.zapperEffectType();
            }
            case POWER_SURGE_SPAWNED: {
                return this.config.powerSurgeEffectType();
            }
            case RECURRENT_DAMAGE_SPAWNED: {
                return this.config.recurrentDamageEffectType();
            }
            case ULTIMATE_FORCE_SPAWNED: {
                return this.config.ultimateForceEffectType();
            }
        }
        return null;
    }

    public VisualNotificationSpeed getEffectSpeed() {
        switch (this.getType()) {
            case HP_BELOW_THRESHOLD: {
                return this.config.minimumHPEffectSpeed();
            }
            case HP_ABOVE_THRESHOLD: {
                return this.config.maximumHPEffectSpeed();
            }
            case ABSORPTION_BELOW_THRESHOLD: {
                return this.config.absorptionEffectSpeed();
            }
            case OVERLOAD_ALMOST_EXPIRED: {
                return this.config.overloadRunOutEffectSpeed();
            }
            case OVERLOAD_EXPIRED: {
                return this.config.overloadExpiredEffectSpeed();
            }
            case ZAPPER_SPAWNED: {
                return this.config.zapperEffectSpeed();
            }
            case POWER_SURGE_SPAWNED: {
                return this.config.powerSurgeEffectSpeed();
            }
            case RECURRENT_DAMAGE_SPAWNED: {
                return this.config.recurrentDamageEffectSpeed();
            }
            case ULTIMATE_FORCE_SPAWNED: {
                return this.config.ultimateForceEffectSpeed();
            }
        }
        return null;
    }

    public ValueDriver getOpacityDriver() {
        return this.opacityDriver;
    }

    public ValueDriver getAnimationDriver() {
        return this.animationDriver;
    }
}

