/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.icons;

import com.github.iant89.ultimatenmz.UltimateNMZConfig;
import com.github.iant89.ultimatenmz.notifications.VisualNotification;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;

public class IconManager {
    @Inject
    private UltimateNMZConfig config;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private ItemManager itemManager;
    private static BufferedImage[] powerupIcons;

    @Inject
    protected IconManager(UltimateNMZConfig config, SkillIconManager skillIconManager, ItemManager itemManager) {
        this.config = config;
        this.skillIconManager = skillIconManager;
        this.itemManager = itemManager;
        this.loadPowerupIcons();
    }

    private void loadPowerupIcons() {
        powerupIcons = new BufferedImage[4];
        IconManager.powerupIcons[0] = this.loadImageFromResources("/zapper.png");
        IconManager.powerupIcons[1] = this.loadImageFromResources("/recurrent_damage.png");
        IconManager.powerupIcons[2] = this.loadImageFromResources("/ultimate_force.png");
        IconManager.powerupIcons[3] = this.loadImageFromResources("/power_surge.png");
    }

    private BufferedImage loadImageFromResources(String url) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(IconManager.class.getResource(url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return image;
    }

    public BufferedImage getIconForNotification(VisualNotification visualNotification) {
        switch (visualNotification.getType()) {
            case ZAPPER_SPAWNED: {
                return powerupIcons[0];
            }
            case RECURRENT_DAMAGE_SPAWNED: {
                return powerupIcons[1];
            }
            case ULTIMATE_FORCE_SPAWNED: {
                return powerupIcons[2];
            }
            case POWER_SURGE_SPAWNED: {
                return powerupIcons[3];
            }
            case HP_BELOW_THRESHOLD: {
                if (this.config.showMinimumHPIcon()) {
                    return this.skillIconManager.getSkillImage(Skill.HITPOINTS);
                }
                return null;
            }
            case HP_ABOVE_THRESHOLD: {
                if (this.config.showMaximumHPIcon()) {
                    return this.skillIconManager.getSkillImage(Skill.HITPOINTS);
                }
                return null;
            }
            case OVERLOAD_ALMOST_EXPIRED: 
            case OVERLOAD_EXPIRED: {
                if (!this.config.showOverloadIcon()) {
                    return null;
                }
                switch (((Number)visualNotification.getAnimationDriver().getValue()).intValue()) {
                    case 0: {
                        return this.itemManager.getImage(11730);
                    }
                    case 1: {
                        return this.itemManager.getImage(11731);
                    }
                    case 2: {
                        return this.itemManager.getImage(11732);
                    }
                    case 3: {
                        return this.itemManager.getImage(11733);
                    }
                    case 4: {
                        return this.itemManager.getImage(229);
                    }
                }
                return null;
            }
            case ABSORPTION_BELOW_THRESHOLD: {
                if (!this.config.showAbsorptionIcon()) {
                    return null;
                }
                switch (((Number)visualNotification.getAnimationDriver().getValue()).intValue()) {
                    case 0: {
                        return this.itemManager.getImage(11734);
                    }
                    case 1: {
                        return this.itemManager.getImage(11735);
                    }
                    case 2: {
                        return this.itemManager.getImage(11736);
                    }
                    case 3: {
                        return this.itemManager.getImage(11737);
                    }
                    case 4: {
                        return this.itemManager.getImage(229);
                    }
                }
                return null;
            }
        }
        return null;
    }
}

